#!/usr/bin/perl

# I have written a little perl script that runs the test suite in
# parallel on suitable machines. The syntax is:
#
# run_parallel.pl cloudy.exe 16
#
# where the first parameter is the name of the Cloudy executable. It
# should either be in your search path, or the full pathname should
# be used. The second number is the number of processors to use.
#
# The script uses "gmake" (GNU make) to run the test cases. In case
# that doesn't exist, you can try replacing the two calls below with
# "make". If the version is not too old, that should work as well.
# The script may need some other tinkering too, but I find it very
# useful here.
# Peter van Hoof

if( "$ARGV[0]" eq "" ) {
    print "The name for the cloudy binary must be supplied...\n";
    exit;
}

if( "$ARGV[1]" eq "" ) {
    print "The number of processors must be supplied...\n";
    exit;
}

# clean up first
while( defined( $input = glob("*") ) ) {
    @ll = split( /\./, "$input" );
    if( $input eq "Makefile" || ( $#ll == 1 && $ll[$#ll] eq "out" ) ) {
	print "deleting $input...\n";
	unlink "$input";
    }
}

$all = "all: ";
$rules = "";
$i = 0;

# this funny sequence is to assure that the heavy jobs are upfront...
while( defined( $input = glob("o*.in r*.in h*.in b*.in t*.in k*.in f*.in n*.in [ac-egijlmpqsu-zA-Z]*.in") ) ) {
    $i++;
    $output = $input;
    $output =~ s/\.in/.out/gi;
    $all = "$all$output ";
    if( $i%4 == 0 ) {
	$all = "$all\\\n\t";
    }
    $rules = "$rules$output: $input\n";
    $rules = "$rules\t$ARGV[0] < $input > $output\n"
}
open( foo, ">Makefile" );
print foo $all;
print foo "\n";
print foo $rules;
close foo;

# this does the heavy lifting...
# use make instead if gmake doesn't exist on your system
system "gmake -i -j $ARGV[1]";

if( $ARGV[1] > 1 ) {
# just in case transread was run before transpunch was complete
   unlink "transread.out";
# this will also rerun optimal.in, hence parallel mode...
# use make instead if gmake doesn't exist on your system
   system "gmake -i -j $ARGV[1]";
}

# now do the checking
system "./checkall.pl";
