#!/usr/bin/perl -w

#**********************************************************************#
#*  Perl script to check the current itr/zn and execution time of a   *#
#*  model with its previous itr/zn and execution time                 *#
#*  If the increase is above a set threshold percentage it sends a    *#
#*  mail stating so. It also creates a itrlogs/ directory and keeps   *#
#*  the log of the itr/zn and execution time of the models, every     *#
#*  time the models are executed. The percentage increse in time is   *#
#*  recorded in the file auto/itrzn.log                               *#
#*  								      *#
#*  Program written by Geetashree Chakravorty, Graduate Student       *#
#*  Computer Science Department, University of Kentucky		      *#
#*  in the year 2002 for Dr. Gary Ferland. Modified: August,2003      *#
#**********************************************************************#


# Common directory
$curr_dir = "c://projects//cloudy//current//tsuite";
#$curr_dir = "/home62/guests/geetac/PROJECT2003/proj1";

# Directory to store all the log files
$lgdir = 'itrlogs/';

if ( !chdir ($curr_dir))
{
   printf (" invalid directory\n");
   exit;
}

# If itrlogs/ directory not present then create one
if ( !-e $lgdir)
{
  system "mkdir $lgdir";
}

# move to dir with all the current models
if ( !chdir ( "$curr_dir/auto" ) )
{
   printf (" invalid directory\n");
   exit;
}

$tlog = 'itrzn.log'; # File to keep record of recent execution time and itr/zn
$efile = 'mailitr.log'; # File where the mail format is stored
$exitr= 'extime_itrzn.log';
$tholditr = 5;
$tholdetime = 10;
$flag=0;
$no_itr=0;
$no_extime=0;

# Open the output files
open (LGFILE, ">$tlog");
open (ELOG, ">$efile");
open (EXITR, ">$exitr");
print ELOG "List of models with increase in itr/zn and/or execution time\n\n";
print EXITR "Model\tExectime\titr/zn\n";

print LGFILE "Records of itr/zn and Exectime of models if .bak file exists";
print LGFILE "\n************************************************************";

# Scans the .out files
while (defined ($ofile = glob ("*.out")))
{
   $bfile = $ofile;
   $bfile =~s/\.out/\.bak/;    # Substitutes '.out' by '.bak' in $bfile

# Creates a '.log' file having same name as .out. Saves .log file in
# directory /logs
   open (OUTFILE,"$ofile");
   $lfile = $ofile;
   $lfile =~s/\.out/\.log/;
   $lfile =~s/$lfile/$curr_dir\/$lgdir\/$lfile/;
   $present=0;
   if(-e $lfile)
   {
     $present=1;  # Variable to check if the model file is present

# Opening the .log files in read mode to get the average of last 10 execution times
     open (LFILE, "$lfile");
     $count=0;

     while($log = <LFILE>)
     {
       $log=~s/(.*Exectime\t\s)(\d*\.\d*|\d*)(.*)/$2/;
       $exectime[$count] = $log;
       $count = $count + 1;
     }
     close(LFILE);
   }
   else
   {
    print "No files present";
   }

   if($present==1)
   {
     $total = 0;
     if($count>10)
     {
       for($i = $count-1; $i> ($count-11); $i = $i-1)
       {
         $total = $total + $exectime[$i];
       }
       $ave = $total / 10; # Average execution time of the last 10 extries of the model log file
     }
     else
     {
       for($i = $count-1; $i>-1; $i = $i-1)
       {
         $total = $total + $exectime[$i];
       }
       if($count>1)
       {
         $ave = $total / ($count-1); # Average execution time of the last few extries of the model log file
       }
       else
       {
         $ave=$total;
       }
     }# End if-else
   }# End if $present

   # Opening the .log files in append mode
   open (LOGFILE, ">>$lfile");

# get current time and date
  ($sec,$min,$hour,$mday,$mon,$year) = localtime(time);
   $mon = $mon+1; #Since month returned is 1 less than actual
   $year =~s/^\d//;
   print LOGFILE "Date\t$mon/$mday/$year\tTime\t$hour:$min:$sec";


# Checks and computes if .bak file exists
   if (-e $bfile)
   {
      open (BKFILE,"$bfile");
      $mo = $ofile;
      $mo =~s/\.out//;        # removes '.out'
      print LGFILE "\nModel             :  $mo\n";

# Gets itr/zn and execution time from .bak file. Extracts the
# digits  only and ignores everything else
      while ($bk = <BKFILE>)
      {
         if ($bk=~/itr\/zn\:/)
	 {
	    $prev_itr = $bk;
            $prev_itr =~s/(.*itr\/zn\:)(\s\d*\.\d*|\d*\.\d*)(\s*.*)/$2/gi;  # gives the itr/zn
            $prev_itr =~s/\n//;
            print LGFILE "Previous itr/zn   :  $prev_itr\t";
         }
         elsif ($bk=~/ExecTime/)
         {
            $prev_etime = $bk;
            $prev_etime =~s/.*ExecTime//gi;  # gives the execution time
            print LGFILE "Previous Exectime : $prev_etime";
         }
      }

# Gets itr/an and execution time from .out file
      while ($new = <OUTFILE>)
      {
         if ($new=~/itr\/zn\:/)
	 {
       	    $curr_itr = $new;
            $curr_itr =~s/(.*itr\/zn\:)(\s\d*\.\d*|\d*\.\d*)(\s*.*)/$2/gi;  # gives the itr/zn
            $curr_itr =~s/\n//;
            print LGFILE "New itr/zn        :  $curr_itr\t";
	 }
         elsif ($new=~/ExecTime/)
         {
            $curr_etime = $new;
            $curr_etime =~s/.*ExecTime//gi;  # gives the execution time
            print LGFILE "New Exectime      : $curr_etime";
         }
      }

# Calculates difference between itr/zn
      $diff_itr =   $curr_itr - $prev_itr;
      printf(LGFILE "Difference in itr/zn: %.2f\n", $diff_itr);



# Checking if present itr/zn is greater than previous itr/zn
      if ($diff_itr !~/^-/)
      {
        if ($prev_itr > 0)
        {
          $ptage = ($diff_itr / $prev_itr) * 100;
          $ptage = sprintf "%.2f", $ptage;
          if ($ptage > $tholditr)
          {
            print LGFILE "% increase of itr/zn which is beyond the set threshold of 5:  $ptage \n";

	    $itr[$no_itr]="$mo\t$ptage%";	# Array to store model itr/zn info
	    $no_itr = $no_itr + 1;
	    $flag = 1;
          }#end of if
        }#end of if
      }#end of if

      if($present == 1)
      {
# Calculates the increase in execution time
        $diff_etime = $curr_etime - $ave;
        printf(LGFILE "Increase/Decrease in execution time from the average: %.2f\n", $diff_etime);

# Checking if present execution time is greater than 10% increase of the average of last 10 execution times
        if ($diff_etime >0)
        {
          if ($ave > 0)
          {
            $ptage = ($diff_etime / $ave) * 100;
	    $ptage = sprintf "%.2f", $ptage;

            if ($ptage > $tholdetime)
            {
              print LGFILE "% increase in execution time which is more the set threshold of 10 percent:  $ptage \n";
	      $extime[$no_extime]="$mo\t$ptage%";	# Array to store model execution time info
	      $no_extime = $no_extime + 1;
	      $flag = 1;
            }#end of if
          }#end of if
        }#end of if
      }# End if $present
    }

# Prints the itr/zn and execution time to the .log file
    $curr_etime =~s/\n//;
    print LOGFILE "\t Exectime\t$curr_etime\titr/zn\t$curr_itr\n";
    print EXITR "$mo\t$curr_etime\t$curr_itr\n";
    close (LOGFILE);
}# End of while

print ELOG "Models with 10% increase in ExecTime than the average of previous 10 models:\n";
print ELOG "---------------------------------------------------------------------------\n";
for( $noe=0; $noe<$no_extime; ++$noe){
   print ELOG "$extime[$noe]\n";
}
print ELOG "\n\n\nModels with 5% increase than previous itr/zn):\n";
print ELOG "-------------------------------------------------\n";
for( $noi=0; $noi<$no_itr; ++$noi){
   print ELOG "$itr[$noi]\n";
}
 close (EXITR);
 close (BKFILE);
 close (OUTFILE);
 close (LGFILE);
 close (ELOG);
 
# Checks if there is any model which took more time than the threshold.
# If yes than send a mail.
if (-e $efile){
  if($flag == 1){
# Path set to use Perl mail utility SENDMAIL
 #   $sendmailpath="/usr/sbin/sendmail";
 #   open(SENDMAIL, "|$sendmailpath -t");

 #  $from = "gary\@pa.uky.edu";
 #  $to = "gary\@pa.uky.edu";
 #   $subject = "Incease in execution time";

# For Windows machines
   system("c:\\u\\blat\\blat.exe $efile -t gary\@pa.uky.edu -s \"Increase in exe time and itr/zn found in automatic testing\" " );

# For Unix machines
 #   open (ELOG,"$efile");
 #   print SENDMAIL "Subject: $subject\n";
 #   print SENDMAIL "From: $from\n";
 #   print SENDMAIL "To: $to\n\n";
 #   while (<ELOG>){
 #     print SENDMAIL "$_";
 #   }
 #   close(ELOG);
  } # End of if flag
} # End of if efile
unlink($efile);
# End of program

