/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*Zerologic set initial values for logical variables 
 * this is called before any commands are parsed */
#ifdef _MSC_VER
#	pragma warning( disable : 4305 )/* disable const double to float warning in MS VS - 
									   very large number of warns result */
#endif
#include "cddefines.h"
#include "kshllenr.h"
#include "map.h"
#include "abund.h"
#include "optimize.h"
#include "prt.h"
#include "extinc.h"
#include "plot.h"
#include "dump.h"
/*  */
/* following used to enter total predicted continuum into emission line array 
 * actually entered into line array in lineset1
 */
#include "predcont.h"
/* energies where diffuse continuuum is to be entered into line array 
 * variables are declared in predcont.h, where array dimensioned 
 * NB - if these numbers change, the wavelength in the printout will change 
 * too, since the wavelength is derived form this */
/* >>>chng 99 mar 23, adjusted energies so that wavelength line list is
 * the same as it was in C90 - small changes were caused by going over
 * to proper rydberg constant */
float EnrPredCont[NPREDCONT] = {
	  7.445e-04 
	, 1.498e-03 
	, 2.211e-03 
	, 2.952e-03 
	, 3.677e-03 
	, 3.7501e-03 /* Ney-Allen */
	, 3.9915e-03 /* Ney-Allen */
	, 4.2543e-03 /* Ney-Allen */
	, 4.314e-03 
	, 4.6446e-03 /* Ney-Allen */
	, 5.162e-03 
	, 5.2462e-03 /* Ney-Allen */
	, 5.8079e-03 /* Ney-Allen */
	, 6.240e-03 
/* 	, 7.320e-03  */
	, 7.3312e-03 /* Ney-Allen */
	, 7.9936e-03 /* Ney-Allen */
	, 8.7119e-03 /* Ney-Allen */
	, 9.6125e-03 /* Ney-Allen */
	, 9.77243e-03
	, 1.1099e-02 /* Ney-Allen */
	, 1.2022e-02 /* Ney-Allen */
	, 1.29253e-02 
	, 2.2152e-02 
	, 3.92044e-02 
	, 5.54593e-02 
	/* next two either side of n=4 edge of hydrogen, set to 1.5% off either direction*/
	/* >>chng 00 sep 18, had been too close in energy */
	, 6.1563e-02 
	, 6.3437e-02 
	, 8.1460e-02 
	/* >>chng 00 sep 14, changed energies of paschen jump to be farther away as
	 * per note on BJ */
	, 0.1094 
	, 0.1128 
	, 0.14675 
	, 0.18653 
	/* >>chng 00 sep 14, next two energies changed since they were too close to BJ
	 * and so both ended up shortward of limit*/
	, 0.246   /* these two are the Balmer jump, below and above. */
	, 0.254  /* continuum binning not much better than 1% so offset energyies by more */
	, 0.375  /* peak on two photon continuum */
	, 0.38096 
	, 0.43994 
	, 0.44394 
	, 0.50811 
	, 0.57489
	, 0.62487 
	, 0.67155 
	, 0.70244 
	, 0.72163 
	, 0.74812 
	, 0.76172 
	, 0.77551 
	, 0.79681 
	, 0.81859 
	, 0.8260 
	, 0.84859 
	, 0.85618 
	, 0.87967 
	, 0.911267 /*exactly 1000A */ 
	/* points on either side of Lyman jump,
	 * energies changed to be robust when energy grid changes,
	 * grid resolution is about 1%, so change from 0.99783 and 1.000
	 * to 1 +/- 1.5%
	 * >>chng 00 sep 23 change wavelength points for next two */
	, 0.985 
	, 1.015 
	, 1.199 
	, 1.299 
	, 1.4984 
	, 1.58441 
	/* points on either side of Lyman jump,
	 * energies changed to be robust when energy grid changes,
	 * grid resolution is about 1%, so change from 1.80433 and 1.809
	 * to 1.807 +/- 1.5%
	 * >>chng 00 sep 23 change wavelength points for next two */
	, 1.780 
	, 1.834 
	, 2.283};

long int ipPredCont[NPREDCONT];
#include "heavy.h"
#include "fudgec.h"
#include "iterations.h"
#include "noexec.h"
#include "reason.h"
#include "rt.h"
#include "trace.h"
#include "magnetic.h"
#include "hextra.h"
#include "zero.h"
/*
 * long names of elements 
 * ok here since never change */
/*#include "elementnames.h"*/
struct /*t_elementnames*/ {

/* definition of this is in zerologic, where it is also initialized
 * THIS FILE MUST BE KEPT PARALLEL WITH THE DEFINITIOND IN zerologic.c */
	/* names are LIMELM+2 since c12o and c13o are last two */
	char chElementName[LIMELM+3][11] ;

	char chElementNameShort[LIMELM+3][5] ;

	/* symbols for elements, used in various printouts */
	char chElementSym[LIMELM+3][3] ;

	/* ionization stages */
	char chIonStage[LIMELM+4][3] ;

	/* string giving ionization stage as roman numerals */
	char chIonRoman[LIMELM+4][7];

} elementnames = {

	/*char chElementName[LIMELM+2][11] = */
	{
	 "Hydrogen  " ,
	 "Helium    " ,
	 "Lithium   " ,
	 "Beryllium " ,
	 "Boron     " ,
	 "Carbon    " ,
	 "Nitrogen  " ,
	 "Oxygen    " ,
	 "Fluorine  " ,
	 "Neon      " ,
	 "Sodium    " ,
	 "Magnesium " ,
	 "Aluminium " ,
	 "Silicon   " ,
	 "Phosphorus" ,
	 "Sulphur   " ,
	 "Chlorine  " ,
	 "Argon     " ,
	 "Potassium " ,
	 "Calcium   " ,
	 "Scandium  " ,
	 "Titanium  " ,
	 "Vanadium  " ,
	 "Chromium  " ,
	 "Manganese " ,
	 "Iron      " ,
	 "Cobalt    " ,
	 "Nickel    " ,
	 "Copper    " ,
	 "Zinc      " ,
	 "C12O18    " ,
	 "C13O18    " ,
	 "H2        " 
	},

	 /*char chElementNameShort[LIMELM][5] = */
	 {
 	 "HYDR" ,
	 "HELI" ,
	 "LITH" ,
	 "BERY" ,
	 "BORO" ,
	 "CARB" ,
	 "NITR" ,
	 "OXYG" ,
	 "FLUO" ,
	 "NEON" ,
	 "SODI" ,
	 "MAGN" ,
	 "ALUM" ,
	 "SILI" ,
	 "PHOS" ,
	 "SULP" ,
	 "CHLO" ,
	 "ARGO" ,
	 "POTA" ,
	 "CALC" ,
	 "SCAN" ,
	 "TITA" ,
	 "VANA" ,
	 "CHRO" ,
	 "MANG" ,
	 "IRON" ,
	 "COBA" ,
	 "NICK" ,
	 "COPP" ,
	 "ZINC" ,
	 "12CO" ,
	 "13CO" ,
	 "H2  " 
	 },

	/* symbols for elements, used in various printouts */
	 /*char elementnames.chElementSym[LIMELM][3] = */
	 { 
		"H " ,
		"He" ,
		"Li" ,
		"Be" ,
		"B " ,
		"C " ,
		"N " ,
		"O " ,
		"F " ,
		"Ne" ,
		"Na" ,
		"Mg" ,
		"Al" ,
		"Si" ,
		"P " ,
		"S " ,
		"Cl" ,
		"Ar" ,
		"K " ,
		"Ca" ,
		"Sc" ,
		"Ti" ,
		"V " ,
		"Cr" ,
		"Mn" ,
		"Fe" ,
		"Co" ,
		"Ni" ,
		"Cu" ,
		"Zn" ,
		"12" ,
	    "13" ,
	    "H2"} ,

	/* ionization stages */
	 /*char chIonStage[LIMELM+1][3] =*/
		{
		" 1" ,
		" 2" ,
		" 3" ,
		" 4" ,
		" 5" ,
		" 6" ,
		" 7" ,
		" 8" ,
		" 9" ,
		"10" ,
		"11" ,
		"12" ,
		"13" ,
		"14" ,
		"15" ,
		"16" ,
		"17" ,
		"18" ,
		"19" ,
		"20" ,
		"21" ,
		"22" ,
		"23" ,
		"24" ,
		"25" ,
		"26" ,
		"27" ,
		"28" ,
		"29" ,
		"30" ,
		"31" ,
		/* this is special for molecule */
		"CO",
		"CO",
		"H2"
		} ,

	 /* ionization stages as roman numeral */
	 /*char chIonRoman[LIMELM+1][7] =*/
		{
		"I" ,
		"II" ,
		"III" ,
		"IV" ,
		"V" ,
		"VI" ,
		"VII" ,
		"VIII" ,
		"IX" ,
		"X" ,
		"XI" ,
		"XII" ,
		"XIII" ,
		"XIV" ,
		"XV" ,
		"XVI" ,
		"XVII" ,
		"XVIII" ,
		"XIX" ,
		"XX" ,
		"XXI" ,
		"XXII" ,
		"XXIII" ,
		"XXIV" ,
		"XXV" ,
		"XXVI" ,
		"XXVII" ,
		"XXVIII" ,
		"XXIX" ,
		"XXX" ,
		"XXXI" ,
		/* this is special for molecule */
		"  ",
		"  ",
		"  "
		} 
	};

void Zerologic(void)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>Zerologic()\n", debug_fp );
#	endif

	/* parameters having to do with thermal map */
	map.RangeMap[0] = 10.;
	map.RangeMap[1] = .99e10;
	/* >>chng 04 jun 16, had been 9999, was accidentally hit once,
	 * reset to -1 to indicate not to be used */
	/*map.MapZone = 9999;*/
	map.MapZone = -1;
	map.lgMapOK = TRUE;
	map.lgMapDone = FALSE;
	map.nMapStep = 20;
	/* will be reset to positive number when map actually done */
	map.nMapAlloc = 0;
	map.nmap = 0;

	/* upper limit to energies of inner shell opacities in ryd
	 * this is 1 mev by default */
	KshllEnr.EnergyKshell = 7.35e4;

	dump.nzdump = -100;

	/* constant for the extinguish command */
	extinc.excolm = 0.;
	extinc.exleak = 0.;
	extinc.exlow = 1.;
	/* the constant that multiplies the column density to get optical depth */
	extinc.cnst_col2optdepth = 6.22e-18f ;
	/* the power on the energy */
	extinc.cnst_power = -2.43f ;

	/* list of shells, 1 to 7 */
	strcpy( Heavy.chShell[0], "1s" );
	strcpy( Heavy.chShell[1], "2s" );
	strcpy( Heavy.chShell[2], "2p" );
	strcpy( Heavy.chShell[3], "3s" );
	strcpy( Heavy.chShell[4], "3p" );
	strcpy( Heavy.chShell[5], "3d" );
	strcpy( Heavy.chShell[6], "4s" );

	/* zero out diffuse recombinaiton emission arrays */
	for( i=0; i < LIMELM; i++ )
	{
		int j;
		for( j=0; j < (LIMELM - 1); j++ )
		{
			Heavy.xLyaHeavy[i][j] = 0.;
		}
	}

	noexec.lgNoExec = FALSE;

	/* default no printing of optical depths, TooFaint is .1 */
	prt.lgPrtTau = FALSE;
	prt.PrtTauFnt = 0.1;
	prt.lgPrtShort = FALSE;
	prt.TooFaint = 1e-3;
	prt.lgFaintOn = TRUE;
	prt.lgFntSet = FALSE;

	/* if true then print main block of lines as array,
	 * set false with print lines column, will then
	 * do a single column of lines */
	prt.lgPrtLineArray = TRUE;
	/* when printing a column this is option to print linear rather than log */
	prt.lgPrtLineLog = TRUE;

	/* print ages */
	prt.lgPrnAges = FALSE;
	/* print column densities */
	prt.lgPrintColumns = TRUE;
	/* option to sort lines by wavelength, print sort command */
	prt.lgSortLines = FALSE;
	prt.lgPrtMaser = FALSE;
	prt.lgPrintTime = TRUE;
	
	prt.lgPrtCont = FALSE;
	prt.lgPrnDiff = FALSE;
	prt.lgPrnPump = FALSE;
	prt.lgPrnInwd = FALSE;
	prt.lgPrnColl = FALSE;
	prt.lgPrnHeat = FALSE;
	/* >>chng 00 dec 08, these determine the standard items included in "nFnu", PvH */
	prt.lgSourceReflected = TRUE;
	prt.lgSourceTransmitted = FALSE;
	prt.lgDiffuseInward = TRUE;
	prt.lgDiffuseOutward = TRUE;
	prt.lgPrtLastIt = FALSE;
	prt.lgOnlyZone = FALSE;
	prt.lgOnlyHead = FALSE;
	prt.lgPrtStart = FALSE;
	prt.nstart = 0;

	/* turn off printing of heating agents */
	prt.lgPrintHeating = FALSE;
	prt.lgPrtArry = FALSE;

	/* print line flux at earth */
	prt.lgPrintFluxEarth = FALSE;

	/* print line surface brightness, def sr, option arcsec */
	prt.lgSurfaceBrightness = FALSE;
	prt.lgSurfaceBrightness_SR = TRUE;

	fudgec.nfudge = 0;

	for( i=0; i < NFUDGC; i++ )
	{
		fudgec.fudgea[i] = 0.;
	}

	for( i=0; i < ITRDIM; i++ )
	{
		iterations.IterPrnt[i] = 10000;
	}
	iterations.itermx = 0;
	iteration = 0;

	hextra.TurbHeat = 0.;
	/* >>chng 01 feb 22, had set this to 1e30, change to 0 as sentinal that is not used */
	hextra.turrad = 0.;
	hextra.turback = 0.;
	hextra.cryden = 0.;
	hextra.cryden_ov_background = 0.;
	/* default cosmic ray background */
	/* >>chng 99 jun 24, slight change to value
	 * quoted by 
	 * >>refer	cosmic ray	ionization rate	McKee, C.M., 1999, astro-ph 9901370
	 * this will produce a total
	 * secondary ionization rate of 2.5e-17 s^-1, as tested in 
	 * tsuite cosmicray.in.  If each ionization produces 2.4 eV of heat,
	 * the background heating rate should be 9.6e-29 * n*/
	/* >>chng 04 jan 26, update cosmic ray ionization rate for H0 to
	 * >>refer	cosmicray	ionization	Williams, J.P., Bergin, E.A., Caselli, P., 
	 * >>refercon	Myers, P.C., & Plume, R. 1998, ApJ, 503, 689,
	 * H0 ionization rate of 2.5e-17 s-1 and a H2 ionization rate twice this
	 * >>chng 04 mar 15, comment said 2.5e-17 which is correct, but code produce 8e-17,
	 * fix back to correct value 
	 */
	hextra.background = 2.25e-9f * 0.8848f;
	hextra.crpowr = 0.;
	hextra.crtemp = 0.;

	/* parameters having to do with magnetic field */
	Magnetic_init();

	strcpy( reason.chReason, "reason not specified." );

	/* following were block data logic */
	rt.lgStarkON = TRUE;
	/*rt.nLineContShield = LINE_CONT_SHIELD_PESC;*/
	/* >>chng 04 jun 12, change from pesc to federman form of shielding function */
	rt.nLineContShield = LINE_CONT_SHIELD_FEDERMAN;

	optimize.lgVaryOn = FALSE;

	trace.lgSecIon = FALSE;
	trace.lgTrOvrd = TRUE;
	trace.lgTraceInput = FALSE;
	trace.lgOpacBug = FALSE;
	trace.lgTrConvg = 0;
	trace.lgTr8446 = FALSE;
	trace.lgTrLevN = FALSE;
	trace.lgTrGant = FALSE;
	trace.lgOptcBug = FALSE;
	trace.lgTrace3Bod = FALSE;
	trace.lgOTSBug = FALSE;
	trace.lgTr_CO_Mole = FALSE;
	trace.lgTr_H2_Mole = FALSE;
	trace.lgHeatBug = FALSE;
	trace.lgHeavyBug = FALSE;
	trace.lgBug2nu = FALSE;
	trace.lgDrBug = FALSE;
	trace.lgPtrace = FALSE;
	trace.lgDrv_cdLine = FALSE;
	trace.lgDustBug = FALSE;
	trace.lgComBug = FALSE;
	trace.lgHeBug = FALSE;
	trace.lgCarBug = FALSE;
	trace.lgCalBug = FALSE;
	trace.lgConBug = FALSE;
	trace.lgNeBug = FALSE;
	trace.lgFeBug = FALSE;
	trace.lgHBug = FALSE;
	trace.lgTrLine = FALSE;
	trace.lgHe1Bug = FALSE;
	trace.lgHe2Bug = FALSE;
	trace.lgHe3Bug = FALSE;
	trace.nznbug = 10000;
	trace.npsbug = 10000;
	trace.lgTrace = FALSE;
	trace.lgPointBug = FALSE;
	trace.lgNeonBug = FALSE;
	trace.lgCoolTr = FALSE;
	trace.lgTrDiff = FALSE;
	trace.lgIsoTraceFull[ipH_LIKE] = FALSE;
	trace.lgIsoTraceFull[ipHE_LIKE] = FALSE;

	/* parameters dealing with printer plots */
	for( i=0; i < NDPLOT; i++ )
	{
		plotCom.lgPltTrace[i] = FALSE;
	}

	/* this says what types of printer plots we will make */
	for( i=0; i < NDPLOT; i++ )
	{
		strcpy( plotCom.chPType[i], "NONE" );
	}
	plotCom.lgPlotON = FALSE;

#	ifdef DEBUG_FUN
	fputs( " <->Zerologic()\n", debug_fp );
#	endif
	return;
}

/*ZeroAbund set initial abundances for different mixes */
void ZeroAbund(void)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ZeroAbund()\n", debug_fp );
#	endif

	/* solar abundances 
	 * >>refer	solar	abund	Grevesse, N., & Sauval, A.J., 2001, Space Science Review, 85, 161-174 */
	/* >>chng 02 aug 20, update to these values */
	abund.SolarSave[ipHYDROGEN] = 1.0;
	abund.SolarSave[ipHELIUM] = 0.100;
	abund.SolarSave[ipLITHIUM] = 2.04e-9;
	abund.SolarSave[ipBERYLLIUM] = 2.63e-11;
	abund.SolarSave[ipBORON] = 6.17E-10;
	/* >>chng 02 jul 30, from 3.55 to 2.45, */
	/* >>refer	C	abund	Allende Prieto, C., 
	 * >>refercon	Lambert, D.L., & Asplund, M., 2002, ApJ, 573, L137 */
	abund.SolarSave[ipCARBON] = 2.45e-4;
	/* >>chng 02 jul 30, from 9.33 to 8.53, */
	/* >>refer	N	abund	Holweger, H., 2001, Joint SOHO/ACE workshop Solar and Galactic 
	 * >>refercon	Composition. Edited by Robert F. Wimmer-Schweingruber. Publisher: 
	 * >>refercon	American Institute of Physics Conference proceedings vol. 598 location: Bern, 
	 * >>refercon	Switzerland, March 6 - 9, 2001., p.23 */
	abund.SolarSave[ipNITROGEN] = 8.51e-5;
	/* >>chng 02 jul 30, from 7.41 to 4.90, */
	/* >>refer	O	abund	Allende Prieto, C., 
	 * >>refercon	Lambert, D.L., & Asplund, M., 2001, ApJ, 556, L63 */
	abund.SolarSave[ipOXYGEN] = 4.90e-4;
	abund.SolarSave[ipFLUORINE] = 3.02e-8;
	/* >>chng 02 jul 30, from 1.17 to 1.00, */
	/* >>refer	Ne	abund	Holweger, H., 2001, Joint SOHO/ACE workshop Solar and Galactic 
	 * >>refercon	Composition. Edited by Robert F. Wimmer-Schweingruber. Publisher: 
	 * >>refercon	American Institute of Physics Conference proceedings vol. 598 location: Bern, 
	 * >>refercon	Switzerland, March 6 - 9, 2001., p.23 */
	abund.SolarSave[ipNEON] = 1.00e-4;
	abund.SolarSave[ipSODIUM] = 2.14e-6;
	/* >>chng 02 jul 30, from 3.80 to 3.45, */
	/* >>refer	Mg	abund	Holweger, H., 2001, Joint SOHO/ACE workshop Solar and Galactic 
	 * >>refercon	Composition. Edited by Robert F. Wimmer-Schweingruber. Publisher: 
	 * >>refercon	American Institute of Physics Conference proceedings vol. 598 location: Bern, 
	 * >>refercon	Switzerland, March 6 - 9, 2001., p.23 */
	abund.SolarSave[ipMAGNESIUM] = 3.47e-5;
	abund.SolarSave[ipALUMINIUM] = 2.95e-6;
	/* >>chng 02 jul 30, from 3.55 to 3.44, */
	/* >>refer	Si	abund	Holweger, H., 2001, Joint SOHO/ACE workshop Solar and Galactic 
	 * >>refercon	Composition. Edited by Robert F. Wimmer-Schweingruber. Publisher: 
	 * >>refercon	American Institute of Physics Conference proceedings vol. 598 location: Bern, 
	 * >>refercon	Switzerland, March 6 - 9, 2001., p.23 */
	abund.SolarSave[ipSILICON] = 3.47e-5;
	abund.SolarSave[ipPHOSPHORUS] = 3.20e-7;
	abund.SolarSave[ipSULPHUR] = 1.84e-5;
	abund.SolarSave[ipCHLORINE] = 1.91e-7;
	abund.SolarSave[ipARGON] = 2.51e-6;
	abund.SolarSave[ipPOTASIUM] = 1.32e-7;
	abund.SolarSave[ipCALCIUM] = 2.29e-6;
	abund.SolarSave[ipSCANDIUM] = 1.48e-9;
	abund.SolarSave[ipTITANIUM] = 1.05e-7;
	abund.SolarSave[ipVANADIUM] = 1.00e-8;
	abund.SolarSave[ipCHROMIUM] = 4.68e-7;
	abund.SolarSave[ipMANGANESE] = 2.88e-7;
	/* >>chng 02 jul 30, from 3.24 to 2.81, */
	/* >>refer	Fe	abund	Holweger, H., 2001, Joint SOHO/ACE workshop Solar and Galactic 
	 * >>refercon	Composition. Edited by Robert F. Wimmer-Schweingruber. Publisher: 
	 * >>refercon	American Institute of Physics Conference proceedings vol. 598 location: Bern, 
	 * >>refercon	Switzerland, March 6 - 9, 2001., p.23 */
	abund.SolarSave[ipIRON] = 2.82e-5;
	abund.SolarSave[ipCOBALT] = 8.32e-8;
	abund.SolarSave[ipNICKEL] = 1.78e-6;
	abund.SolarSave[ipCOPPER] = 1.62e-8;
	abund.SolarSave[ipZINC] = 3.98e-8;

	/* abundance set from pre-c96 */
	/* solar abundances Grevesse and Anders 1989, Grevesse and Noel 1993 */
	abund.OldSolar84[ipHYDROGEN] = 1.0;
	abund.OldSolar84[ipHELIUM] = 0.100;
	abund.OldSolar84[ipLITHIUM] = 2.04e-9;
	abund.OldSolar84[ipBERYLLIUM] = 2.63e-11;
	abund.OldSolar84[ipBORON] = 7.59e-10;
	abund.OldSolar84[ipCARBON] = 3.55e-4;
	abund.OldSolar84[ipNITROGEN] = 9.33e-5;
	abund.OldSolar84[ipOXYGEN] = 7.41e-4;
	abund.OldSolar84[ipFLUORINE] = 3.02e-8;
	abund.OldSolar84[ipNEON] = 1.17e-4;
	abund.OldSolar84[ipSODIUM] = 2.06e-6;
	abund.OldSolar84[ipMAGNESIUM] = 3.80e-5;
	abund.OldSolar84[ipALUMINIUM] = 2.95e-6;
	abund.OldSolar84[ipSILICON] = 3.55e-5;
	abund.OldSolar84[ipPHOSPHORUS] = 3.73e-7;
	abund.OldSolar84[ipSULPHUR] = 1.62e-5;
	abund.OldSolar84[ipCHLORINE] = 1.88e-7;
	abund.OldSolar84[ipARGON] = 3.98e-6;
	abund.OldSolar84[ipPOTASIUM] = 1.35e-7;
	abund.OldSolar84[ipCALCIUM] = 2.29e-6;
	abund.OldSolar84[ipSCANDIUM] = 1.58e-9;
	abund.OldSolar84[ipTITANIUM] = 1.10e-7;
	abund.OldSolar84[ipVANADIUM] = 1.05e-8;
	abund.OldSolar84[ipCHROMIUM] = 4.84e-7;
	abund.OldSolar84[ipMANGANESE] = 3.42e-7;
	abund.OldSolar84[ipIRON] = 3.24e-5;
	abund.OldSolar84[ipCOBALT] = 8.32e-8;
	abund.OldSolar84[ipNICKEL] = 1.76e-6;
	abund.OldSolar84[ipCOPPER] = 1.87e-8;
	abund.OldSolar84[ipZINC] = 4.52e-8;

	/* Nova Cyg 75 abundances, C, O, NE UP 20, NIT UP 100, REST SOLAR AR */
	abund.anova[ipHYDROGEN] = 1.0;
	abund.anova[ipHELIUM] = 0.098;
	abund.anova[ipLITHIUM] = 2.04e-9;
	abund.anova[ipBERYLLIUM] = 2.6e-11;
	abund.anova[ipBORON] = 7.60e-9;
	abund.anova[ipCARBON] = 9.4e-4;
	abund.anova[ipNITROGEN] = 9.8e-3;
	abund.anova[ipOXYGEN] = 1.7e-2;
	abund.anova[ipFLUORINE] = 3.02e-8;
	abund.anova[ipNEON] = 2.03e-3;
	abund.anova[ipSODIUM] = 2.06e-6;
	abund.anova[ipMAGNESIUM] = 3.80e-5;
	abund.anova[ipALUMINIUM] = 2.95e-6;
	abund.anova[ipSILICON] = 3.55e-5;
	abund.anova[ipPHOSPHORUS] = 3.73e-7;
	abund.anova[ipSULPHUR] = 1.62e-5;
	abund.anova[ipCHLORINE] = 1.88e-7;
	abund.anova[ipARGON] = 3.63e-6;
	abund.anova[ipPOTASIUM] = 1.35e-7;
	abund.anova[ipCALCIUM] = 2.29e-6;
	abund.anova[ipSCANDIUM] = 1.22e-9;
	abund.anova[ipTITANIUM] = 8.60e-8;
	abund.anova[ipVANADIUM] = 1.05e-8;
	abund.anova[ipCHROMIUM] = 4.84e-7;
	abund.anova[ipMANGANESE] = 3.42e-7;
	abund.anova[ipIRON] = 4.68e-5;
	abund.anova[ipCOBALT] = 2.24e-9;
	abund.anova[ipNICKEL] = 1.76e-6;
	abund.anova[ipCOPPER] = 1.87e-8;
	abund.anova[ipZINC] = 4.52e-8;

	/* primordial abundances */
	abund.aprim[ipHYDROGEN] = 1.0;
	abund.aprim[ipHELIUM] = 0.072;
	abund.aprim[ipLITHIUM] = 1e-10;
	abund.aprim[ipBERYLLIUM] = 1e-16;

	for( i=4; i < LIMELM; i++ )
	{
		abund.aprim[i] = 1e-25;
	}

	/* typical ISM abundances, mean of Table 3, Cowie+Songaila, Ann Rev '86
	 * also Table 5, Savage and Sembach, Ann Rev 1996 */
	abund.aism[ipHYDROGEN] = 1.;
	abund.aism[ipHELIUM] = 0.098;
	abund.aism[ipLITHIUM] = 5.4e-11;
	abund.aism[ipBERYLLIUM] = 1e-20;
	abund.aism[ipBORON] = 8.9e-11;
	abund.aism[ipCARBON] = 2.51e-4;
	abund.aism[ipNITROGEN] = 7.94e-5;
	/* >>chng >>01 feb 19, from 5.01e-4 to 3.19e-4, value from */
	/* >>refer	O	abundance	Meyers, D.M., Jura, M., & Cardelli, J.A., 1998, ApJ, 493, 222-229 */
	/* they quote 3.19 +/- 0.14 e-4 */
	abund.aism[ipOXYGEN] = 3.19e-4;
	abund.aism[ipFLUORINE] = 1e-20;
	abund.aism[ipNEON] = 1.23e-4;
	abund.aism[ipSODIUM] = 3.16e-7;
	abund.aism[ipMAGNESIUM] = 1.26e-5;
	abund.aism[ipALUMINIUM] = 7.94e-8;
	abund.aism[ipSILICON] = 3.16e-6;
	abund.aism[ipPHOSPHORUS] = 1.6e-7;
	abund.aism[ipSULPHUR] = 3.24e-5;
	abund.aism[ipCHLORINE] = 1e-7;
	abund.aism[ipARGON] = 2.82e-6;
	abund.aism[ipPOTASIUM] = 1.1e-8;
	abund.aism[ipCALCIUM] = 4.1e-10;
	abund.aism[ipSCANDIUM] = 1e-20;
	abund.aism[ipTITANIUM] = 5.8e-10;
	abund.aism[ipVANADIUM] = 1.0e-10;
	abund.aism[ipCHROMIUM] = 1.0e-8;
	abund.aism[ipMANGANESE] = 2.3e-8;
	abund.aism[ipIRON] = 6.31e-7;
	abund.aism[ipCOBALT] = 1e-20;
	abund.aism[ipNICKEL] = 1.82e-8;
	abund.aism[ipCOPPER] = 1.5e-9;
	abund.aism[ipZINC] = 2.0e-8;

	/* HII region abundances, Orion mean of Baldwin et al, Rubin et al,
	 * and DEO et al, all 1991 apj
	 * also Table 5, Savage and Sembach, Ann Rev 1996 for ism */
	abund.ahii[ipHYDROGEN] = 1.;
	abund.ahii[ipHELIUM] = 0.095;
	abund.ahii[ipLITHIUM] = 5.4e-11;
	abund.ahii[ipBERYLLIUM] = 1e-20;
	abund.ahii[ipBORON] = 8.9e-11;
	abund.ahii[ipCARBON] = 3.e-4;
	abund.ahii[ipNITROGEN] = 7.0e-5;
	abund.ahii[ipOXYGEN] = 4.0e-4;
	abund.ahii[ipFLUORINE] = 1e-20;
	abund.ahii[ipNEON] = 6e-5;
	abund.ahii[ipSODIUM] = 3e-7;
	abund.ahii[ipMAGNESIUM] = 3.e-6;
	abund.ahii[ipALUMINIUM] = 2.e-7;
	abund.ahii[ipSILICON] = 4.e-6;
	abund.ahii[ipPHOSPHORUS] = 1.6e-7;
	abund.ahii[ipSULPHUR] = 1.0e-5;
	abund.ahii[ipCHLORINE] = 1.e-7;
	abund.ahii[ipARGON] = 3.e-6;
	abund.ahii[ipPOTASIUM] = 1.1e-8;
	abund.ahii[ipCALCIUM] = 2.e-8;
	abund.ahii[ipSCANDIUM] = 1e-20;
	abund.ahii[ipTITANIUM] = 5.8e-10;
	abund.ahii[ipVANADIUM] = 1.0e-10;
	abund.ahii[ipCHROMIUM] = 1.0e-8;
	abund.ahii[ipMANGANESE] = 2.3e-8;
	abund.ahii[ipIRON] = 3.0e-6;
	abund.ahii[ipCOBALT] = 1e-20;
	abund.ahii[ipNICKEL] = 1e-7;
	abund.ahii[ipCOPPER] = 1.5e-9;
	abund.ahii[ipZINC] = 2.0e-8;

	/* PN abund from  */
	/* >>refer	PN	abundances	Aller+Czyzak, ApJ Sup 51, 211 */
	abund.apn[ipHYDROGEN] = 1.;
	abund.apn[ipHELIUM] = 0.1;
	abund.apn[ipLITHIUM] = 1e-20;
	abund.apn[ipBERYLLIUM] = 1e-20;
	abund.apn[ipBORON] = 1e-20;
	abund.apn[ipCARBON] = 7.8e-4;
	abund.apn[ipNITROGEN] = 1.8e-4;
	abund.apn[ipOXYGEN] = 4.4e-4;
	abund.apn[ipFLUORINE] = 3e-7;
	abund.apn[ipNEON] = 1.1e-4;
	abund.apn[ipSODIUM] = 1.9e-6;
	abund.apn[ipMAGNESIUM] = 1.6e-6;
	abund.apn[ipALUMINIUM] = 2.7e-7;
	abund.apn[ipSILICON] = 1e-5;
	abund.apn[ipPHOSPHORUS] = 2e-7;
	abund.apn[ipSULPHUR] = 1e-5;
	abund.apn[ipCHLORINE] = 1.7e-7;
	abund.apn[ipARGON] = 2.7e-6;
	abund.apn[ipPOTASIUM] = 1.2e-7;
	abund.apn[ipCALCIUM] = 1.2e-8;
	abund.apn[ipSCANDIUM] = 1e-20;
	abund.apn[ipTITANIUM] = 1e-20;
	abund.apn[ipVANADIUM] = 1e-20;
	abund.apn[ipCHROMIUM] = 1e-20;
	abund.apn[ipMANGANESE] = 1e-20;
	abund.apn[ipIRON] = 5.0e-7;
	abund.apn[ipCOBALT] = 1e-20;
	abund.apn[ipNICKEL] = 1.8e-8;
	abund.apn[ipCOPPER] = 1e-20;
	abund.apn[ipZINC] = 1e-20;

	/* mix from Cameron 1982, in "Essays on Nuclear Astro" */
	abund.camern[ipHYDROGEN] = 1.;
	abund.camern[ipHELIUM] = .0677;
	abund.camern[ipLITHIUM] = 2.2e-9;
	abund.camern[ipBERYLLIUM] = 4.5e-11;
	abund.camern[ipBORON] = 3.4e-10;
	abund.camern[ipCARBON] = 4.22e-4;
	abund.camern[ipNITROGEN] = 8.72e-5;
	abund.camern[ipOXYGEN] = 6.93e-4;
	abund.camern[ipFLUORINE] = 2.9e-8;
	abund.camern[ipNEON] = 9.77e-5;
	abund.camern[ipSODIUM] = 2.25e-6;
	abund.camern[ipMAGNESIUM] = 3.98e-5;
	abund.camern[ipALUMINIUM] = 3.20e-6;
	abund.camern[ipSILICON] = 3.76e-5;
	abund.camern[ipPHOSPHORUS] = 2.4e-7;
	abund.camern[ipSULPHUR] = 1.88e-5;
	abund.camern[ipCHLORINE] = 1.78e-7;
	abund.camern[ipARGON] = 3.99e-6;
	abund.camern[ipPOTASIUM] = 1.3e-7;
	abund.camern[ipCALCIUM] = 2.35e-6;
	abund.camern[ipSCANDIUM] = 1.16e-9;
	abund.camern[ipTITANIUM] = 9.0e-8;
	abund.camern[ipVANADIUM] = 9.5e-9;
	abund.camern[ipCHROMIUM] = 4.8e-7;
	abund.camern[ipMANGANESE] = 3.5e-7;
	abund.camern[ipIRON] = 3.38e-5;
	abund.camern[ipCOBALT] = 8.27e-8;
	abund.camern[ipNICKEL] = 1.80e-6;
	abund.camern[ipCOPPER] = 2.0e-8;
	abund.camern[ipZINC] = 4.7e-8;

	/* set logical flags saying whether to include element in AGN tables */
	/* first set all false, since most not included */
	for( i=0; i < LIMELM; i++ )
	{
		abund.lgAGN[i] = FALSE;
	}
	abund.lgAGN[ipHYDROGEN] = TRUE;
	abund.lgAGN[ipHELIUM] = TRUE;
	abund.lgAGN[ipCARBON] = TRUE;
	abund.lgAGN[ipNITROGEN] = TRUE;
	abund.lgAGN[ipOXYGEN] = TRUE;
	abund.lgAGN[ipNEON] = TRUE;
	abund.lgAGN[ipMAGNESIUM] = TRUE;
	abund.lgAGN[ipSILICON] = TRUE;
	abund.lgAGN[ipSULPHUR] = TRUE;
	abund.lgAGN[ipARGON] = TRUE;
	abund.lgAGN[ipIRON] = TRUE;

#	ifdef DEBUG_FUN
	fputs( " <->ZeroAbund()\n", debug_fp );
#	endif
	return;
}

