/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*AtlasCompile rebin Kurucz stellar models to match energy grid of code */
void AtlasCompile(void);

/*AtlasInterpolate interpolate on atlas model atmospheres, by K Volk */
void AtlasInterpolate(long int *nstar, 
  double temp, 
  double alogg, 
  int lgTrace);
/* CoStarCompile rebin costar stellar models to match energy grid of code*/
void CoStarCompile(void);

/*CoStarInterpolate read in and interpolate on Werner grid of PN atmospheres, by K Volk */
void CoStarInterpolate(
	/* number of points in the output continuum, will be ncell */
	long int *nstar, 
	/* which interpolation mode is requested
	 * intmode = 1: use temp and nmodid
	 * intmode = 2: use temp and logg
	 * intmode = 3: use M_ZAMS and age */
	int intmode,
	/* Teff for intmode = 1,2; M_ZAMS for intmode = 3 */
	double temp, 
	/* not valid for intmode = 1; log(g) for intmode = 2; age for intmode = 3 */
	double logg,
	/* the index number for the model sequence, only valid for intmode = 1 */
	int nmodid ,
	/* flag indicating whether solar (==0) or halo (==1) abundances */
	int iabund );

/*kurucz79 obtain interpolated Kurucz stellar atmosphere */
void kurucz79(long int *nstar, 
  double par1, 
  double par2);

/*mihals generate continuum from Mihalas stellar atmosphere */
void mihals(long int *nstar, 
  double par1, 
  double par2);

/* bring all the rauch stellar atmosphers together into one file,
 * called by compile star rauch initialize */
void RauchInitialize(void);
void RauchInitialize02(void);

/* RauchCompile rebin Rauch stellar models to match energy grid of code*/
/* return 0 if success, 1 if failure */
int RauchCompile(void);
int RauchCompile02(void);

/*RauchInterpolate get one of the Rauch model atmospheres, coded by K. Volk */
void RauchInterpolate(long int *nstar, 
  double temp, 
  double alogg, 
  long int iabund);

void RauchInterpolate02(long int *nstar, 
  double temp, 
  double alogg, 
  long int iabund);

/*RebinAtmosphere: generic routine for rebinning atmospheres onto Cloudy grid */
void RebinAtmosphere(
  /* the number of points in the incident continuum*/
  long nCont , 
  /* the energy grid for the stellar continuum in Ryd*/
  /*@in@*/ float StarEner[] , /* StarEner[nCont] */
  /* the predicted continuum flux on the stellar continuum scale */
  /*@in@*/ float StarFlux[] , /* StarFlux[nCont] */
  /* what we want, the continuum on the cloudy grid */
  /*@out@*/ float CloudyFlux[] , /* CloudyFlux[NC_ELL] */
  /* the number of edges in AbsorbEdge */
  long nEdge ,
  /* the list of absorption edges that require special attention */
  /*@in@*/ float AbsorbEdge[] ); /* AbsorbEdge[nEdge] */

  /*WernerCompile rebin Werner stellar atmospheres to match cloudy energy grid */
void WernerCompile(void);

/*WernerInterpolate read in and interpolate on Werner grid of PN atmospheres, by K Volk */
void WernerInterpolate(long int *nstar, 
  double temp, 
  double alogg);
