/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* punchvar.h */
#define	LIMPUN	100L

/*PunchDo produce punch output during calculation */
void PunchDo(
	char *chTime); /* chTime is null terminated 4 char string, either "MIDL" or "LAST" */

/* punch one line, called by PunchLineStuff */
void pun1Line( EmLine * t , FILE * io , float xLimit , long index );

/*PunchLineData punches selected line data for all lines transferred in code */
void PunchLineData(FILE * io);

/*punch_opacity punch total opacity in any element, punch opacity command */
void punch_opacity(FILE * io, 
  long int np);

/*PunchSpecial generate output for the punch special command */
void PunchSpecial(FILE* io , 
  char *chTime);

/*Punch1LineData data for punch one line */
void Punch1LineData( EmLine * t , FILE * io);

/*punch_line parse punch lines command, or actually do the punch output */
void punch_line(FILE * ip, /* the file we will write to */
  char *chDo, 
  int lgLog3);

/*HeatPunch punch contributors to local heating, with punch heat command, called by punch_do */
void HeatPunch(FILE* io);

/*CoolPunch punch coolants, called by punch_do */
void CoolPunch(FILE * io);

EXTERN struct t_pnunit {

	/* this is the file where we will direct the output */
	FILE*ipPnunit[LIMPUN]; 

	/* number of punch commands entered */
	long int npunch;

	/*chPunch - what is it we want to punch? set in GetPunch, used in DoPunch */
	char chPunch[LIMPUN][5];

	/* flag saying whether any punch continuum commands were entered
	 * set true in parsecontinuum when punch continuum entered,
	 * used in PrtComment to warn if continuum punched with no iterations */
	int lgPunContinuum;

	/* punarg is set of optional arguments for the punch command */
	float punarg[3][LIMPUN];

	/* set of optional arguments for punch command, but as a string */
	char chPunchArgs[LIMPUN][5];

	/* lg flag lgPunLstIter for this punch option, */
	/* do we only want to punch on last iteration? */
	int lgPunLstIter[LIMPUN];

	/* option to say whether punch units should be opened,
	 * set to false during optimizer runs, but not on the final model */
	int lgOpenUnits;

	/*chConPunEnr - units of continuum in punch output */
	char chConPunEnr[LIMPUN][5];

	/* this global variable is index of punch command loop in dopunch */
	long int ipConPun;

	/* should hash marks be printed after every iteration?
	 * default is yes, set no with no hash option on punch command */
	int lgHashEndIter;

	/* this is the hash string, normally a set of hash marks, can be reset with
	 * set punch hash command */
	char chHashString[INPUT_LINE_LENGTH];

	/* flush file after every iteration */
	int lgFLUSH;

	/* this is a prefix that will be set at the start of all punch file names
	 * set punch prefix command, normally a null string */
	char chFilenamePrefix[INPUT_LINE_LENGTH];

	/* these are initialized in parsepunch.c, in routine PunchFilesInit */
	/* min and max range of punch new continuum command */
	float cp_range_min[LIMPUN] ,
		cp_range_max[LIMPUN];

	/* the resolving power of the rebinned continuum, set with
	 * set cpunch resolving 100 command, 
	 * if not specified then native resolution will be kept */
	float cp_resolving_power[LIMPUN];

	/* number of new punch continuum commands */
	long int cp_npun;

	/* set with punch line intensites and punch results commands,
	 * says whether results arrays produced by routine PunResults1Line should
	 * be column or array */
	char chPunRltType[7];

	/* option to punch out pointers with punch pointers commmand
	 * ipPoint is punch file handle, lgPunPoint says whether we will do it
	 */
	FILE* ipPoint;
	int lgPunPoint;

	/* unit number, and flag, for punching reason for continued iterations */
	int lgPunConv;
	FILE* ipPunConv;

	/* these control punching choice of dr - this is not really a punch cmnd
	 * ipDRout is io unit, lgDROn says punching dr logic has been set,
	 * and lgDRPLst says to punch the last iteration */
	FILE * ipDRout;
	int lgDROn, 
	  lgDRPLst;

	/* option to punch recombination coefficients to external file */
	FILE* ioRecom;
	int lgioRecom;

	/* lgPunH2 says to punch H2 rates on unit ipPunH2 */
	FILE * ipPunH2;
	int lgPunH2;

	/* option to punch line intensities every linevery zones
	 * logical variable says whether LinEvery was set */
	long int LinEvery;
	int lgLinEvery;

	/* set skip sets this variable, which says how many cells to skip in punch */
	long int ncPunchSkip;

	/* threshold for faintest cooling or heating to be punched
	 * default is set to 0.05 in scalar, can be reest with 'set weakheatcool' */
	float WeakHeatCool;

	/* contrast factor for lines to continuum in punch output
	* default is 1 (gives correct line intensities) and changed with
	* set width command (enters width in km/sec) */
	float PunchLWidth;

	}	punch;
