/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseIonPar parse the ionization parameter command */
#include "cddefines.h"
#include "radius.h"
#include "optimize.h"
#include "rfield.h"
#include "input.h"
#include "parse.h"

void ParseIonPar(long int *nqh, 
  char *chCard,
  float *ar1)
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseIonPar()\n", debug_fp );
#	endif

	/*  check not too many continua */
	if( *nqh >= LIMSPC )
	{
		/* too many continua were entered */
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseIonPar]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* say that continuum is per unit area, ionization parameter*/
	strcpy( rfield.chRSpec[*nqh], "SQCM" );
	if( chCard[0] == 'I' )
	{
		/* this is the usual ionization parameter, U */
		strcpy( rfield.chSpNorm[*nqh], "IONI" );
	}
	else if( chCard[0] == 'X' )
	{
		/* the X-Ray ionization parameter, xi */
		strcpy( rfield.chSpNorm[*nqh], "IONX" );
	}
	else
	{
		fprintf(ioQQQ," ParseIonPar hit chCard insanity.\n");
		puts( "[Stop in ParseIonPar]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* get the ionization parameter*/
	i = 5;
	rfield.totpow[*nqh] = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		NoNumb(chCard);
	}

	/* vary option */
	if( optimize.lgVarOn )
	{
		if( chCard[0] == 'I' )
		{
			/* this is the usual ionization parameter, U */
			strcpy( optimize.chVarFmt[optimize.nparm], "IONIZATION PARAMETER=%f" );
		}
		else if( chCard[0] == 'X' )
		{
			/* the X-Ray ionization parameter, xi */
			strcpy( optimize.chVarFmt[optimize.nparm], "XI=%f" );
		}
		else
		{
			fprintf( ioQQQ, " Insanity in detection which ionization parameter.\n" );
			puts( "[Stop in ParseIonPar]" );
			cdEXIT(EXIT_FAILURE);
		}
		/* pointer to where to write */
		optimize.nvfpnt[optimize.nparm] = input.nRead;
		optimize.vparm[0][optimize.nparm] = (float)rfield.totpow[*nqh];
		optimize.vincr[optimize.nparm] = 0.5;
		optimize.nvarxt[optimize.nparm] = 1;
		++optimize.nparm;
	}

	/* set R to large value if U specified. */
	/* set radius to very large value if not already set */
	/* >>chng 01 jul 24, from Radius == 0 to this, as per PvH comments */
	if( !radius.lgRadiusKnown )
	{
		*ar1 = (float)radius.rdfalt;
		radius.Radius = pow(10.f,radius.rdfalt);
	}
	/* increment nmber of specifications of continuum intensities, */
	++*nqh;

#	ifdef DEBUG_FUN
	fputs( " <->ParseIonPar()\n", debug_fp );
#	endif
	return;
}
