/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseConstant parse parameters from the 'constant ...' command */
#include "cddefines.h"
#include "optimize.h"
#include "thermal.h"
#include "dense.h"
#include "pressure.h"
#include "tfidle.h"
#include "phycon.h"
#include "input.h"
#include "parse.h"

void ParseConstant(char *chCard )
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseConstant()\n", debug_fp );
#	endif

	if( lgMatch("GRAI",chCard) && lgMatch("TEMP",chCard) )
	{
		/* constant grain temperature command */
		i = 5;
		thermal.ConstGrainTemp = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

		/* if linear option is not on the line, convert to exponent if <= 10 */
		if( !lgMatch("LINE",chCard) )
		{
			if( thermal.ConstGrainTemp <= 10. )
				thermal.ConstGrainTemp = (float)pow(10.,thermal.ConstGrainTemp);
		}

		if( lgEOL )
		{
			NoNumb(chCard);
		}
	}

	else if( lgMatch("TEMP",chCard) )
	{
		/* force a constant temperature model */
		thermal.lgTSetOn = TRUE;

		i = 5;
		thermal.ConstTemp = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		/* if linear option is not on the line, convert to exponent if <= 10 */
		if( !lgMatch("LINE",chCard) )
		{
			if( thermal.ConstTemp <= 10. )
				thermal.ConstTemp = (float)pow(10.,thermal.ConstTemp);
		}

		if( lgEOL )
		{
			NoNumb(chCard);
		}

		/* check that termperature is not less than 3K */
		if( thermal.ConstTemp < 3. )
		{
			fprintf( ioQQQ, " TE<3K, reset to 3K.\n" );
			thermal.ConstTemp = 3.;
		}

		/* bail if termperature is relativistic */
		if( thermal.ConstTemp > 1e11 )
		{
			fprintf( ioQQQ, " TE>1e11K, cloudy cannot handle this temperature.\n" );
			fprintf( ioQQQ, " Sorry.\n" );
			puts( "[Stop in ParseConstant]" );
			cdEXIT(EXIT_FAILURE);
		}

		/* set the real electron temperature to the forced value */
		phycon.te = thermal.ConstTemp;
		tfidle(FALSE);

		/* vary option */
		if( optimize.lgVarOn )
		{
			/*  no luminosity options on vary */
			optimize.nvarxt[optimize.nparm] = 1;
			strcpy( optimize.chVarFmt[optimize.nparm], "CONStant TEMP %f" );

			/*  pointer to where to write */
			optimize.nvfpnt[optimize.nparm] = input.nRead;

			/*  log of temp will be pointer */
			optimize.vparm[0][optimize.nparm] = (float)log10(phycon.te);
			optimize.vincr[optimize.nparm] = 0.1f;
			++optimize.nparm;
		}
	}

	else if( lgMatch("DENS",chCard) )
	{
		/* constant density */
		strcpy( dense.chDenseLaw, "CDEN" );
		/* turn off radiation pressure */
		pressure.lgRadPresON = FALSE;
	}

	else if( lgMatch("PRES",chCard) )
	{
		/* constant pressure  */
		strcpy( dense.chDenseLaw, "CPRE" );
		if( lgMatch(" GAS",chCard) )
		{
			/*  constant gas pressure (no radiation)
			 *  turn off radiation pressure */
			pressure.lgRadPresON = FALSE;

			/*  turn off incident continuum */
			pressure.lgContRadPresOn = FALSE;

			/*  optional second number is power law index */
			i = 4;
			pressure.PresPowerlaw = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
		}

		else
		{
			/*  constant total pressure, gas+rad+incident continuum
			 *  turn on radiation pressure */
			pressure.lgRadPresON = TRUE;

			/*  option to turn off continuum pressure */
			if( lgMatch("O CO",chCard) )
			{
				pressure.lgContRadPresOn = FALSE;
			}
			else
			{
				pressure.lgContRadPresOn = TRUE;
			}

			/*  option to not abort when too much radiation pressure, no abort */
			if( lgMatch("O AB",chCard) )
			{
				pressure.lgRadPresAbortOK = FALSE;
			}
			else
			{
				pressure.lgRadPresAbortOK = TRUE;
			}
			/*  there is no optional power law option for constant total pressure */
			pressure.PresPowerlaw = 0.;
		}
	}

	else
	{
		/* no keys were recognized */
		fprintf( ioQQQ, " The keyword should be TEMPerature, DENSity, GAS or PRESsure, sorry.\n" );
		puts( "[Stop in ParseConstant]" );
		cdEXIT(EXIT_FAILURE);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseConstant()\n", debug_fp );
#	endif
	return;
}

