/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseAtomCO parse information from the rotor command line */
#include "cddefines.h"
#include "taulines.h"
#include "parse.h"

void ParseAtomCO(char *chCard )
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseAtomCO()\n", debug_fp );
#	endif

	if( lgMatch("LEVE",chCard) )
	{
		/* number of rotation levels for CO */

		/* lgHydroMalloc is FALSE at start of calculation, set true when space 
		 * allocated for the hydrogen lines.  Once done we must ignore all 
		 * future changes in the number of levels */
		if( !lgCORotateMalloc )
		{
			i = 5;
			nCORotate = (long int)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

			if( nCORotate < 2 )
			{
				fprintf( ioQQQ, " This would be too few levels.\n" );
				puts( "[Stop in ParseAtomCO]" );
				cdEXIT(EXIT_FAILURE);
			}
		}
	}

	else
	{
		fprintf( ioQQQ, " There should have been a keyword - I know about LEVEL, Stop in ParseAtomCO\n" );
		puts( "[Stop in ParseAtomCO]" );
		cdEXIT(EXIT_FAILURE);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseAtomCO()\n", debug_fp );
#	endif
	return;
}

