/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseAge parse parameters off the age command */
#include "cddefines.h"
#include "timesc.h"
#include "parse.h"

void ParseAge(char *chCard )
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseAge()\n", debug_fp );
#	endif

	/* set age for the cloud
	 * various timescales will be checked in AgeCheck, called in comment */

	i = 4;
	timesc.CloudAgeSet = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

	/* key " off" turns age off */
	if( lgEOL && (!lgMatch(" OFF",chCard)) )
	{
		fprintf( ioQQQ, " The age must be on this line.\n" );
		puts( "[Stop in getage]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* check if log of age */
	if( lgMatch(" LOG",chCard) )
	{
		timesc.CloudAgeSet = (float)pow(10.f,timesc.CloudAgeSet);
	}

	/* check for units, we want seconds in the end */
	if( lgMatch("MILL",chCard) )
	{
		/* millennium */
		timesc.CloudAgeSet *= (float)(3.15569e7*1000.);
	}
	else if( lgMatch("CENT",chCard) )
	{
		/* centuries */
		timesc.CloudAgeSet *= (float)(3.15569e7*100.);
	}
	else if( lgMatch("YEAR",chCard) )
	{
		/* years */
		timesc.CloudAgeSet *= 3.15569e7;
	}
	else if( lgMatch("MONT",chCard) )
	{
		/* months */
		timesc.CloudAgeSet = (float)(timesc.CloudAgeSet*3.15569e7/12.);
	}
	else if( lgMatch("FORT",chCard) )
	{
		/* fortnights */
		timesc.CloudAgeSet *= 24.*3600.*14.;
	}
	else if( lgMatch("WEEK",chCard) )
	{
		/* weeks */
		timesc.CloudAgeSet *= 24.*3600.*7.;
	}
	else if( lgMatch("DAY ",chCard) )
	{
		/* days */
		timesc.CloudAgeSet *= 24.*3600.;
	}
	else if( lgMatch("HOUR",chCard) )
	{
		/* hours */
		timesc.CloudAgeSet *= 3600.;
	}
	else if( lgMatch("MINU",chCard) )
	{
		/* minuts */
		timesc.CloudAgeSet *= 60.;
	}
	else if( lgMatch("SECO",chCard) )
	{
		/* seconds - this is the default */
		timesc.CloudAgeSet *= 1.;
	}


#	ifdef DEBUG_FUN
	fputs( " <->ParseAge()\n", debug_fp );
#	endif
	return;
}

