/* mole.h */
EXTERN struct t_mole {

		
	/* limit to the ratio H2/Htot - if ratio is below this, large atom is not called */
	double H2_to_H_limit;

	/* the number of electronic quantum states to include.
	* To do both Lyman and Werner bands want nelec = 3 */
	long int n_h2_elec_states;

	/* this is option to use estimates of the collision rates from g-bar approximations */
	/* turn mole.lgColl_gbar on/off with atom h2 gbar on off */
	int lgColl_gbar;

	/* this is option to turn off the calculated collision rates */
	int lgColl_deexec_Calc;
	/* this is option to turn off gueses of collisional dissociation rates */
	int lgColl_dissoc_coll;

	/* turn on trace information */
	int lgH2_TRACE;

	/* put noise into collision rates */
	int lgH2_NOISE ,
		/* noie for the CR collisions */
		lgH2_NOISECOSMIC;

	/* std and mean for the noise, log normal distribution */
	double xMeanNoise , xSTDNoise ;

	/* these are source and sink terms for the ionization ladder, for chemical
	 * processes that remove and add species */
	 double **source ,
		 **sink;

}	mole;
