/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*mean derive mean ionization fractions over computed EXTERN structure */
void MeanInc(void);

/*MeanZero zero mean of ionization fractions array */
void MeanZero(void);

/*MeanIonRadius derive mean ionization fractions over ravius for some element */
void MeanIonRadius(
	/* either 'i' or 't' for ionization or temperature */
	char chType,
	/* atomic number on physical, no c, scale */
	long int nelem, 
	/* this will say how many of arlog have non-zero values */
	long int *n, 
	/* array of values, log both cases */
	float arlog[],
	/* TRUE, include electron density, FALSE do not*/
	int lgDensity );

/*MeanIonVolume do volume mean of ionization fractions over volume of any element */
void MeanIonVolume(
	/* either 'i' or 't' for ionization or temperature */
	char chType,
	/* atomic number on physical, no c, scale */
	long int nelem, 
	/* this will say how many of arlog have non-zero values */
	long int *n, 
	/* array of values, log both cases */
	float arlog[],
	/* TRUE, include electron density, FALSE do not*/
	int lgDensity );

/* ionmeans.h */
EXTERN struct t_IonMeans {

	/* used to store information for mean ionization and electron temperature,
	 * this is set to zero in zmean, incremented in mean, and analysed in 
	 * MeanIonRadius and MeanIonVolume */

	/* this is used to get the harmonic mean temperature with respect to
	 * atomic hydrogen density, over radius, for comparison with 21cm data */
	double HarMeanTempRadius[2];
	/* this is used to get the harmonic mean temperature with respect to
	 * atomic hydrogen density, weighted over volume */
	double HarMeanTempVolume[2];

	/* this is used to get the mean temperature with respect to
	 * H2, over radius */
	double H2MeanTempRadius[2];
	/* this is used to get the mean temperature with respect to
	 * H2, weighted over volume */
	double H2MeanTempVolume[2];

	/* this is mean of computed 21 cm spin temperature */
	double H_21cm_spin_mean_radius[2];

	/* xIonMeans[type][nelem][stage]
	 * stage=0 is integrated sum of all
	 * type = 0 is radius integration, 1=vol integration */
	double ***xIonMeans;/*[2][LIMELM][LIMELM+2];*/
	/* following includes electron density */
	double ***xIonEdenMeans;/*[2][LIMELM][LIMELM+2];*/
	double **xIonMeansNorm;/*[2][LIMELM];*/
	/* following includes electron density */
	double **xIonEdenMeansNorm;/*[2][LIMELM];*/

	/* TempMeans[type][nelem][stage]
	 * stage=0 is not used, here for analogy with above
	 * type = 0 is radius integration, 1=vol integration,
	 * 2 is norm for radius, 3 is norm for vol integration */
	double TempMeans[4][LIMELM][LIMELM+2];
	/* following includes electron density */
	double TempEdenMeans[4][LIMELM][LIMELM+2];

	}	mean;

