/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*IonSodiu ionization balance for sodium */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#ifdef NELEM
#	undef NELEM
#endif
#define	NDIM	12
#define	NELEM	11
#include "trace.h"
#include "dense.h"
#include "ionbal.h"

void IonSodiu(void)
{
	long int i, 
	  _r;
	static double dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double ditcrt[NDIM - 1]={0.,1.3e5,4.4e5,7.2e4,2.8e5,4.0e5,
	  1.3e6,1.6e6,1.9e6,3.4e4,0.};
	static double aa[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static double bb[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static double cc[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static double dd[NDIM - 1]={0.,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static double ff[NDIM - 1]={0.1,0.,0.,0.,0.,0.,0.,0.,0.,0.,0.};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {1.0e-3,2.6e-3,6.0e-3,1.1e-2,8.0e-3,
		  1.0e-2,3.2e-2,1.2e-2,2.2e-1,1.8e-1,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {3.6e5,3.8e5,3.4e5,3.0e5,2.7e5,2.8e5,
		  3.2e5,1.9e5,1.2e7,1.3e7,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp3[_r++];
			}
		}
		for( i=1; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = 0.;
			}
		for( i=1; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = 0.;
			}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonSodiu()\n", debug_fp );
#	endif

	/* sodium nelem=11
	 *
	 * rates taken from Mg Shull and van Steenberg, Ap.J. Sup 48, 95. */

	/* from Aldrovandi and Pequignot Revista Brasileira de Fisica, 4, 491, */
	/* Pequignot and Aldrovandi Ast Ap 161, 169. */

	/* sodium, atomic number 11 */
	if( !dense.lgElmtOn[10] )
	{
		
#		ifdef DEBUG_FUN
		fputs( " <->IonSodiu()\n", debug_fp );
#		endif
		return;
	}

	ion_zero(NELEM-1);

	ion_photo(NELEM-1,FALSE);

	/* find collisional ionization rates */
	ion_collis(NELEM-1);

	/* get recombination coefficients */
	ion_recomb(FALSE,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,NELEM-1);

	/* solve for ionization balance */
	ion_solver(NELEM-1,FALSE);

	if( trace.lgTrace && trace.lgHeavyBug )
	{
		fprintf( ioQQQ, "     IonSodiu returns; frac=" );
		for( i=1; i <= 10; i++ )
		{
			fprintf( ioQQQ, "%10.3e", dense.xIonDense[NELEM-1][i-1]/
			  dense.gas_phase[NELEM-1] );
		}
		fprintf( ioQQQ, "\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->IonSodiu()\n", debug_fp );
#	endif
	return;
}

