/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*IonHelium solve ionization balance for helium */
#include "cddefines.h"
#include "dense.h"
#include "ionbal.h"

void IonHelium( void )
{
#	ifdef DEBUG_FUN
	fputs( "<+>IonHelium()\n", debug_fp );
#	endif

	/* option to "turn off" helium */
	if( !dense.lgElmtOn[ipHELIUM] )
	{
		dense.xIonDense[ipHELIUM][0] = 0.;
		dense.xIonDense[ipHELIUM][1] = 0.;
		dense.xIonDense[ipHELIUM][2] = 0.;
		
#		ifdef DEBUG_FUN
		fputs( " <->IonHelium()\n", debug_fp );
#		endif
		return;
	}

	/* populations */
	/* >>chng 01 may 09, add option to set ionization with element name ioniz cmnd */
	if( dense.lgSetIoniz[ipHELIUM] )
	{
		dense.xIonDense[ipHELIUM][2] = dense.SetIoniz[ipHELIUM][2]*dense.gas_phase[ipHELIUM];
		dense.xIonDense[ipHELIUM][1] = dense.SetIoniz[ipHELIUM][1]*dense.gas_phase[ipHELIUM];
		dense.xIonDense[ipHELIUM][0] = dense.SetIoniz[ipHELIUM][0]*dense.gas_phase[ipHELIUM];
		
#		ifdef DEBUG_FUN
		fputs( " <->IonHelium()\n", debug_fp );
#		endif
		return;
	}

	/* use standard solver for ionization balance */
	ion_solver( ipHELIUM , FALSE );
	/*GammaPrtRate( ioQQQ , 0 , ipHELIUM , TRUE);*/

#	ifdef DEBUG_FUN
	fputs( " <->IonHelium()\n", debug_fp );
#	endif

	return;
}

