/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* input_readarray read input commands from array where images are stored *
 * returns chCard, which will have <=80 characters before eol    *
 * line image is up and low case                                 */
#include "cddefines.h"
#include "trace.h"
#include "input.h"

void input_readarray(char *chCard, 
  int *lgEOF)
{
	long int last;

#	ifdef DEBUG_FUN
	fputs( "<+>input_readarray()\n", debug_fp );
#	endif


	if( input.iReadWay > 0 )
	{
		/* usual case, reading commands from start of array
		 * nRead points to one plus the array element with the next line, it is
		 * one on the first call, which references line[0] */
		++input.nRead;

		/* nSave points to the last line array element that was saved,
		 * so it is one less than the number of lines read.  the last element
		 * containing a line image is [input.nSave].  There is a -1 for
		 * nRead to bring it onto the same c counting scale as nSave */
		if( input.nRead > input.nSave )
		{
			*lgEOF = TRUE;
		}
		else
		{
			/* get the line image */
			strcpy( chCard, input.chCardSav[input.nRead] );

			/* save copy of the original input card */
			strcpy( input.chOrgCard, chCard );

			/* make copy of line and convert to all caps */
			strcpy( input.chCARDCAPS , chCard );
			caps( input.chCARDCAPS );
			*lgEOF = FALSE;
		}
	}
	else
	{
		/* this is special case of reading cloudy.ini file, 
		 * nRead was set to 1+last image in input_init, so first time
		 * we get here it is very large.  decrement counter from end of file */
		input.nRead -= 1;

		/* last one with real data is NKRD+1-nSaveIni */
		last = NKRD - input.nSaveIni;

		/* this read is eof eof */
		if( input.nRead < last )
		{
			/* reset counter so we read in the proper direction */
			input.iReadWay = 1;
			/* pointer to next line to read.  this is on the scale where nRead-1
			 * is the actual array element */
			input.nRead = input.nReadSv+1;
		}

		/* check if we hit eof while reading in forward direction */
		if( input.iReadWay == 1 && input.nRead > input.nSave )
		{
			*lgEOF = TRUE;
		}
		else
		{
			strcpy( chCard, input.chCardSav[input.nRead] );

			/* save copy of the original input card */
			strcpy( input.chOrgCard, chCard );

			/* make copy of line and convert to all caps */
			strcpy( input.chCARDCAPS , chCard );
			caps( input.chCARDCAPS );

			/* did not hit eof */
			*lgEOF = FALSE;
		}
	}

	/* if any "trace" appeared on a command line, then this flag was set
	 * so print the input command before it is parsed */
	if( trace.lgTraceInput )
	{
		fprintf( ioQQQ, "input_readarray returns=%s=\n",chCard );
	}

#	ifdef DEBUG_FUN
	fputs( " <->input_readarray()\n", debug_fp );
#	endif
	return;
}

