/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* input.h */

/* limit to number of line images that can be read in */
#define	NKRD	4000

/* called when 'init' command hit, to reset counters for
 * placing line images within the storage array */
void input_init(void);

/* get the next input command off the command stack 
 * if more then copy into chCard and set lgEOF false,
 * if all command processed then set lgEOF true 
 */
void input_readarray(char *chCard, 
  int *lgEOF);

EXTERN struct t_input {

	/*
	 * copy of current line image, set when input_readarray is called,
	 * used by parser when original (not cap'd) line needed
	 */
	char chOrgCard[INPUT_LINE_LENGTH];

	/* 
	 * this is cap'd image of command line, for use with patern matches 
	 */
	char chCARDCAPS[INPUT_LINE_LENGTH];

	/* 
	 * we will save the original (not caped) image of the line here 
	 */
	char chCardSav[NKRD][INPUT_LINE_LENGTH], 

	/* 
	 * title entered with the title command 
	 */
	  chTitle[INPUT_LINE_LENGTH];

	long int 
	  /* total number of lines read in with cdRead */
	  nSave,

	  /* this points to the command we are now parsing, within the stack of commands */
	  nRead,		

	  /* number of init commands saved */
	  nSaveIni,	

	  /* +/-1, says whether to increment or decrement nRead, since init commands
		* are at the bottom of the stack and we read backwards */
	  iReadWay,	

	  /* saves current value of nRead, while parsing init commands */
	  nReadSv;	

	/* this is set true if underscore present in input stream, which was
	 * set to space */
	int lgUnderscoreFound;

	/* this is set true if left or right bracket, [ or ], present in input stream, which was
	 * set to space */
	int lgBracketFound;

	/* set true with no buffering command, used to print comment at end */
	int lgSetNoBuffering;

	}	input;


