/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */

/* following two macros used to define recombination coef arrays */
/* Max n desired in RRCoef file.	*/
/* >>chng 02 jan 28, from 10 to 20 so large HeI tests are fast */
/* this is the number of levels used with the
 * atom he-like levels large command */
/* Helium itself will have precompiled recombination coefficients up to this maximum n.	*/
#define HE_RREC_MAXN		40

/* Ions of the sequence will go up to this n.	*/
#define HE_LIKE_RREC_MAXN		10

#define N_HE_TE_RECOMB		21

/* This is the n to go up to when calculating total recombination.	Any change 
 * here will not be reflected in total recomb until "compile helike" is run	*/
#define SumUpToThisN	1000
/* the magic number for the table of recombination coefficients, YYMMDD */
/* >>chng 02 mar 08, data structure the same but improved fits to He photo cs */
#define RECOMBMAGIC		(40921)

/*HelikeCheckRecomb - called by SanityCheck to confirm that recombination coef are ok,
 * return value is relative error between new calculation of recom, and interp value */
double HelikeCheckRecomb(
	/* the chemical element, 1 for He */
	long nelem ,
	/* the level, 0 for ground */
	long level ,
	/* the temperature to be used */
	double temperature );

/*He_cross_section returns cross section (cm^-2), 
 * given EgammaRyd, the photon energy in Ryd,
 * ipLevel, the index of the level, 0 is ground, 3 within 2 3P,
 * ipZ is charge, equal to 1 for Helium,
 * this is a wrapper for cross_section */
double He_cross_section( double EgammaRyd , long ipLevel , long nelem );

void HelikeRecombSetup( void );

void HeRecom( /* nelem on the c scale, He is 1 */
	long nelem );
