/*H2_Read_Cosmicray_distribution read distribution function for H2 population following cosmic ray collisional excitation */
void H2_Read_Cosmicray_distribution(void);

/* read energies for all electronic levels */
void H2_ReadEnergies( long int nelec );

/* read dissociation probabilities and kinetic energies for all electronic levels */
void H2_ReadDissprob( long int nelec );

/* read collision rates */
void H2_ReadCollRates( long int nColl );

/* read transition probabilities */
void H2_ReadTransprob( long int nelec );

/*H2_Read_hminus_distribution read distribution function for H2 population following formation from H minus */
void H2_Read_hminus_distribution(void);

/*mole_H2_form find state specific rates grains and H- form H2 */
void mole_H2_form( void );

#define CR_PRINT	FALSE
#define CR_X	1
#define CR_VIB	15
#define CR_J	10
#define	CR_EXIT	3

/* the number of different types of colliders */
#define	N_X_COLLIDER	5

/* this is the highest vib state that has collision data */
#define	VIB_COLLID	3

/* this is the number of electronic levels */
#define N_H2_ELEC	7

/* the number of temperature points in the data file */
#define	nTE_HMINUS	7

/* these vars are private for H2 but uses same style as all other header files -
 * the EXTERN is extern in all except cddefines */

/* intensity, relative to normalization line, for faintest line to punch */
EXTERN float thresh_punline_h2;

EXTERN float ***H2_populations;

/* total population in each vib state */
EXTERN float **pops_per_vib;

/* the density (cm-3) of ortho H2 */
EXTERN double ortho_colden,
/* the density (cm-3) of para H2 */
	para_colden;

/* the renorm factor for this H2 to the chemistry - should be unity */
EXTERN float H2_renorm_chemistry;

/* column density within X only vib and rot */
EXTERN float **H2_X_colden;

/* LTE column density within X only vib and rot */
EXTERN float **H2_X_colden_LTE;

/* the number of ro-vib levels in each elec state */
EXTERN long int nLevels_per_elec[N_H2_ELEC];

/* this will hold the cr rates */
EXTERN float cr_rate[CR_X][CR_VIB][CR_J][CR_EXIT];

/* energy in wavenumbers */
EXTERN double ***energy_wn;

/* this is the actual rate, cm^3 s^-1, for each collider
 * CollRate[coll_type][vib_up][rot_up][vib_lo][rot_lo] */
EXTERN float ******CollRateFit;

/* these will mostly become xxx[elec][vib][rot] */
EXTERN float ***H2_dissprob;
EXTERN float ***H2_disske;
EXTERN float *****H2_CollRate;

/* these will mostly become xxx[elec][vib][rot] */
EXTERN float ***H2_old_populations;
EXTERN double ***H2_Boltzmann;
EXTERN double ***H2_populations_LTE;
/* this is total statistical weight, including nuclear spin */
EXTERN float ***H2_stat;
/* this is true if state is para, false if ortho */
EXTERN int ***H2_lgOrtho;

EXTERN int **H2_ipPhoto;
EXTERN float **H2_col_rate_in;
EXTERN float **H2_col_rate_out;
EXTERN float **H2_rad_rate_in;
EXTERN float **H2_rad_rate_out;

/* distribution function for formation on grain surfaces,
 * vib, rot, last dim is grain type */
EXTERN float ***H2_X_grain_formation_distribution;

/* formation into specific states witin X only vib and rot,
 * includes both H- and H2 routes */
EXTERN float **H2_X_formation;

/* save rate coef (cm3 s-1) for collisional dissociation */
EXTERN float **H2_coll_dissoc_rate_coef;

/* vib, rot, last dim is temperature */
EXTERN float ***H2_X_hminus_formation_distribution;

/* these are energies and indices for levels within X */
EXTERN float *H2_Xenergies;
EXTERN long int *H2_ipX_ener_sort;
EXTERN long int *ipVib_H2_energy_sort;
EXTERN long int *ipRot_H2_energy_sort;
EXTERN long int **ipEnergySort;

/* number of levels within X which are done with matrix solver,
 * set with atom h2 matrix command */
EXTERN long int nXLevelsMatrix;

/* this is array of accumulated line intensities, used for punch he lines command */
EXTERN double ****H2_SaveLine;

/* the remainder can't be EXTERN since init to values in h2.c */
extern int H2_nRot_add_ortho_para[N_H2_ELEC];

extern double H2_DissocEnergies[N_H2_ELEC];

/* temperature where H- distribution are set */
extern float H2_te_hminus[nTE_HMINUS];

/* number of vib states within electronic states from
 * >>refer	H2	energies	Abgrall, */
extern long int nVib_hi[N_H2_ELEC];

/* number of rotation levels within each elec - vib */
extern long int nRot_hi[N_H2_ELEC][50];

/* this gives the first rotational state for each electronic state - J=0 does
 * not exist when Lambda = 1 */
extern long int Jlowest[N_H2_ELEC];
