/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* create H2 molecules, called by ContCreatePointers */
void H2_Create(void);

/* set the ipCont struc element for the H2 molecule, called by ContCreatePointers */
void H2_ContPoint( void );

/*H2_DR choose next zone thickness based on H2 big molecule */
double H2_DR(void);

/*&H2_Init - called by cdInit to init H2 */
void H2_Init(void);

/* radiative acceleration due to H2 called in rt_line_driving */
double H2_Accel(void);

/*H2_RT_OTS - add H2 ots fields */
void H2_RT_OTS( void );

/* rad pre due to h2 lines called in PresTotCurrent*/
double H2_RadPress(void);

/* add in explicit lines from the large H2 molecule, called by lines_molecules */
void H2_LinesAdd(void);

/*H2_Reset called to reset variables that are needed after an iteration */
void H2_Reset( void );

/* internal energy of H2 called in PresTotCurrent */
double H2_InterEnergy(void);

/*H2_Colden maintain H2 column densities within X */
void H2_Colden( char *chLabel );

/*H2_cooling evaluate cooling and heating due to H2 molecule */
void H2_Cooling(void);

/* punch H2 line data */
void H2_Punch_line_data(
	/* io unit for punch */
	FILE* ioPUN ,
	/* punch all levels if true, only subset if false */
	int lgDoAll );

/* include H2 lines in punched optical depths, etc, called from PunchLineStuff */
void H2_PunchLineStuff( FILE * io , float xLimit  , long index);

/* do emission from H2 - called from RT_diffuse */
void H2_RT_diffuse(void);

/* do RT for H2 - called from RT_line_all */
void H2_RTMake( int lgDoEsc , 
			   int lgUpdateFineOpac );

/* increment optical depth for the H2 molecule, called from RT_tau_inc */
void H2_RT_tau_inc(void);

/* zero out vars in the large H2 molecule, called from zero */
void H2_Zero( void );

/*H2_Prt_Zone print H2 info into zone results, called from prtzone for each printed zone */
void H2_Prt_Zone(void);

/* initialize optical depths in H2, called from RT_tau_init */
void H2_LineZero( void );

/* the large H2 molecule, called from RT_tau_reset */
void H2_RT_tau_reset( void );

/* do level populations for H2, called by Hydrogenic */
void H2_LevelPops( void );

/* punch some properties of the large H2 molecule */
void H2_PunchDo( FILE* io , char chJOB[] , char chTime[] , long int ipPun );

/* print line optical depths, called from premet in response to print line optical depths command*/
void H2_Prt_line_tau(void);

/*H2_ParsePunch parse the punch h2 command */
void H2_ParsePunch( char *chCard );

/*H2_itrzn - average number of H2 pop evaluations per zone */
double H2_itrzn( void );

/*H2_Prt_column_density print H2 info into zone results, called from prtzone for each printed zone */
void H2_Prt_column_density(	
	/* this is stream used for io, is stdout when called by final,
	 * is punch unit when punch output generated */
	 FILE *ioMEAN );

/* flag saying whether molecular data have been read in yet */
extern int lgH2_READ_DATA;

EXTERN struct t_h2 {

	/* the density (cm-3) of ortho H2 */
	double ortho_density,
	/* the density (cm-3) of para H2 */
		para_density;

	/* these remember the largest and smallest factors needed to
	 * renormalize the H2 chemistry */
	double renorm_max ,
		renorm_min;

	/* this will say how many times the large H2 molecule has been called in this zone -
	 * if not called (due to low H2 abundance) then not need to update its line arrays */
	long int nCallH2_this_zone;

	/* flag saying whether to bother with the large H2 molecule at all,
	 * default is FALSE, set true with atom h2 on command */
	int lgH2ON;

}	h2;
