/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* this routine is called by zero(), so it should contain initializations
 * that need to be done every time before the input lines get parsed */

/* GrainDrive main routine to converge grains thermal solution */
void GrainDrive(void);

/*grain_ion_charge_transfer generate grain surface recombination and ionization rates for all ions */
void grain_ion_charge_transfer( void );

/* GrainDrift computes grains drift velocity */
void GrainDrift(void);

/* helper routine for initializing quantities related to the photo-electric effect */
void PE_init(long,long,long,/*@out@*/double*,/*@out@*/double*,/*@out@*/double*,
	     /*@out@*/double*,/*@out@*/double*,/*@out@*/double*,/*@out@*/double*);

void GrainZero(void);

/* this routine is called by IterStart() */
void GrainStartIter(void);

/* this routine is called by IterRestart() */
void GrainRestartIter(void);

/* this routine is called by ParseSet() */
void SetNChrgStates(long);

/* allocate new grain bin */
long NewGrainBin(void);

/* deallocate grain bins */
void ReturnGrainBins(void);

/* startup routine for grains, called before first calculations, but after parsecommands */
void InitGrains(void);

/* main routine for generating the grain diffuse emission */
void GrainMakeDiffuse(void);

/* main routine for quantum heating */
void qheat(/*@out@*/double[],/*@out@*/double[],/*@out@*/long*,long);

/* initialize interpolation arrays for grain enthalpy */
void InitEnthalpy(void);

typedef struct {
	double dep;
	int lgAbunVsDepth,
	  lgForbidQHeating,
	  lgGreyGrain,
	  lgRequestQHeating;
} GrainPar;

void mie_write_opc(/*@in@*/const char*,/*@in@*/const char*,long int);
void mie_read_opc(/*@in@*/const char*,GrainPar);
void gauss_init(long int,double,double,double[],double[],double[],double[]);
void gauss_legendre(long int,double[],double[]);
void find_arr(double,double[],long int,/*@out@*/long int*,/*@out@*/int*);

