/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*
 * gammas.h - all the routines to evaluate gamma functions 
 * contains the following:
 *
 * GammaBn evaluate photoionization rate for single shell with induced recomb
 * GammaBnPL evaluate photoionization rate for single shell with induced recomb 
 * GammaPrt special version of gamma function to print strong contributors 
 * GammaK evaluate photoionization rate for single shell 
 * GammaPL evaluate photoionization rate for power law photo cross section 
 */

/*GammaBn evaluate photoionization rate for single shell with induced recomb */
double GammaBn(long int n1, 
  long int n2, 
  long int ip, 
  double thresh, 
  double *ainduc, 
  double *rcool);

/*GammaPrtShells for the element nelem and ion, print total photo rate, subshells,
 * and call GamaPrt for important subshells */
void GammaPrtShells( long nelem , long int );

/*GammaPrt special version of gamma function to print strong contributors */
void GammaPrt(long int n1, 
	  long int n2, 
	  long int ip, 
	  FILE * io, /* io unit we will write to */
	  double total, 
	  double threshold);

/*GammaK evaluate photoionization rate for single shell */
double GammaK(long int n1, 
  long int n2, 
  long int ipOpac, 
  double yield1);

/*GammaPL evaluate photoionization rate for power law photo cross section */
double GammaPL(long int n, 
  long int ipZ)/* ipZ = 0 for H */;

/*GammaBnPL evaluate photoionization rate for single shell with induced recomb */
double GammaBnPL(long int n, 
  long int ipZ, /* 0 for H, etc */
  double *ainduc, 
  double *rcool);

/* GammaPrtRate will print resulting rates for ion and element */
void GammaPrtRate(
	/* io unit we will write to */
	FILE * ioFILE, 
	/* stage of ionization on C scale, 0 for atom */
	long int ion ,
	/* 0 for H, etc */
	long int ipZ,
	/* true - then print photo sources for valence shell */
	int lgPRT );
