/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* dense.h density laws */

/* variables dealing with pressure across model */
EXTERN struct t_dense {

	/* dense.gas_phase is the total gas phase abundances,
	 * including anything within molecules,
	 * but not including grains */
	float gas_phase[LIMELM];

	/* vector of atomic weights for all elements, set in zerologic */
	float AtomicWeight[LIMELM];

	/* dense.xMolecules density of elements locked in molecules, 
	 * this is included in gas_phase */
	float xMolecules[LIMELM];

	/*xMassDensity grams per cc */
	float xMassDensity, 
			
		/* WJH: fiducial value that corresponds to hden set in init file, this is 
		* used for setting the mass-flux in dynamic models */
		xMassDensity0,
		
		/* total number of particles per cubic centimeter */
		pden, 
		
		/* mean AMU per particle */
		wmole ,
		
		/* total number of nuclei, set in PressureTotal */
		xNucleiTotal ,
		
		/* total mass in grams */
		xMassTotal;

	/* indices for lowest stage of ionization of the elements on C scale, 
	 * lowest is 0 for atom, -1 if element turned off, 
	 * the first stage of ionization with positive abundance is [IonLow] where 0 is the atom,
	 * the highest stage of ionization with positive abundance is [IonHigh], 
	 * NB NB so loops should be 
	 * ion=IonLow, ion<=IonHigh */
	long int IonLow[LIMELM], 
	  IonHigh[LIMELM];

	/* dense.xIonDense[nelem][i] is density of ith ionization stage (cm^-3),
	 * [nelem][0] is atom, [][1]) the first ion
	 * nelem = 0 for H, 1 for he, etc
	 *
	 * with this scheme, 
	 * OIII is dense.xIonDense[ipOXYGEN][2]
	 * HII is dense.xIonDense[ipHYDROGEN][1] */

	/* at the moment 12CO, 13CO, and H2 are xIonDense[LIMELM][2], [L+1][3] and [L+2][1] */
	float xIonDense[LIMELM+3][LIMELM+1];

	/* array of logical variables saying whether an element is enable (TRUE)
	 * or disabled (FALSE).  It is set totally TRUE in zero
	 * and is set FALSE with the "element off" command.  
	 * In SetAbundances if can be reset so that an element that was disabled
	 * on the first model in a coreload is not later enabled */
	int lgElmtOn[LIMELM];

	/* will we solve for ionization (FALSE) or specify it with element ionization cmnd TRUE */
	int lgSetIoniz[LIMELM];

	/* dense.SetIoniz the ionization fractions that are set when lgSetIoniz set true,
	 * gas phase abundance is this times total aabundance
	 * Ionization fraction for [nelem][ion] */
	float SetIoniz[LIMELM][LIMELM];

	/* label describing the density law for current calculation
	 * 'DLW2' is tabden interpolated table */
	char chDenseLaw[5];

	/* parameters set by the dlaw command, used by fabden (maybe) */
	double DensityLaw[10];

#	define	LIMTABDLAW	500

	/*frad is log radius in cm, fhden is log hden*/
	float frad[LIMTABDLAW], 
	  fhden[LIMTABDLAW];

	/*number of values in above table */
	long int nvals;

	/*lg is true if depth, false if radius to be used*/
	int lgDLWDepth;

	/* electron density, units cm-3  */
	double eden;

	/*zone where bad electron density was detected */
	long int nzEdenBad;

	/*EdenSet electron density set with set eden command*/
	float EdenSet;

	/* extra electron density, set with eden command */
	float EdenExtra;

	/* square root of electron density, set in tfidle */
	float SqrtEden;

	/* EdenHCorr is eden + hi * 1.7e-4, includes correction for H atom collisions,
	 * units cm-3 */
	double EdenHCorr;

	/* this is the true eden as set in eden_sum, we will try to converge eden to this */
	double EdenTrue;

	/* fraction of electron density due to ions rather than molecules and grains */
	double eden_from_metals;

	/*flags set when bad electron density is detected */
	int lgEdenBad;

	/* parameters dealing with hydrogen density scaling as power of radius
	 *DensityPower is power */
	float DensityPower, 
	  rscale, 
	  den0;

	/* set true when density fluctuations are turned on */
	int lgDenFlucOn;
	/* parameters for the density fluctuations command */
	float flong, 
	  cfirst, 
	  csecnd;
	float flcPhase;

} dense;
