/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*CoolNitr evaluate total cooling due to nitrogen */
#include "cddefines.h"
#include "coolheavy.h"
#include "taulines.h"
#include "dense.h"
#include "phycon.h"
#include "ligbar.h"
#include "thermal.h"
#include "lines_service.h"
#include "embesq.h"
#include "atoms.h"
#include "cooling.h"

void CoolNitr()
{
	float p2;
	double a21, 
	  a31, 
	  a32, 
	  cs, 
	  cs2s2p, 
	  cs2s3p, 
	  cs21, 
	  cs31, 
	  cs32, 
	  p3;
	
#	ifdef DEBUG_FUN
	fputs( "<+>CoolNitr()\n", debug_fp );
#	endif

	/* >>chng 00 dec 11, add made-up collision strengths 
	 * These have made-up collision strengths  */
#	if 0
	PutCS(1.,&TauLines[ipT671]);
	atom_level2(&TauLines[ipT671]);

	PutCS(1.,&TauLines[ipT315]);
	atom_level2(&TauLines[ipT315]);

	PutCS(1.,&TauLines[ipT333]);
	atom_level2(&TauLines[ipT333]);

	PutCS(1.,&TauLines[ipT324]);
	atom_level2(&TauLines[ipT324]);

	PutCS(1.,&TauLines[ipT374g]);
	atom_level2(&TauLines[ipT374g]);

	PutCS(1.,&TauLines[ipT374x]);
	atom_level2(&TauLines[ipT374x]);
#	endif

	/* >>chng 01 sep 02, go back to old values */
	/* nitrogen I 5200, cs and A from 
	 * collision strengths from 
	 * >>referold	n1	cs	Dopita, M.A., Mason, D.J., Robb, W.D. 1976, ApJ, 207, 102*/
	cs21 = 1.32e-4*phycon.te/(phycon.te10*phycon.te01);
	cs31 = 3.60e-5*phycon.te/phycon.te10*phycon.te02;
	cs32 = 5.23e-4*phycon.te70*phycon.te10/phycon.te02;

	/* N.B. following cs also appears in nitrogen ionization balance */
	/* >>chng revise collision strengths to
	 * >>refer	n1	cs	Tayal, S.S., 2000, ADNDT, 76, 191 
	cs21 = 5.25e-13*phycon.tesqrd*phycon.te70*phycon.te03 ;
	cs31 = 3.79e-5*phycon.te70*phycon.te03;
	cs32 = 3.14e-13*phycon.tesqrd*phycon.te*phycon.te20*phycon.te07/phycon.te003;*/

	/* following does not have photoionization from excited state
	 * since already counted in photo balance equation
	 * TODO	2	use atom_level3 */

	/* trans prob from 
	 * >>refer	n1	as	Butler, K., & Zeippen, C.J. 1984, A&A, 141, 274
	 */
	a21 = 1.28e-5;
	a31 = 5.31e-3;
	a32 = 6.81e-2;
	/* >>chng 01 sep 02, include atoms.d5200r term here too */
	p3 = atom_pop3(4.,10.,6.,cs21,cs31,cs32,a21,a31,a32,2.769e4,1.38e4,
	  &p2,dense.xIonDense[ipNITROGEN][0],atoms.d5200r,0.,0.);
	/* chng 01 sep 02, evaluate here rather than in coolnit */
	atoms.p2nit = p2/SDIV(dense.xIonDense[ipNITROGEN][0]);

	CoolHeavy.c5200 = p2*a21*3.83e-12;
	CoolAdd("N  1",5200,CoolHeavy.c5200);
	thermal.dCooldT += CoolHeavy.c5200*(2.769e4*thermal.tsq1 + thermal.halfte);

	CoolHeavy.c10400 = p3*a32*1.91e-12;
	CoolAdd("N  1",10400,CoolHeavy.c10400);

	CoolHeavy.c3466 = p3*a31*5.74e-12;
	CoolAdd("N  1",3466,CoolHeavy.c3466);
	thermal.dCooldT += (CoolHeavy.c10400 + CoolHeavy.c3466)*(4.15e4*
	  thermal.tsq1 + thermal.halfte);

	/* N I 1200, cs from trans procb */
	PutCS(4.1,&TauLines[ipT1200]);
	atom_level2(&TauLines[ipT1200]);

	/* N II 1084, cs from trans prob */
	PutCS(5.5,&TauLines[ipT1085]);
	atom_level2(&TauLines[ipT1085]);

	/* coll data from 
	 * >>referold	n2	cs	Stafford, R.P., Bell, K.L, Hibbert, A. & Wijesundera, W.P.,
	 * >>rereroldcon 1994, MNRAS 268, 816,
	 * at 10,000K (v weak T dep)
	 * >>chng 00 dec 11, to Lennon & Burke
	 * >>refer	n2	cs	Lennon, D.J., & Burke, V.M., 1994, A&AS, 103, 273-277
	 * transit prob from 
	 * >>refer	n2	as	Nussbaumer, H., & Rusca, C. 1979, A&A, 72, 129
	 * 
	 * >>chng 00 dec 11, to Lennon & Burke cs */
	a21 = 3.65e-3;
	a31 = 0.0316;
	a32 = 1.17;
	/* >>chng 02 may 02, put in option to switch between lennon Burke and Stafford et al. ,
	 * default state of this var is TRUE */
#	define USE_LENNON_BURKE TRUE
#	if( USE_LENNON_BURKE )
		cs21 = 2.64;
		cs31 = 0.293;
		cs32 = 0.834;
#	else
		/* Bob Rubin could not find the stafford et al. numbers - it flag ever
		 * set false will not compile */
		cs21 = 3.02;
		cs31 = 0.372;
		cs32 = 0.505;
#	endif

	/* POP3(   G1,G2,G3,   O12,  O13,  O23,  A21, A31, A32,*/
	p3 = atom_pop3(  9.,5.,1.,  cs21, cs31, cs32, a21, a31, a32 ,
	/*   E12,E23,P2,ABUND,GAM2) */
		21955.,24982.,&p2,dense.xIonDense[ipNITROGEN][1],0.,0.,0.);

	CoolHeavy.c5755 = p3*a32*3.46e-12;

	CoolHeavy.c6584 = p2*a21*3.03e-12;
	thermal.dCooldT += CoolHeavy.c6584*(2.2e4*thermal.tsq1 - thermal.halfte);
	CoolAdd("N  2",5755,CoolHeavy.c5755);
	CoolAdd("N  2",6584,CoolHeavy.c6584);

	CoolHeavy.xN2_A3_tot = (a31+a32) /(a31+a32 + (cs31+cs32)/1.*phycon.cdsqte );

	/* N II fine structure lines, */
	/* >>chng 00 dec 11, to Lennon & Burke CS */
#	if( USE_LENNON_BURKE )
		cs21 = 0.408;
		cs32 = 1.12;
		cs31 = 0.272;
#	else
		/* Bob Rubin could not find the stafford et al. numbers - it flag ever
		 * set false will not compile */
		cs21 = 0.429;
		cs32 = 1.13;
		cs31 = 0.265;
#	endif


	PutCS(cs21,&TauLines[ipT205]);
	PutCS(cs32,&TauLines[ipT122]);
	PutCS(cs31,&TauDummy);
	atom_level3(&TauLines[ipT205],&TauLines[ipT122],&TauDummy);

	/* N II 2140, data 
	 * >>refer	n2	cs	Stafford, R.P., Bell, K.L, Hibbert, A. & Wijesundera, W.P. 1994,
	 * >>rerercon MNRAS, 268, 816
	 * >>refer	n2	cs	Lennon, D.J., & Burke, V.M., 1994, A&AS, 103, 273-277
	 * A from 
	 * >>refer	n2	as	Brage, T., Hibbert, A., Leckrone, D.S. 1997, ApJ, 478, 423 */
#	if( USE_LENNON_BURKE )
		cs21 = 1.19;
#	else
		/* Bob Rubin could not find the stafford et al. numbers - it flag ever
		 * set false will not compile */
		cs21 = 1.15;
#	endif

	PutCS(cs21,&TauLines[ipT2140]);
	atom_level2(&TauLines[ipT2140]);

	/* N III 989.8, cs from 
	 * >>refer	N3	cs	Blum, R.D., & Pradhan, A.K. 1992, ApJS 80, 425 */
	PutCS(7.12,&TauLines[ipT990]);
	atom_level2(&TauLines[ipT990]);

	/* 57 micron N III, A=
	 * >>refer	n3	as	Froese Fischer, C. 1983, J.Phys. B, 16, 157
	 * collision strength from 
	 * >>refer	n3	cs	Blum, R.D., & Pradhan, A.K. 1992, ApJS 80, 425 */
	cs = MIN2(1.90,0.2291*phycon.te10*phycon.te10);
	PutCS(cs,&TauLines[ipT57]);

	/* N III] N 3, N  3, 1765 multiplet */
	/*atom_level2(&TauLines[ipT57]);*/
	/*AtomSeqBoron compute cooling from 5-level boron sequence model atom */
	AtomSeqBoron(&TauLines[ipT57], 
	  &TauLines[ipN3_1749], 
	  &TauLines[ipN3_1747], 
	  &TauLines[ipN3_1754], 
	  &TauLines[ipN3_1752], 
	  &TauLines[ipN3_1751], 
	  0.201 , 1.088 , 0.668 , 2.044 , "N  3");
	/*fprintf(ioQQQ," n4 %.3e\n",  (
		TauLines[ipN3_1749].xIntensity + 
		TauLines[ipN3_1747].xIntensity + 
		TauLines[ipN3_1754].xIntensity+ 
		TauLines[ipN3_1752].xIntensity+ 
		TauLines[ipN3_1751].xIntensity) / dense.xIonDense[ipNITROGEN][2] );*/

	/* N IV 1486, N 4, N  4,collisions within 3P just guess
	 * cs to ground from 
	 * >>refer	n4	cs	Ramsbottom, C.A., Berrington, K.A., Hibbert, A., Bell, K.L. 1994,
	 * >>refercon Physica Scripta, 50, 246 */
	if( phycon.te > 1.584e4 )
	{
		cs = 21.346/(phycon.te10*phycon.te10*phycon.te10*phycon.te02);
	}
	else
	{
		cs = 75.221/(phycon.sqrte/phycon.te03/phycon.te02);
	}
	/* >>chng 01 sep 09, AtomSeqBeryllium will reset this to 1/3 so critical density correct */
	cs = MAX2(0.01,cs);
	PutCS(cs,&TauLines[ipT1486]);
	/* AtomSeqBeryllium(CS23,CS24,CS34,tarray,A41) */
	AtomSeqBeryllium(.9,.9,3.0,&TauLines[ipT1486],.0115);
	embesq.em1486 = (float)(atoms.PopLevels[3]*0.0115*1.34e-11);
	/*fprintf(ioQQQ," n4 %.3e\n", (TauLines[ipT1486].xIntensity + embesq.em1486 ) / dense.xIonDense[ipNITROGEN][3] );*/

	/* N IV 765, cs from 
	 * >>refer	n4	cs	Ramsbottom, C.A., Berrington, K.A., Hibbert, A., Bell, K.L. 1994,
	 * >>refercon Physica Scripta, 50, 246 */
	/* >>refer	n4	as	Flemming, J., Brage, T., Bell, K.L., Vaeck, N., Hibbert, A., 
	 * >>refercon	Godefroid, M., & Froese Fischer, C., 1995, ApJ, 455, 758*/
	cs = MIN2(4.0,1.864*phycon.te03*phycon.te03);
	PutCS(cs,&TauLines[ipT765]);
	atom_level2(&TauLines[ipT765]);

	/* N V 1240
	 * >>refer	n5	cs	Cochrane, D.M., & McWhirter, R.W.P. 1983, PhyS, 28, 25 */
	ligbar(7,&TauLines[ipT1239],&TauLines[ipT209],&cs2s2p,&cs2s3p);
	PutCS(cs2s2p,&TauLines[ipT1239]);
	PutCS(cs2s2p*0.5,&TauLines[ipT1243]);
	PutCS(1.0,&TauDummy);
	atom_level3(&TauLines[ipT1243],&TauDummy,&TauLines[ipT1239]);
	/*fprintf(ioQQQ," n5 %.3e\n", (TauLines[ipT1243].xIntensity + TauLines[ipT1239].xIntensity ) / dense.xIonDense[ipNITROGEN][4] );*/

	/* N V 209 */
	PutCS(cs2s3p,&TauLines[ipT209]);
	atom_level2(&TauLines[ipT209]);

#	ifdef DEBUG_FUN
	fputs( " <->CoolNitr()\n", debug_fp );
#	endif
	return;
}
