/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* colden.h */
/* number of column densities to remember */
#define	NCOLD	9

/* total hydrogen column density, all forms, xxx + 2*H2 */
#define	ipCOL_HTOT	0
/* H minus column denisty*/
#define	ipCHMIN	1
/* column density of H2 */
#define	ipCOLH2	2
/* H2+ */
#define	ipCH2PLS	3
/* HI */
#define	ipCHI	4
/* HeH+ */
#define	ipCHEHP	5
/* H+ */
#define	ipCHII	6
/* CH3+ */
#define	ipCH3PLS	7
/* column density in electrons */
#define	ipCELE	8

EXTERN struct t_colden {

	/*save total column densities in various species for this and 
	 * previous iteration, to check whether
	 * it changed by too much (a bad sign)
	 * column densities, mostly h molecule related */
	float colden[NCOLD], 
		/* the previous iteration's coluumn density */
	  colden_old[NCOLD];

	/* integral of ne np over radius */
	double dlnenp;
	/* integral of ne n(He+) over radius */
	double dlnenHep;
	/* integral of ne nHe++) over radius */
	double dlnenHepp;

	/* pops and column density for CII atom */
	float C2Pops[5],
		C2Colden[5];

	/* pops and column density for upper level of CIII] atom */
	float C3Pops[4],
		C3Colden[4];

	/* pops and column density for SiII atom */
	float Si2Pops[5],
		Si2Colden[5];

	/* pops and column density for CI atom */
	float C1Pops[3],
		C1Colden[3];

	/* pops and column density for OI atom */
	float O1Pops[3],
		O1Colden[3];

	/* He I 23S */
	double He123S;

	}	colden;
