/* This file is part of Cloudy and is copyright (C) 1978-2004 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*atmdat_rad_rec calculates rates of radiative recombination for all ions */
#ifdef _MSC_VER
#	pragma warning( disable : 4305 )/* disable truncation from const doub to float warning in MS VS*/
#endif
#include "cddefines.h"
#include "atmdat.h"

struct t_ADfArrec {
	float rrec[30][30][2];
	}	ADfArrec;

struct t_ADfArnew {
	float rnew[30][30][4];
	}	ADfArnew;

struct t_ADfAferr {
	float fe[13][3];
	}	ADfAferr;

void rrfitdata(void);
void rrfitdata1(void);
void rrfitdata2(void);
void rrfitdata3(void);
void rrfitdata4(void);
void rrfitdata5(void);
void rrfitdata6(void);
void rrfitdata7(void);

double atmdat_rad_rec(long int iz, 
	  long int in, 
	  double t)
{
	/*
	 *** Version 4. June 29, 1999.
	 *** Written by D. A. Verner, verner@pa.uky.edu 
	 ******************************************************************************
	 *** This subroutine calculates rates of radiative recombination for all ions
	 *** of all elements from H through Zn by use of the following fits:
	 *** H-like, He-like, Li-like, Na-like - 
	 *** >>refer	all	reccoef	Verner & Ferland, 1996, ApJS, 103, 467
	 *** Other ions of C, N, O, Ne - Pequignot et al. 1991, A&A, 251, 680,
	 ***    refitted by Verner & Ferland formula to ensure correct asymptotes
	 *** Fe XVII-XXIII - 
	 *** >>refer	Fe17-23	recom	Arnaud & Raymond, 1992, ApJ, 398, 394
	 *** Fe I-XV - refitted by Verner & Ferland formula to ensure correct asymptotes
	 *** Other ions of Mg, Si, S, Ar, Ca, Fe, Ni - 
	 ***                      -
	 *** >>refer	all	recom	Shull & Van Steenberg, 1982, ApJS, 48, 95
	 *** Other ions of Na, Al - 
	 *** >>refer	Na, Al	recom	Landini & Monsignori Fossi, 1990, A&AS, 82, 229
	 *** Other ions of F, P, Cl, K, Ti, Cr, Mn, Co (excluding Ti I-II, Cr I-IV,
	 *** Mn I-V, Co I)        - 
	 *** >>refer	many	recom	Landini & Monsignori Fossi, 1991, A&AS, 91, 183
	 *** All other species    - interpolations of the power-law fits
	 *** Input parameters:  iz - atomic number 
	 ***                    in - number of electrons from 1 to iz 
	 ***                    t  - temperature, K
	 *** return result:  - rate coefficient, cm^3 s^(-1)
	 ******************************************************************************
	 */
	double tt;
	static int lgFIRST=TRUE;
	double rate;

#	ifdef DEBUG_FUN
	fputs( "<+>atmdat_rad_rec()\n", debug_fp );
#	endif

	/* the very first time this is called we need to set up the block data */
	if( lgFIRST )
	{
		rrfitdata();
		rrfitdata1();
		rrfitdata2();
		rrfitdata3();
		rrfitdata4();
		rrfitdata5();
		rrfitdata6();
		rrfitdata7();
		lgFIRST = FALSE;
	}
#	if 0
	for(iz=2; iz<=30; ++iz )
	{
		fprintf(ioQQQ,"%li\t%.3e\n", iz,
		  ADfArnew.rnew[1][iz-1][0] );
	}
	for(iz=2; iz<=30; ++iz )
	{
		fprintf(ioQQQ,"%li\t%.5f\n", iz,
		  ADfArnew.rnew[1][iz-1][1] );
	}
	fprintf(ioQQQ,"stopstopsteop\n");
	cdEXIT(EXIT_FAILURE);
#	endif

	rate = 0.0;
	if( iz < 1 || iz > 30 )
	{
		fprintf( ioQQQ, " atmdat_rad_rec called with insane atomic number, =%4ld\n", 
		  iz );
		puts( "[Stop in atmdat_rad_rec]" );
		cdEXIT(EXIT_FAILURE);
	}
	if( in < 1 || in > iz )
	{
		fprintf( ioQQQ, " atmdat_rad_rec called with insane number elec =%4ld\n", 
		  in );
		puts( "[Stop in atmdat_rad_rec]" );
		cdEXIT(EXIT_FAILURE);
	}
	if( (((in <= 3 || in == 11) || (iz > 5 && iz < 9)) || iz == 10) || 
	  (iz == 26 && in > 11) )
	{
		tt = sqrt(t/ADfArnew.rnew[in-1][iz-1][2]);
		rate = 
		  ADfArnew.rnew[in-1][iz-1][0]/(tt*pow(tt + 1.0,1.0 - ADfArnew.rnew[in-1][iz-1][1])*
		  pow(1.0 + sqrt(t/ADfArnew.rnew[in-1][iz-1][3]),1.0 + ADfArnew.rnew[in-1][iz-1][1]));
	}
	else
	{
		tt = t*1.0e-04;
		if( iz == 26 && in <= 13 )
		{
			rate = ADfAferr.fe[in-1][0]/pow(tt,ADfAferr.fe[in-1][1] + 
			  ADfAferr.fe[in-1][2]*log10(tt));
		}
		else
		{
			rate = ADfArrec.rrec[in-1][iz-1][0]/pow(tt,(double)ADfArrec.rrec[in-1][iz-1][1]);
		}
	}
	
#	ifdef DEBUG_FUN
	fputs( " <->atmdat_rad_rec()\n", debug_fp );
#	endif

	return rate;
}

	static long int i, 
	  _r;

/********************************************* */
void rrfitdata(void)
{
		{ static float _itmp0[] = {4.500e-13,0.6480};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][3][i-1] = _itmp0[_r++];
			}
		}
		{ static float _itmp1[] = {2.680e-12,0.7250};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][4][i-1] = _itmp1[_r++];
			}
		}
		{ static float _itmp2[] = {4.900e-12,0.8030};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][5][i-1] = _itmp2[_r++];
			}
		}
		{ static float _itmp3[] = {9.400e-12,0.7650};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][6][i-1] = _itmp3[_r++];
			}
		}
		{ static float _itmp4[] = {1.590e-11,0.7590};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][7][i-1] = _itmp4[_r++];
			}
		}
		{ static float _itmp5[] = {1.919e-11,0.7849};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][8][i-1] = _itmp5[_r++];
			}
		}
		{ static float _itmp6[] = {2.800e-11,0.7710};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][9][i-1] = _itmp6[_r++];
			}
		}
		{ static float _itmp7[] = {4.030e-11,0.7873};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][10][i-1] = _itmp7[_r++];
			}
		}
		{ static float _itmp8[] = {6.830e-11,0.7650};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][11][i-1] = _itmp8[_r++];
			}
		}
		{ static float _itmp9[] = {8.343e-11,0.8291};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][12][i-1] = _itmp9[_r++];
			}
		}
		{ static float _itmp10[] = {1.430e-10,0.8230};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][13][i-1] = _itmp10[_r++];
			}
		}
		{ static float _itmp11[] = {1.460e-10,0.8391};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][14][i-1] = _itmp11[_r++];
			}
		}
		{ static float _itmp12[] = {2.000e-10,0.8060};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][15][i-1] = _itmp12[_r++];
			}
		}
		{ static float _itmp13[] = {2.091e-10,0.8691};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][16][i-1] = _itmp13[_r++];
			}
		}
		{ static float _itmp14[] = {3.070e-10,0.8190};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][17][i-1] = _itmp14[_r++];
			}
		}
		{ static float _itmp15[] = {3.210e-10,0.8934};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][18][i-1] = _itmp15[_r++];
			}
		}
		{ static float _itmp16[] = {4.610e-10,0.8330};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][19][i-1] = _itmp16[_r++];
			}
		}
		{ static float _itmp17[] = {4.870e-10,0.8060};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][20][i-1] = _itmp17[_r++];
			}
		}
		{ static float _itmp18[] = {5.139e-10,0.7781};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][21][i-1] = _itmp18[_r++];
			}
		}
		{ static float _itmp19[] = {5.850e-10,0.7570};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][22][i-1] = _itmp19[_r++];
			}
		}
		{ static float _itmp20[] = {6.556e-10,0.7359};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][23][i-1] = _itmp20[_r++];
			}
		}
		{ static float _itmp21[] = {7.238e-10,0.7242};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][24][i-1] = _itmp21[_r++];
			}
		}
		{ static float _itmp22[] = {8.404e-10,0.7167};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][26][i-1] = _itmp22[_r++];
			}
		}
		{ static float _itmp23[] = {1.360e-09,0.8420};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][27][i-1] = _itmp23[_r++];
			}
		}
		{ static float _itmp24[] = {1.880e-09,0.8420};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][28][i-1] = _itmp24[_r++];
			}
		}
		{ static float _itmp25[] = {2.400e-09,0.8420};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[3][29][i-1] = _itmp25[_r++];
			}
		}
		{ static float _itmp26[] = {4.600e-13,0.6360};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][4][i-1] = _itmp26[_r++];
			}
		}
		{ static float _itmp27[] = {2.300e-12,0.6450};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][5][i-1] = _itmp27[_r++];
			}
		}
		{ static float _itmp28[] = {5.000e-12,0.6760};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][6][i-1] = _itmp28[_r++];
			}
		}
		{ static float _itmp29[] = {9.600e-12,0.6700};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][7][i-1] = _itmp29[_r++];
			}
		}
		{ static float _itmp30[] = {1.558e-11,0.6816};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][8][i-1] = _itmp30[_r++];
			}
		}
		{ static float _itmp31[] = {2.300e-11,0.7040};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][9][i-1] = _itmp31[_r++];
			}
		}
		{ static float _itmp32[] = {3.253e-11,0.7075};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][10][i-1] = _itmp32[_r++];
			}
		}
		{ static float _itmp33[] = {4.600e-11,0.7110};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][11][i-1] = _itmp33[_r++];
			}
		}
		{ static float _itmp34[] = {5.951e-11,0.7125};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][12][i-1] = _itmp34[_r++];
			}
		}
		{ static float _itmp35[] = {7.700e-11,0.7140};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][13][i-1] = _itmp35[_r++];
			}
		}
		{ static float _itmp36[] = {1.042e-10,0.7330};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][14][i-1] = _itmp36[_r++];
			}
		}
		{ static float _itmp37[] = {1.400e-10,0.7550};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][15][i-1] = _itmp37[_r++];
			}
		}
		{ static float _itmp38[] = {1.760e-10,0.7682};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][16][i-1] = _itmp38[_r++];
			}
		}
		{ static float _itmp39[] = {2.140e-10,0.7740};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][17][i-1] = _itmp39[_r++];
			}
		}
		{ static float _itmp40[] = {2.629e-10,0.7772};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][18][i-1] = _itmp40[_r++];
			}
		}
		{ static float _itmp41[] = {3.240e-10,0.7800};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][19][i-1] = _itmp41[_r++];
			}
		}
		{ static float _itmp42[] = {3.970e-10,0.7840};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][20][i-1] = _itmp42[_r++];
			}
		}
		{ static float _itmp43[] = {4.700e-10,0.7873};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][21][i-1] = _itmp43[_r++];
			}
		}
		{ static float _itmp44[] = {5.500e-10,0.7910};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][22][i-1] = _itmp44[_r++];
			}
		}
		{ static float _itmp45[] = {6.301e-10,0.7952};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][23][i-1] = _itmp45[_r++];
			}
		}
		{ static float _itmp46[] = {7.058e-10,0.7982};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][24][i-1] = _itmp46[_r++];
			}
		}
		{ static float _itmp47[] = {8.252e-10,0.8004};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][26][i-1] = _itmp47[_r++];
			}
		}
		{ static float _itmp48[] = {8.710e-10,0.8000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][27][i-1] = _itmp48[_r++];
			}
		}
		{ static float _itmp49[] = {9.170e-10,0.8000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][28][i-1] = _itmp49[_r++];
			}
		}
		{ static float _itmp50[] = {9.630e-10,0.7990};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[4][29][i-1] = _itmp50[_r++];
			}
		}
		{ static float _itmp51[] = {4.700e-13,0.6240};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][5][i-1] = _itmp51[_r++];
			}
		}
		{ static float _itmp52[] = {2.200e-12,0.6390};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][6][i-1] = _itmp52[_r++];
			}
		}
		{ static float _itmp53[] = {5.100e-12,0.6600};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][7][i-1] = _itmp53[_r++];
			}
		}
		{ static float _itmp54[] = {9.171e-12,0.6757};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][8][i-1] = _itmp54[_r++];
			}
		}
		{ static float _itmp55[] = {1.500e-11,0.6840};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][9][i-1] = _itmp55[_r++];
			}
		}
		{ static float _itmp56[] = {2.191e-11,0.6875};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][10][i-1] = _itmp56[_r++];
			}
		}
		{ static float _itmp57[] = {3.200e-11,0.6910};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][11][i-1] = _itmp57[_r++];
			}
		}
		{ static float _itmp58[] = {4.308e-11,0.6970};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][12][i-1] = _itmp58[_r++];
			}
		}
		{ static float _itmp59[] = {5.800e-11,0.7030};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][13][i-1] = _itmp59[_r++];
			}
		}
		{ static float _itmp60[] = {7.316e-11,0.7027};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][14][i-1] = _itmp60[_r++];
			}
		}
		{ static float _itmp61[] = {9.200e-11,0.7140};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][15][i-1] = _itmp61[_r++];
			}
		}
		{ static float _itmp62[] = {1.198e-10,0.7508};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][16][i-1] = _itmp62[_r++];
			}
		}
}
void rrfitdata1(void)
{
		{ static float _itmp63[] = {1.580e-10,0.7900};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][17][i-1] = _itmp63[_r++];
			}
		}
		{ static float _itmp64[] = {2.048e-10,0.8032};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][18][i-1] = _itmp64[_r++];
			}
		}
		{ static float _itmp65[] = {2.600e-10,0.8000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][19][i-1] = _itmp65[_r++];
			}
		}
		{ static float _itmp66[] = {3.280e-10,0.7990};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][20][i-1] = _itmp66[_r++];
			}
		}
		{ static float _itmp67[] = {3.966e-10,0.7973};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][21][i-1] = _itmp67[_r++];
			}
		}
		{ static float _itmp68[] = {4.760e-10,0.8000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][22][i-1] = _itmp68[_r++];
			}
		}
		{ static float _itmp69[] = {5.547e-10,0.8027};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][23][i-1] = _itmp69[_r++];
			}
		}
		{ static float _itmp70[] = {6.313e-10,0.8058};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][24][i-1] = _itmp70[_r++];
			}
		}
		{ static float _itmp71[] = {7.503e-10,0.8085};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][26][i-1] = _itmp71[_r++];
			}
		}
		{ static float _itmp72[] = {7.940e-10,0.8080};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][27][i-1] = _itmp72[_r++];
			}
		}
		{ static float _itmp73[] = {8.380e-10,0.8080};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][28][i-1] = _itmp73[_r++];
			}
		}
		{ static float _itmp74[] = {8.810e-10,0.8070};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[5][29][i-1] = _itmp74[_r++];
			}
		}
		{ static float _itmp75[] = {4.100e-13,0.6080};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][6][i-1] = _itmp75[_r++];
			}
		}
		{ static float _itmp76[] = {2.000e-12,0.6460};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][7][i-1] = _itmp76[_r++];
			}
		}
		{ static float _itmp77[] = {5.231e-12,0.6615};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][8][i-1] = _itmp77[_r++];
			}
		}
		{ static float _itmp78[] = {9.100e-12,0.6680};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][9][i-1] = _itmp78[_r++];
			}
		}
		{ static float _itmp79[] = {1.447e-11,0.6814};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][10][i-1] = _itmp79[_r++];
			}
		}
		{ static float _itmp80[] = {2.300e-11,0.6950};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][11][i-1] = _itmp80[_r++];
			}
		}
		{ static float _itmp81[] = {3.145e-11,0.6915};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][12][i-1] = _itmp81[_r++];
			}
		}
		{ static float _itmp82[] = {4.300e-11,0.6880};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][13][i-1] = _itmp82[_r++];
			}
		}
		{ static float _itmp83[] = {5.659e-11,0.7023};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][14][i-1] = _itmp83[_r++];
			}
		}
		{ static float _itmp84[] = {7.400e-11,0.7160};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][15][i-1] = _itmp84[_r++];
			}
		}
		{ static float _itmp85[] = {9.561e-11,0.7102};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][16][i-1] = _itmp85[_r++];
			}
		}
		{ static float _itmp86[] = {1.230e-10,0.7020};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][17][i-1] = _itmp86[_r++];
			}
		}
		{ static float _itmp87[] = {1.587e-10,0.7105};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][18][i-1] = _itmp87[_r++];
			}
		}
		{ static float _itmp88[] = {2.040e-10,0.7300};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][19][i-1] = _itmp88[_r++];
			}
		}
		{ static float _itmp89[] = {2.630e-10,0.7490};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][20][i-1] = _itmp89[_r++];
			}
		}
		{ static float _itmp90[] = {3.220e-10,0.7683};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][21][i-1] = _itmp90[_r++];
			}
		}
		{ static float _itmp91[] = {3.950e-10,0.7830};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][22][i-1] = _itmp91[_r++];
			}
		}
		{ static float _itmp92[] = {4.671e-10,0.7967};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][23][i-1] = _itmp92[_r++];
			}
		}
		{ static float _itmp93[] = {5.407e-10,0.8058};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][24][i-1] = _itmp93[_r++];
			}
		}
		{ static float _itmp94[] = {6.611e-10,0.8121};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][26][i-1] = _itmp94[_r++];
			}
		}
		{ static float _itmp95[] = {7.080e-10,0.8110};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][27][i-1] = _itmp95[_r++];
			}
		}
		{ static float _itmp96[] = {7.550e-10,0.8100};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][28][i-1] = _itmp96[_r++];
			}
		}
		{ static float _itmp97[] = {8.020e-10,0.8090};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[6][29][i-1] = _itmp97[_r++];
			}
		}
		{ static float _itmp98[] = {3.100e-13,0.6780};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][7][i-1] = _itmp98[_r++];
			}
		}
		{ static float _itmp99[] = {1.344e-12,0.6708};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][8][i-1] = _itmp99[_r++];
			}
		}
		{ static float _itmp100[] = {4.400e-12,0.6750};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][9][i-1] = _itmp100[_r++];
			}
		}
		{ static float _itmp101[] = {7.849e-12,0.6952};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][10][i-1] = _itmp101[_r++];
			}
		}
		{ static float _itmp102[] = {1.400e-11,0.7160};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][11][i-1] = _itmp102[_r++];
			}
		}
		{ static float _itmp103[] = {2.049e-11,0.7090};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][12][i-1] = _itmp103[_r++];
			}
		}
		{ static float _itmp104[] = {3.000e-11,0.7020};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][13][i-1] = _itmp104[_r++];
			}
		}
		{ static float _itmp105[] = {4.125e-11,0.6965};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][14][i-1] = _itmp105[_r++];
			}
		}
		{ static float _itmp106[] = {5.500e-11,0.7110};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][15][i-1] = _itmp106[_r++];
			}
		}
		{ static float _itmp107[] = {7.280e-11,0.7518};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][16][i-1] = _itmp107[_r++];
			}
		}
		{ static float _itmp108[] = {9.550e-11,0.7930};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][17][i-1] = _itmp108[_r++];
			}
		}
		{ static float _itmp109[] = {1.235e-10,0.8052};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][18][i-1] = _itmp109[_r++];
			}
		}
		{ static float _itmp110[] = {1.580e-10,0.8000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][19][i-1] = _itmp110[_r++];
			}
		}
		{ static float _itmp111[] = {2.060e-10,0.7990};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][20][i-1] = _itmp111[_r++];
			}
		}
		{ static float _itmp112[] = {2.537e-10,0.7977};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][21][i-1] = _itmp112[_r++];
			}
		}
		{ static float _itmp113[] = {3.190e-10,0.8020};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][22][i-1] = _itmp113[_r++];
			}
		}
		{ static float _itmp114[] = {3.844e-10,0.8071};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][23][i-1] = _itmp114[_r++];
			}
		}
		{ static float _itmp115[] = {4.564e-10,0.8124};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][24][i-1] = _itmp115[_r++];
			}
		}
		{ static float _itmp116[] = {5.842e-10,0.8168};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][26][i-1] = _itmp116[_r++];
			}
		}
		{ static float _itmp117[] = {6.380e-10,0.8160};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][27][i-1] = _itmp117[_r++];
			}
		}
		{ static float _itmp118[] = {6.920e-10,0.8150};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][28][i-1] = _itmp118[_r++];
			}
		}
		{ static float _itmp119[] = {7.460e-10,0.8140};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[7][29][i-1] = _itmp119[_r++];
			}
		}
		{ static float _itmp120[] = {6.273e-13,0.6798};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][8][i-1] = _itmp120[_r++];
			}
		}
		{ static float _itmp121[] = {1.500e-12,0.6930};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][9][i-1] = _itmp121[_r++];
			}
		}
		{ static float _itmp122[] = {3.399e-12,0.7054};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][10][i-1] = _itmp122[_r++];
			}
		}
		{ static float _itmp123[] = {7.700e-12,0.7180};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][11][i-1] = _itmp123[_r++];
			}
		}
		{ static float _itmp124[] = {1.275e-11,0.7170};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][12][i-1] = _itmp124[_r++];
			}
		}
		{ static float _itmp125[] = {2.110e-11,0.7160};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][13][i-1] = _itmp125[_r++];
			}
		}
}
void rrfitdata2(void)
{
		{ static float _itmp126[] = {2.975e-11,0.6945};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][14][i-1] = _itmp126[_r++];
			}
		}
		{ static float _itmp127[] = {4.000e-11,0.6960};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][15][i-1] = _itmp127[_r++];
			}
		}
		{ static float _itmp128[] = {5.281e-11,0.7491};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][16][i-1] = _itmp128[_r++];
			}
		}
		{ static float _itmp129[] = {6.920e-11,0.8110};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][17][i-1] = _itmp129[_r++];
			}
		}
		{ static float _itmp130[] = {9.044e-11,0.8251};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][18][i-1] = _itmp130[_r++];
			}
		}
		{ static float _itmp131[] = {1.180e-10,0.8100};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][19][i-1] = _itmp131[_r++];
			}
		}
		{ static float _itmp132[] = {1.580e-10,0.8040};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][20][i-1] = _itmp132[_r++];
			}
		}
		{ static float _itmp133[] = {1.983e-10,0.7980};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][21][i-1] = _itmp133[_r++];
			}
		}
		{ static float _itmp134[] = {2.570e-10,0.8040};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][22][i-1] = _itmp134[_r++];
			}
		}
		{ static float _itmp135[] = {3.154e-10,0.8101};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][23][i-1] = _itmp135[_r++];
			}
		}
		{ static float _itmp136[] = {3.837e-10,0.8183};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][24][i-1] = _itmp136[_r++];
			}
		}
		{ static float _itmp137[] = {5.147e-10,0.8253};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][26][i-1] = _itmp137[_r++];
			}
		}
		{ static float _itmp138[] = {5.750e-10,0.8240};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][27][i-1] = _itmp138[_r++];
			}
		}
		{ static float _itmp139[] = {6.350e-10,0.8230};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][28][i-1] = _itmp139[_r++];
			}
		}
		{ static float _itmp140[] = {6.960e-10,0.8210};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[8][29][i-1] = _itmp140[_r++];
			}
		}
		{ static float _itmp141[] = {2.200e-13,0.7590};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][9][i-1] = _itmp141[_r++];
			}
		}
		{ static float _itmp142[] = {8.775e-13,0.7467};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][10][i-1] = _itmp142[_r++];
			}
		}
		{ static float _itmp143[] = {3.500e-12,0.7340};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][11][i-1] = _itmp143[_r++];
			}
		}
		{ static float _itmp144[] = {6.481e-12,0.7345};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][12][i-1] = _itmp144[_r++];
			}
		}
		{ static float _itmp145[] = {1.200e-11,0.7350};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][13][i-1] = _itmp145[_r++];
			}
		}
		{ static float _itmp146[] = {1.834e-11,0.7285};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][14][i-1] = _itmp146[_r++];
			}
		}
		{ static float _itmp147[] = {2.700e-11,0.7330};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][15][i-1] = _itmp147[_r++];
			}
		}
		{ static float _itmp148[] = {3.711e-11,0.7641};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][16][i-1] = _itmp148[_r++];
			}
		}
		{ static float _itmp149[] = {4.900e-11,0.8010};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][17][i-1] = _itmp149[_r++];
			}
		}
		{ static float _itmp150[] = {6.444e-11,0.8175};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][18][i-1] = _itmp150[_r++];
			}
		}
		{ static float _itmp151[] = {8.510e-11,0.8200};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][19][i-1] = _itmp151[_r++];
			}
		}
		{ static float _itmp152[] = {1.170e-10,0.8220};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][20][i-1] = _itmp152[_r++];
			}
		}
		{ static float _itmp153[] = {1.494e-10,0.8242};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][21][i-1] = _itmp153[_r++];
			}
		}
		{ static float _itmp154[] = {2.010e-10,0.8280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][22][i-1] = _itmp154[_r++];
			}
		}
		{ static float _itmp155[] = {2.525e-10,0.8311};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][23][i-1] = _itmp155[_r++];
			}
		}
		{ static float _itmp156[] = {3.177e-10,0.8341};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][24][i-1] = _itmp156[_r++];
			}
		}
		{ static float _itmp157[] = {4.552e-10,0.8364};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][26][i-1] = _itmp157[_r++];
			}
		}
		{ static float _itmp158[] = {5.250e-10,0.8360};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][27][i-1] = _itmp158[_r++];
			}
		}
		{ static float _itmp159[] = {5.950e-10,0.8360};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][28][i-1] = _itmp159[_r++];
			}
		}
		{ static float _itmp160[] = {6.650e-10,0.8350};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[9][29][i-1] = _itmp160[_r++];
			}
		}
		{ static float _itmp161[] = {1.400e-13,0.8550};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][11][i-1] = _itmp161[_r++];
			}
		}
		{ static float _itmp162[] = {7.197e-13,0.7697};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][12][i-1] = _itmp162[_r++];
			}
		}
		{ static float _itmp163[] = {3.700e-12,0.6930};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][13][i-1] = _itmp163[_r++];
			}
		}
		{ static float _itmp164[] = {7.980e-12,0.6829};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][14][i-1] = _itmp164[_r++];
			}
		}
		{ static float _itmp165[] = {1.200e-11,0.7010};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][15][i-1] = _itmp165[_r++];
			}
		}
		{ static float _itmp166[] = {1.800e-11,0.7232};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][16][i-1] = _itmp166[_r++];
			}
		}
		{ static float _itmp167[] = {2.690e-11,0.7440};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][17][i-1] = _itmp167[_r++];
			}
		}
		{ static float _itmp168[] = {3.748e-11,0.7628};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][18][i-1] = _itmp168[_r++];
			}
		}
		{ static float _itmp169[] = {5.040e-11,0.7800};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][19][i-1] = _itmp169[_r++];
			}
		}
		{ static float _itmp170[] = {7.240e-11,0.7950};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][20][i-1] = _itmp170[_r++];
			}
		}
		{ static float _itmp171[] = {9.440e-11,0.8107};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][21][i-1] = _itmp171[_r++];
			}
		}
		{ static float _itmp172[] = {1.350e-10,0.8220};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][22][i-1] = _itmp172[_r++];
			}
		}
		{ static float _itmp173[] = {1.751e-10,0.8340};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][23][i-1] = _itmp173[_r++];
			}
		}
		{ static float _itmp174[] = {2.298e-10,0.8417};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][24][i-1] = _itmp174[_r++];
			}
		}
		{ static float _itmp175[] = {3.461e-10,0.8469};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][26][i-1] = _itmp175[_r++];
			}
		}
		{ static float _itmp176[] = {4.030e-10,0.8460};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][27][i-1] = _itmp176[_r++];
			}
		}
		{ static float _itmp177[] = {4.600e-10,0.8450};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][28][i-1] = _itmp177[_r++];
			}
		}
		{ static float _itmp178[] = {5.170e-10,0.8440};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[11][29][i-1] = _itmp178[_r++];
			}
		}
		{ static float _itmp179[] = {3.980e-13,0.8019};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][12][i-1] = _itmp179[_r++];
			}
		}
		{ static float _itmp180[] = {1.000e-12,0.7860};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][13][i-1] = _itmp180[_r++];
			}
		}
		{ static float _itmp181[] = {2.558e-12,0.7629};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][14][i-1] = _itmp181[_r++];
			}
		}
		{ static float _itmp182[] = {5.700e-12,0.7550};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][15][i-1] = _itmp182[_r++];
			}
		}
		{ static float _itmp183[] = {1.011e-11,0.7703};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][16][i-1] = _itmp183[_r++];
			}
		}
		{ static float _itmp184[] = {1.580e-11,0.7930};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][17][i-1] = _itmp184[_r++];
			}
		}
		{ static float _itmp185[] = {2.448e-11,0.8052};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][18][i-1] = _itmp185[_r++];
			}
		}
		{ static float _itmp186[] = {3.760e-11,0.8100};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][19][i-1] = _itmp186[_r++];
			}
		}
		{ static float _itmp187[] = {5.870e-11,0.8150};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][20][i-1] = _itmp187[_r++];
			}
		}
		{ static float _itmp188[] = {7.972e-11,0.8206};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][21][i-1] = _itmp188[_r++];
			}
		}
}
void rrfitdata3(void)
{
		{ static float _itmp189[] = {1.130e-10,0.8270};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][22][i-1] = _itmp189[_r++];
			}
		}
		{ static float _itmp190[] = {1.470e-10,0.8325};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][23][i-1] = _itmp190[_r++];
			}
		}
		{ static float _itmp191[] = {1.908e-10,0.8372};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][24][i-1] = _itmp191[_r++];
			}
		}
		{ static float _itmp192[] = {2.976e-10,0.8406};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][26][i-1] = _itmp192[_r++];
			}
		}
		{ static float _itmp193[] = {3.630e-10,0.8400};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][27][i-1] = _itmp193[_r++];
			}
		}
		{ static float _itmp194[] = {4.280e-10,0.8390};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][28][i-1] = _itmp194[_r++];
			}
		}
		{ static float _itmp195[] = {4.940e-10,0.8390};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[12][29][i-1] = _itmp195[_r++];
			}
		}
		{ static float _itmp196[] = {5.900e-13,0.6010};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][13][i-1] = _itmp196[_r++];
			}
		}
		{ static float _itmp197[] = {1.294e-12,0.6766};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][14][i-1] = _itmp197[_r++];
			}
		}
		{ static float _itmp198[] = {2.700e-12,0.7450};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][15][i-1] = _itmp198[_r++];
			}
		}
		{ static float _itmp199[] = {5.165e-12,0.7893};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][16][i-1] = _itmp199[_r++];
			}
		}
		{ static float _itmp200[] = {9.120e-12,0.8110};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][17][i-1] = _itmp200[_r++];
			}
		}
		{ static float _itmp201[] = {1.513e-11,0.8186};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][18][i-1] = _itmp201[_r++];
			}
		}
		{ static float _itmp202[] = {2.400e-11,0.8200};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][19][i-1] = _itmp202[_r++];
			}
		}
		{ static float _itmp203[] = {3.960e-11,0.8220};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][20][i-1] = _itmp203[_r++];
			}
		}
		{ static float _itmp204[] = {5.518e-11,0.8245};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][21][i-1] = _itmp204[_r++];
			}
		}
		{ static float _itmp205[] = {8.370e-11,0.8280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][22][i-1] = _itmp205[_r++];
			}
		}
		{ static float _itmp206[] = {1.123e-10,0.8313};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][23][i-1] = _itmp206[_r++];
			}
		}
		{ static float _itmp207[] = {1.525e-10,0.8342};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][24][i-1] = _itmp207[_r++];
			}
		}
		{ static float _itmp208[] = {2.000e-10,0.8360};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][25][i-1] = _itmp208[_r++];
			}
		}
		{ static float _itmp209[] = {2.537e-10,0.8364};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][26][i-1] = _itmp209[_r++];
			}
		}
		{ static float _itmp210[] = {3.160e-10,0.8360};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][27][i-1] = _itmp210[_r++];
			}
		}
		{ static float _itmp211[] = {3.780e-10,0.8360};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][28][i-1] = _itmp211[_r++];
			}
		}
		{ static float _itmp212[] = {4.410e-10,0.8350};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[13][29][i-1] = _itmp212[_r++];
			}
		}
		{ static float _itmp213[] = {9.761e-13,0.6209};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][14][i-1] = _itmp213[_r++];
			}
		}
		{ static float _itmp214[] = {1.800e-12,0.6860};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][15][i-1] = _itmp214[_r++];
			}
		}
		{ static float _itmp215[] = {3.320e-12,0.7579};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][16][i-1] = _itmp215[_r++];
			}
		}
		{ static float _itmp216[] = {6.030e-12,0.8120};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][17][i-1] = _itmp216[_r++];
			}
		}
		{ static float _itmp217[] = {1.063e-11,0.8269};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][18][i-1] = _itmp217[_r++];
			}
		}
		{ static float _itmp218[] = {1.800e-11,0.8200};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][19][i-1] = _itmp218[_r++];
			}
		}
		{ static float _itmp219[] = {3.130e-11,0.8180};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][20][i-1] = _itmp219[_r++];
			}
		}
		{ static float _itmp220[] = {4.451e-11,0.8153};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][21][i-1] = _itmp220[_r++];
			}
		}
		{ static float _itmp221[] = {6.830e-11,0.8200};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][22][i-1] = _itmp221[_r++];
			}
		}
		{ static float _itmp222[] = {9.206e-11,0.8246};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][23][i-1] = _itmp222[_r++];
			}
		}
		{ static float _itmp223[] = {1.250e-10,0.8302};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][24][i-1] = _itmp223[_r++];
			}
		}
		{ static float _itmp224[] = {1.640e-10,0.8340};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][25][i-1] = _itmp224[_r++];
			}
		}
		{ static float _itmp225[] = {2.093e-10,0.8349};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][26][i-1] = _itmp225[_r++];
			}
		}
		{ static float _itmp226[] = {2.630e-10,0.8340};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][27][i-1] = _itmp226[_r++];
			}
		}
		{ static float _itmp227[] = {3.170e-10,0.8330};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][28][i-1] = _itmp227[_r++];
			}
		}
		{ static float _itmp228[] = {3.700e-10,0.8320};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[14][29][i-1] = _itmp228[_r++];
			}
		}
		{ static float _itmp229[] = {4.100e-13,0.6300};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][15][i-1] = _itmp229[_r++];
			}
		}
		{ static float _itmp230[] = {1.248e-12,0.7663};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][16][i-1] = _itmp230[_r++];
			}
		}
		{ static float _itmp231[] = {3.230e-12,0.8690};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][17][i-1] = _itmp231[_r++];
			}
		}
		{ static float _itmp232[] = {6.384e-12,0.8790};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][18][i-1] = _itmp232[_r++];
			}
		}
		{ static float _itmp233[] = {1.070e-11,0.8400};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][19][i-1] = _itmp233[_r++];
			}
		}
		{ static float _itmp234[] = {1.920e-11,0.8210};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][20][i-1] = _itmp234[_r++];
			}
		}
		{ static float _itmp235[] = {2.765e-11,0.8012};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][21][i-1] = _itmp235[_r++];
			}
		}
		{ static float _itmp236[] = {4.650e-11,0.8060};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][22][i-1] = _itmp236[_r++];
			}
		}
		{ static float _itmp237[] = {6.539e-11,0.8099};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][23][i-1] = _itmp237[_r++];
			}
		}
		{ static float _itmp238[] = {9.539e-11,0.8202};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][24][i-1] = _itmp238[_r++];
			}
		}
		{ static float _itmp239[] = {1.330e-10,0.8280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][25][i-1] = _itmp239[_r++];
			}
		}
		{ static float _itmp240[] = {1.769e-10,0.8299};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][26][i-1] = _itmp240[_r++];
			}
		}
		{ static float _itmp241[] = {2.290e-10,0.8280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][27][i-1] = _itmp241[_r++];
			}
		}
		{ static float _itmp242[] = {2.810e-10,0.8260};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][28][i-1] = _itmp242[_r++];
			}
		}
		{ static float _itmp243[] = {3.330e-10,0.8240};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[15][29][i-1] = _itmp243[_r++];
			}
		}
		{ static float _itmp244[] = {1.010e-12,0.7380};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][16][i-1] = _itmp244[_r++];
			}
		}
		{ static float _itmp245[] = {1.950e-12,0.7520};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][17][i-1] = _itmp245[_r++];
			}
		}
		{ static float _itmp246[] = {3.766e-12,0.7662};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][18][i-1] = _itmp246[_r++];
			}
		}
		{ static float _itmp247[] = {7.080e-12,0.7800};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][19][i-1] = _itmp247[_r++];
			}
		}
		{ static float _itmp248[] = {1.430e-11,0.7920};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][20][i-1] = _itmp248[_r++];
			}
		}
		{ static float _itmp249[] = {2.152e-11,0.8038};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][21][i-1] = _itmp249[_r++];
			}
		}
		{ static float _itmp250[] = {3.740e-11,0.8120};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][22][i-1] = _itmp250[_r++];
			}
		}
		{ static float _itmp251[] = {5.335e-11,0.8207};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][23][i-1] = _itmp251[_r++];
			}
		}
}
void rrfitdata4(void)
{
		{ static float _itmp252[] = {7.807e-11,0.8260};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][24][i-1] = _itmp252[_r++];
			}
		}
		{ static float _itmp253[] = {1.090e-10,0.8290};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][25][i-1] = _itmp253[_r++];
			}
		}
		{ static float _itmp254[] = {1.459e-10,0.8296};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][26][i-1] = _itmp254[_r++];
			}
		}
		{ static float _itmp255[] = {1.910e-10,0.8290};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][27][i-1] = _itmp255[_r++];
			}
		}
		{ static float _itmp256[] = {2.360e-10,0.8280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][28][i-1] = _itmp256[_r++];
			}
		}
		{ static float _itmp257[] = {2.810e-10,0.8280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[16][29][i-1] = _itmp257[_r++];
			}
		}
		{ static float _itmp258[] = {3.770e-13,0.6510};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][17][i-1] = _itmp258[_r++];
			}
		}
		{ static float _itmp259[] = {1.304e-12,0.6753};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][18][i-1] = _itmp259[_r++];
			}
		}
		{ static float _itmp260[] = {3.960e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][19][i-1] = _itmp260[_r++];
			}
		}
		{ static float _itmp261[] = {1.130e-11,0.7240};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][20][i-1] = _itmp261[_r++];
			}
		}
		{ static float _itmp262[] = {1.857e-11,0.7484};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][21][i-1] = _itmp262[_r++];
			}
		}
		{ static float _itmp263[] = {3.170e-11,0.7680};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][22][i-1] = _itmp263[_r++];
			}
		}
		{ static float _itmp264[] = {4.479e-11,0.7883};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][23][i-1] = _itmp264[_r++];
			}
		}
		{ static float _itmp265[] = {6.106e-11,0.8020};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][24][i-1] = _itmp265[_r++];
			}
		}
		{ static float _itmp266[] = {8.130e-11,0.8100};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][25][i-1] = _itmp266[_r++];
			}
		}
		{ static float _itmp267[] = {1.098e-10,0.8118};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][26][i-1] = _itmp267[_r++];
			}
		}
		{ static float _itmp268[] = {1.500e-10,0.8100};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][27][i-1] = _itmp268[_r++];
			}
		}
		{ static float _itmp269[] = {1.900e-10,0.8080};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][28][i-1] = _itmp269[_r++];
			}
		}
		{ static float _itmp270[] = {2.300e-10,0.8060};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[17][29][i-1] = _itmp270[_r++];
			}
		}
		{ static float _itmp271[] = {2.762e-13,0.8023};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][18][i-1] = _itmp271[_r++];
			}
		}
		{ static float _itmp272[] = {6.780e-13,0.8000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][19][i-1] = _itmp272[_r++];
			}
		}
		{ static float _itmp273[] = {2.330e-12,0.7980};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][20][i-1] = _itmp273[_r++];
			}
		}
		{ static float _itmp274[] = {3.983e-12,0.7955};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][21][i-1] = _itmp274[_r++];
			}
		}
		{ static float _itmp275[] = {1.150e-11,0.7940};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][22][i-1] = _itmp275[_r++];
			}
		}
		{ static float _itmp276[] = {1.906e-11,0.7919};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][23][i-1] = _itmp276[_r++];
			}
		}
		{ static float _itmp277[] = {3.620e-11,0.7907};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][24][i-1] = _itmp277[_r++];
			}
		}
		{ static float _itmp278[] = {6.050e-11,0.7900};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][25][i-1] = _itmp278[_r++];
			}
		}
		{ static float _itmp279[] = {8.818e-11,0.7898};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][26][i-1] = _itmp279[_r++];
			}
		}
		{ static float _itmp280[] = {1.190e-10,0.7900};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][27][i-1] = _itmp280[_r++];
			}
		}
		{ static float _itmp281[] = {1.500e-10,0.7900};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][28][i-1] = _itmp281[_r++];
			}
		}
		{ static float _itmp282[] = {1.810e-10,0.7900};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[18][29][i-1] = _itmp282[_r++];
			}
		}
		{ static float _itmp283[] = {1.120e-13,0.9000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][19][i-1] = _itmp283[_r++];
			}
		}
		{ static float _itmp284[] = {6.540e-13,0.8670};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][20][i-1] = _itmp284[_r++];
			}
		}
		{ static float _itmp285[] = {1.196e-12,0.8344};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][21][i-1] = _itmp285[_r++];
			}
		}
		{ static float _itmp286[] = {5.330e-12,0.8090};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][22][i-1] = _itmp286[_r++];
			}
		}
		{ static float _itmp287[] = {9.471e-12,0.7846};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][23][i-1] = _itmp287[_r++];
			}
		}
		{ static float _itmp288[] = {2.169e-11,0.7683};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][24][i-1] = _itmp288[_r++];
			}
		}
		{ static float _itmp289[] = {4.120e-11,0.7590};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][25][i-1] = _itmp289[_r++];
			}
		}
		{ static float _itmp290[] = {6.409e-11,0.7570};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][26][i-1] = _itmp290[_r++];
			}
		}
		{ static float _itmp291[] = {8.910e-11,0.7590};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][27][i-1] = _itmp291[_r++];
			}
		}
		{ static float _itmp292[] = {1.140e-10,0.7610};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][28][i-1] = _itmp292[_r++];
			}
		}
		{ static float _itmp293[] = {1.390e-10,0.7630};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[19][29][i-1] = _itmp293[_r++];
			}
		}
		{ static float _itmp294[] = {1.170e-13,0.8980};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][20][i-1] = _itmp294[_r++];
			}
		}
		{ static float _itmp295[] = {5.330e-12,0.8640};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][21][i-1] = _itmp295[_r++];
			}
		}
		{ static float _itmp296[] = {1.060e-11,0.8300};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][22][i-1] = _itmp296[_r++];
			}
		}
		{ static float _itmp297[] = {1.580e-11,0.7960};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][23][i-1] = _itmp297[_r++];
			}
		}
		{ static float _itmp298[] = {2.100e-11,0.7620};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][24][i-1] = _itmp298[_r++];
			}
		}
		{ static float _itmp299[] = {2.620e-11,0.7280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][25][i-1] = _itmp299[_r++];
			}
		}
		{ static float _itmp300[] = {2.822e-11,0.7280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][26][i-1] = _itmp300[_r++];
			}
		}
		{ static float _itmp301[] = {3.040e-11,0.7280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][27][i-1] = _itmp301[_r++];
			}
		}
		{ static float _itmp302[] = {3.260e-11,0.7280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][28][i-1] = _itmp302[_r++];
			}
		}
		{ static float _itmp303[] = {3.480e-11,0.7280};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[20][29][i-1] = _itmp303[_r++];
			}
		}
		{ static float _itmp304[] = {1.220e-13,0.8970};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[21][21][i-1] = _itmp304[_r++];
			}
		}
		{ static float _itmp305[] = {3.870e-12,0.8480};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[21][22][i-1] = _itmp305[_r++];
			}
		}
		{ static float _itmp306[] = {7.610e-12,0.7980};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[21][23][i-1] = _itmp306[_r++];
			}
		}
		{ static float _itmp307[] = {1.140e-11,0.7480};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[21][24][i-1] = _itmp307[_r++];
			}
		}
		{ static float _itmp308[] = {1.510e-11,0.6990};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[21][25][i-1] = _itmp308[_r++];
			}
		}
		{ static float _itmp309[] = {1.626e-11,0.6990};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[21][26][i-1] = _itmp309[_r++];
			}
		}
		{ static float _itmp310[] = {1.750e-11,0.6990};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[21][27][i-1] = _itmp310[_r++];
			}
		}
		{ static float _itmp311[] = {1.870e-11,0.6990};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[21][28][i-1] = _itmp311[_r++];
			}
		}
		{ static float _itmp312[] = {2.000e-11,0.6990};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[21][29][i-1] = _itmp312[_r++];
			}
		}
		{ static float _itmp313[] = {1.270e-13,0.8950};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[22][22][i-1] = _itmp313[_r++];
			}
		}
		{ static float _itmp314[] = {2.680e-12,0.8240};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[22][23][i-1] = _itmp314[_r++];
			}
		}
}
void rrfitdata5(void)
{
		{ static float _itmp315[] = {5.240e-12,0.7530};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[22][24][i-1] = _itmp315[_r++];
			}
		}
		{ static float _itmp316[] = {7.800e-12,0.6820};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[22][25][i-1] = _itmp316[_r++];
			}
		}
		{ static float _itmp317[] = {8.402e-12,0.6820};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[22][26][i-1] = _itmp317[_r++];
			}
		}
		{ static float _itmp318[] = {9.050e-12,0.6820};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[22][27][i-1] = _itmp318[_r++];
			}
		}
		{ static float _itmp319[] = {9.700e-12,0.6820};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[22][28][i-1] = _itmp319[_r++];
			}
		}
		{ static float _itmp320[] = {1.030e-11,0.6820};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[22][29][i-1] = _itmp320[_r++];
			}
		}
		{ static float _itmp321[] = {1.320e-13,0.8940};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[23][23][i-1] = _itmp321[_r++];
			}
		}
		{ static float _itmp322[] = {1.730e-12,0.8200};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[23][24][i-1] = _itmp322[_r++];
			}
		}
		{ static float _itmp323[] = {3.320e-12,0.7460};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[23][25][i-1] = _itmp323[_r++];
			}
		}
		{ static float _itmp324[] = {3.575e-12,0.7460};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[23][26][i-1] = _itmp324[_r++];
			}
		}
		{ static float _itmp325[] = {3.580e-12,0.7460};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[23][27][i-1] = _itmp325[_r++];
			}
		}
		{ static float _itmp326[] = {3.580e-12,0.7460};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[23][28][i-1] = _itmp326[_r++];
			}
		}
		{ static float _itmp327[] = {3.590e-12,0.7460};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[23][29][i-1] = _itmp327[_r++];
			}
		}
		{ static float _itmp328[] = {1.370e-13,0.8920};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[24][24][i-1] = _itmp328[_r++];
			}
		}
		{ static float _itmp329[] = {1.020e-12,0.8430};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[24][25][i-1] = _itmp329[_r++];
			}
		}
		{ static float _itmp330[] = {1.278e-12,0.7682};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[24][26][i-1] = _itmp330[_r++];
			}
		}
		{ static float _itmp331[] = {1.600e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[24][27][i-1] = _itmp331[_r++];
			}
		}
		{ static float _itmp332[] = {1.920e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[24][28][i-1] = _itmp332[_r++];
			}
		}
		{ static float _itmp333[] = {2.240e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[24][29][i-1] = _itmp333[_r++];
			}
		}
		{ static float _itmp334[] = {1.420e-13,0.8910};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[25][25][i-1] = _itmp334[_r++];
			}
		}
		{ static float _itmp335[] = {4.459e-13,0.7897};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[25][26][i-1] = _itmp335[_r++];
			}
		}
		{ static float _itmp336[] = {1.400e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[25][27][i-1] = _itmp336[_r++];
			}
		}
		{ static float _itmp337[] = {1.500e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[25][28][i-1] = _itmp337[_r++];
			}
		}
		{ static float _itmp338[] = {1.600e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[25][29][i-1] = _itmp338[_r++];
			}
		}
		{ static float _itmp339[] = {2.510e-13,0.7950};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[26][26][i-1] = _itmp339[_r++];
			}
		}
		{ static float _itmp340[] = {1.000e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[26][27][i-1] = _itmp340[_r++];
			}
		}
		{ static float _itmp341[] = {1.000e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[26][28][i-1] = _itmp341[_r++];
			}
		}
		{ static float _itmp342[] = {1.100e-12,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[26][29][i-1] = _itmp342[_r++];
			}
		}
		{ static float _itmp343[] = {3.600e-13,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[27][27][i-1] = _itmp343[_r++];
			}
		}
		{ static float _itmp344[] = {3.600e-13,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[27][28][i-1] = _itmp344[_r++];
			}
		}
		{ static float _itmp345[] = {3.600e-13,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[27][29][i-1] = _itmp345[_r++];
			}
		}
		{ static float _itmp346[] = {3.600e-13,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[28][28][i-1] = _itmp346[_r++];
			}
		}
		{ static float _itmp347[] = {3.600e-13,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[28][29][i-1] = _itmp347[_r++];
			}
		}
		{ static float _itmp348[] = {3.600e-13,0.7000};
		for( i=1, _r = 0; i <= 2; i++ )
		{
			ADfArrec.rrec[29][29][i-1] = _itmp348[_r++];
			}
		}
		{ static float _itmp349[] = {7.982e-11,0.7480,3.148e00,7.036e05};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][0][i-1] = _itmp349[_r++];
			}
		}
		{ static float _itmp350[] = {1.891e-10,0.7524,9.370e00,2.774e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][1][i-1] = _itmp350[_r++];
			}
		}
		{ static float _itmp351[] = {3.039e-10,0.7539,1.871e01,6.209e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][2][i-1] = _itmp351[_r++];
			}
		}
		{ static float _itmp352[] = {4.290e-10,0.7557,3.000e01,1.093e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][3][i-1] = _itmp352[_r++];
			}
		}
		{ static float _itmp353[] = {5.437e-10,0.7560,4.576e01,1.706e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][4][i-1] = _itmp353[_r++];
			}
		}
		{ static float _itmp354[] = {6.556e-10,0.7567,6.523e01,2.446e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][5][i-1] = _itmp354[_r++];
			}
		}
		{ static float _itmp355[] = {7.586e-10,0.7563,9.015e01,3.338e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][6][i-1] = _itmp355[_r++];
			}
		}
		{ static float _itmp356[] = {8.616e-10,0.7563,1.191e02,4.352e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][7][i-1] = _itmp356[_r++];
			}
		}
		{ static float _itmp357[] = {9.712e-10,0.7566,1.499e02,5.498e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][8][i-1] = _itmp357[_r++];
			}
		}
		{ static float _itmp358[] = {1.085e-09,0.7570,1.834e02,6.776e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][9][i-1] = _itmp358[_r++];
			}
		}
		{ static float _itmp359[] = {1.163e-09,0.7558,2.328e02,8.262e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][10][i-1] = _itmp359[_r++];
			}
		}
		{ static float _itmp360[] = {1.317e-09,0.7574,2.585e02,9.769e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][11][i-1] = _itmp360[_r++];
			}
		}
		{ static float _itmp361[] = {1.419e-09,0.7578,3.057e02,1.143e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][12][i-1] = _itmp361[_r++];
			}
		}
		{ static float _itmp362[] = {1.517e-09,0.7574,3.601e02,1.329e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][13][i-1] = _itmp362[_r++];
			}
		}
		{ static float _itmp363[] = {1.586e-09,0.7560,4.327e02,1.534e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][14][i-1] = _itmp363[_r++];
			}
		}
		{ static float _itmp364[] = {1.729e-09,0.7568,4.725e02,1.746e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][15][i-1] = _itmp364[_r++];
			}
		}
		{ static float _itmp365[] = {1.791e-09,0.7565,5.591e02,1.972e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][16][i-1] = _itmp365[_r++];
			}
		}
		{ static float _itmp366[] = {1.913e-09,0.7567,6.175e02,2.212e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][17][i-1] = _itmp366[_r++];
			}
		}
		{ static float _itmp367[] = {2.033e-09,0.7569,6.797e02,2.463e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][18][i-1] = _itmp367[_r++];
			}
		}
		{ static float _itmp368[] = {2.129e-09,0.7570,7.591e02,2.739e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][19][i-1] = _itmp368[_r++];
			}
		}
		{ static float _itmp369[] = {2.262e-09,0.7578,8.186e02,3.000e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][20][i-1] = _itmp369[_r++];
			}
		}
		{ static float _itmp370[] = {2.370e-09,0.7574,9.002e02,3.307e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][21][i-1] = _itmp370[_r++];
			}
		}
		{ static float _itmp371[] = {2.415e-09,0.7565,1.032e03,3.635e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][22][i-1] = _itmp371[_r++];
			}
		}
		{ static float _itmp372[] = {2.537e-09,0.7571,1.108e03,3.954e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][23][i-1] = _itmp372[_r++];
			}
		}
		{ static float _itmp373[] = {2.618e-09,0.7565,1.225e03,4.307e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][24][i-1] = _itmp373[_r++];
			}
		}
		{ static float _itmp374[] = {2.735e-09,0.7568,1.314e03,4.659e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][25][i-1] = _itmp374[_r++];
			}
		}
		{ static float _itmp375[] = {2.809e-09,0.7565,1.444e03,5.042e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][26][i-1] = _itmp375[_r++];
			}
		}
		{ static float _itmp376[] = {3.002e-09,0.7581,1.467e03,5.409e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][27][i-1] = _itmp376[_r++];
			}
		}
		{ static float _itmp377[] = {3.022e-09,0.7564,1.666e03,5.855e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][28][i-1] = _itmp377[_r++];
			}
		}
}
void rrfitdata6(void)
{
		{ static float _itmp378[] = {3.127e-09,0.7567,1.779e03,6.246e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[0][29][i-1] = _itmp378[_r++];
			}
		}
		{ static float _itmp379[] = {9.356e-10,0.7892,4.266e-02,4.677e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][1][i-1] = _itmp379[_r++];
			}
		}
		{ static float _itmp380[] = {1.112e-10,0.6926,2.437e01,8.323e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][2][i-1] = _itmp380[_r++];
			}
		}
		{ static float _itmp381[] = {1.317e-10,0.6691,8.473e01,1.412e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][3][i-1] = _itmp381[_r++];
			}
		}
		{ static float _itmp382[] = {1.922e-10,0.6717,1.272e02,1.975e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][4][i-1] = _itmp382[_r++];
			}
		}
		{ static float _itmp383[] = {2.765e-10,0.6858,1.535e02,2.556e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][5][i-1] = _itmp383[_r++];
			}
		}
		{ static float _itmp384[] = {3.910e-10,0.6988,1.611e02,3.271e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][6][i-1] = _itmp384[_r++];
			}
		}
		{ static float _itmp385[] = {4.897e-10,0.7048,1.906e02,4.093e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][7][i-1] = _itmp385[_r++];
			}
		}
		{ static float _itmp386[] = {5.602e-10,0.7052,2.476e02,5.077e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][8][i-1] = _itmp386[_r++];
			}
		}
		{ static float _itmp387[] = {6.161e-10,0.7029,3.274e02,6.243e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][9][i-1] = _itmp387[_r++];
			}
		}
		{ static float _itmp388[] = {6.833e-10,0.7018,4.060e02,7.491e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][10][i-1] = _itmp388[_r++];
			}
		}
		{ static float _itmp389[] = {7.510e-10,0.7020,4.921e02,8.643e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][11][i-1] = _itmp389[_r++];
			}
		}
		{ static float _itmp390[] = {8.182e-10,0.7008,5.875e02,1.007e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][12][i-1] = _itmp390[_r++];
			}
		}
		{ static float _itmp391[] = {8.722e-10,0.6996,7.098e02,1.155e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][13][i-1] = _itmp391[_r++];
			}
		}
		{ static float _itmp392[] = {9.142e-10,0.6961,8.682e02,1.335e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][14][i-1] = _itmp392[_r++];
			}
		}
		{ static float _itmp393[] = {9.692e-10,0.6945,1.017e03,1.517e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][15][i-1] = _itmp393[_r++];
			}
		}
		{ static float _itmp394[] = {1.021e-09,0.6932,1.184e03,1.695e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][16][i-1] = _itmp394[_r++];
			}
		}
		{ static float _itmp395[] = {1.087e-09,0.6936,1.329e03,1.880e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][17][i-1] = _itmp395[_r++];
			}
		}
		{ static float _itmp396[] = {1.145e-09,0.6921,1.503e03,2.098e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][18][i-1] = _itmp396[_r++];
			}
		}
		{ static float _itmp397[] = {1.179e-09,0.6893,1.757e03,2.344e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][19][i-1] = _itmp397[_r++];
			}
		}
		{ static float _itmp398[] = {1.265e-09,0.6902,1.877e03,2.555e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][20][i-1] = _itmp398[_r++];
			}
		}
		{ static float _itmp399[] = {1.322e-09,0.6885,2.092e03,2.829e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][21][i-1] = _itmp399[_r++];
			}
		}
		{ static float _itmp400[] = {1.375e-09,0.6885,2.321e03,3.056e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][22][i-1] = _itmp400[_r++];
			}
		}
		{ static float _itmp401[] = {1.422e-09,0.6874,2.589e03,3.336e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][23][i-1] = _itmp401[_r++];
			}
		}
		{ static float _itmp402[] = {1.488e-09,0.6867,2.802e03,3.623e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][24][i-1] = _itmp402[_r++];
			}
		}
		{ static float _itmp403[] = {1.542e-09,0.6859,3.073e03,3.926e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][25][i-1] = _itmp403[_r++];
			}
		}
		{ static float _itmp404[] = {1.589e-09,0.6846,3.373e03,4.267e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][26][i-1] = _itmp404[_r++];
			}
		}
		{ static float _itmp405[] = {1.676e-09,0.6861,3.530e03,4.538e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][27][i-1] = _itmp405[_r++];
			}
		}
		{ static float _itmp406[] = {1.686e-09,0.6824,4.031e03,4.948e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][28][i-1] = _itmp406[_r++];
			}
		}
		{ static float _itmp407[] = {1.758e-09,0.6834,4.254e03,5.258e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[1][29][i-1] = _itmp407[_r++];
			}
		}
		{ static float _itmp408[] = {1.036e-11,0.3880,1.077e02,1.177e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][2][i-1] = _itmp408[_r++];
			}
		}
		{ static float _itmp409[] = {2.338e-11,0.4211,3.647e02,1.215e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][3][i-1] = _itmp409[_r++];
			}
		}
		{ static float _itmp410[] = {4.487e-11,0.4644,5.371e02,1.465e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][4][i-1] = _itmp410[_r++];
			}
		}
		{ static float _itmp411[] = {8.540e-11,0.5247,5.014e02,1.479e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][5][i-1] = _itmp411[_r++];
			}
		}
		{ static float _itmp412[] = {1.169e-10,0.5470,6.793e02,1.650e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][6][i-1] = _itmp412[_r++];
			}
		}
		{ static float _itmp413[] = {2.053e-10,0.6019,4.772e02,1.711e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][7][i-1] = _itmp413[_r++];
			}
		}
		{ static float _itmp414[] = {2.739e-10,0.6188,5.033e02,2.064e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][8][i-1] = _itmp414[_r++];
			}
		}
		{ static float _itmp415[] = {3.200e-10,0.6198,6.329e02,2.616e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][9][i-1] = _itmp415[_r++];
			}
		}
		{ static float _itmp416[] = {3.873e-10,0.6295,7.000e02,2.989e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][10][i-1] = _itmp416[_r++];
			}
		}
		{ static float _itmp417[] = {4.284e-10,0.6287,8.748e02,3.586e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][11][i-1] = _itmp417[_r++];
			}
		}
		{ static float _itmp418[] = {4.881e-10,0.6326,9.941e02,4.085e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][12][i-1] = _itmp418[_r++];
			}
		}
		{ static float _itmp419[] = {5.373e-10,0.6337,1.164e03,4.677e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][13][i-1] = _itmp419[_r++];
			}
		}
		{ static float _itmp420[] = {5.876e-10,0.6354,1.341e03,5.292e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][14][i-1] = _itmp420[_r++];
			}
		}
		{ static float _itmp421[] = {6.571e-10,0.6400,1.452e03,5.796e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][15][i-1] = _itmp421[_r++];
			}
		}
		{ static float _itmp422[] = {7.076e-10,0.6397,1.653e03,6.555e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][16][i-1] = _itmp422[_r++];
			}
		}
		{ static float _itmp423[] = {7.538e-10,0.6388,1.889e03,7.306e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][17][i-1] = _itmp423[_r++];
			}
		}
		{ static float _itmp424[] = {8.182e-10,0.6411,2.044e03,8.057e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][18][i-1] = _itmp424[_r++];
			}
		}
		{ static float _itmp425[] = {8.577e-10,0.6403,2.334e03,8.850e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][19][i-1] = _itmp425[_r++];
			}
		}
		{ static float _itmp426[] = {9.162e-10,0.6413,2.543e03,9.690e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][20][i-1] = _itmp426[_r++];
			}
		}
		{ static float _itmp427[] = {9.844e-10,0.6440,2.708e03,1.044e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][21][i-1] = _itmp427[_r++];
			}
		}
		{ static float _itmp428[] = {1.020e-09,0.6427,3.057e03,1.140e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][22][i-1] = _itmp428[_r++];
			}
		}
		{ static float _itmp429[] = {1.091e-09,0.6445,3.225e03,1.229e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][23][i-1] = _itmp429[_r++];
			}
		}
		{ static float _itmp430[] = {1.151e-09,0.6451,3.461e03,1.334e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][24][i-1] = _itmp430[_r++];
			}
		}
		{ static float _itmp431[] = {1.198e-09,0.6443,3.789e03,1.437e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][25][i-1] = _itmp431[_r++];
			}
		}
		{ static float _itmp432[] = {1.211e-09,0.6406,4.357e03,1.572e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][26][i-1] = _itmp432[_r++];
			}
		}
		{ static float _itmp433[] = {1.288e-09,0.6440,4.506e03,1.651e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][27][i-1] = _itmp433[_r++];
			}
		}
		{ static float _itmp434[] = {1.372e-09,0.6472,4.627e03,1.740e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][28][i-1] = _itmp434[_r++];
			}
		}
		{ static float _itmp435[] = {1.412e-09,0.6454,5.053e03,1.891e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[2][29][i-1] = _itmp435[_r++];
			}
		}
		{ static float _itmp436[] = {5.641e-12,0.1749,3.077e02,2.617e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][10][i-1] = _itmp436[_r++];
			}
		}
		{ static float _itmp437[] = {1.920e-11,0.3028,4.849e02,5.890e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][11][i-1] = _itmp437[_r++];
			}
		}
		{ static float _itmp438[] = {3.753e-11,0.3585,6.848e02,9.035e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][12][i-1] = _itmp438[_r++];
			}
		}
		{ static float _itmp439[] = {5.942e-11,0.3930,8.962e02,1.213e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][13][i-1] = _itmp439[_r++];
			}
		}
		{ static float _itmp440[] = {1.721e-10,0.5429,2.848e02,3.975e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][14][i-1] = _itmp440[_r++];
			}
		}
		{ static float _itmp441[] = {3.502e-10,0.6266,1.532e02,1.755e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][15][i-1] = _itmp441[_r++];
			}
		}
}
void rrfitdata7(void)
{
		{ static float _itmp442[] = {2.502e-10,0.5580,5.303e02,4.558e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][16][i-1] = _itmp442[_r++];
			}
		}
		{ static float _itmp443[] = {2.862e-10,0.5621,7.002e02,4.885e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][17][i-1] = _itmp443[_r++];
			}
		}
		{ static float _itmp444[] = {2.757e-10,0.5364,1.204e03,7.013e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][18][i-1] = _itmp444[_r++];
			}
		}
		{ static float _itmp445[] = {5.273e-10,0.6281,5.329e02,3.188e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][19][i-1] = _itmp445[_r++];
			}
		}
		{ static float _itmp446[] = {3.890e-10,0.5645,1.391e03,6.295e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][20][i-1] = _itmp446[_r++];
			}
		}
		{ static float _itmp447[] = {4.207e-10,0.5646,1.688e03,6.872e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][21][i-1] = _itmp447[_r++];
			}
		}
		{ static float _itmp448[] = {4.605e-10,0.5659,1.949e03,7.419e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][22][i-1] = _itmp448[_r++];
			}
		}
		{ static float _itmp449[] = {4.975e-10,0.5655,2.257e03,8.072e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][23][i-1] = _itmp449[_r++];
			}
		}
		{ static float _itmp450[] = {5.349e-10,0.5658,2.577e03,8.710e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][24][i-1] = _itmp450[_r++];
			}
		}
		{ static float _itmp451[] = {7.688e-10,0.6173,1.653e03,6.161e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][25][i-1] = _itmp451[_r++];
			}
		}
		{ static float _itmp452[] = {5.850e-10,0.5598,3.538e03,1.052e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][26][i-1] = _itmp452[_r++];
			}
		}
		{ static float _itmp453[] = {6.347e-10,0.5631,3.780e03,1.116e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][27][i-1] = _itmp453[_r++];
			}
		}
		{ static float _itmp454[] = {6.619e-10,0.5602,4.322e03,1.210e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][28][i-1] = _itmp454[_r++];
			}
		}
		{ static float _itmp455[] = {7.002e-10,0.5612,4.726e03,1.287e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[10][29][i-1] = _itmp455[_r++];
			}
		}
		{ static float _itmp456[] = {2.020e-09,0.7798,6.690e-01,2.425e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[3][5][i-1] = _itmp456[_r++];
			}
		}
		{ static float _itmp457[] = {1.595e-11,0.3529,9.870e03,2.584e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[3][6][i-1] = _itmp457[_r++];
			}
		}
		{ static float _itmp458[] = {2.008e-11,0.3567,1.520e04,3.843e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[3][7][i-1] = _itmp458[_r++];
			}
		}
		{ static float _itmp459[] = {2.793e-11,0.3533,3.017e04,7.872e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[3][9][i-1] = _itmp459[_r++];
			}
		}
		{ static float _itmp460[] = {8.577e-10,0.7837,7.286e-01,1.140e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[4][5][i-1] = _itmp460[_r++];
			}
		}
		{ static float _itmp461[] = {7.039e-10,0.8607,2.203e00,3.029e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[4][6][i-1] = _itmp461[_r++];
			}
		}
		{ static float _itmp462[] = {1.542e-10,0.6712,1.775e02,1.535e08};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[4][7][i-1] = _itmp462[_r++];
			}
		}
		{ static float _itmp463[] = {2.515e-10,0.7011,3.028e02,8.903e06};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[4][9][i-1] = _itmp463[_r++];
			}
		}
		{ static float _itmp464[] = {7.651e-09,0.8027,1.193e-03,9.334e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[5][5][i-1] = _itmp464[_r++];
			}
		}
		{ static float _itmp465[] = {5.989e-10,0.7560,1.377e00,1.517e09};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[5][6][i-1] = _itmp465[_r++];
			}
		}
		{ static float _itmp466[] = {3.672e-09,0.7676,2.900e-01,8.521e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[5][7][i-1] = _itmp466[_r++];
			}
		}
		{ static float _itmp467[] = {9.353e-11,0.6270,9.031e02,2.387e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[5][9][i-1] = _itmp467[_r++];
			}
		}
		{ static float _itmp468[] = {1.243e-08,0.7022,1.136e-03,1.015e13};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[6][6][i-1] = _itmp468[_r++];
			}
		}
		{ static float _itmp469[] = {1.816e-08,0.7170,6.717e-03,3.286e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[6][7][i-1] = _itmp469[_r++];
			}
		}
		{ static float _itmp470[] = {4.227e-11,0.5395,1.687e03,1.491e17};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[6][9][i-1] = _itmp470[_r++];
			}
		}
		{ static float _itmp471[] = {1.341e-10,0.6159,1.673e00,6.366e16};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[7][7][i-1] = _itmp471[_r++];
			}
		}
		{ static float _itmp472[] = {9.563e-12,0.3067,9.768e03,4.851e17};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[7][9][i-1] = _itmp472[_r++];
			}
		}
		{ static float _itmp473[] = {5.417e-08,0.6930,1.179e-03,1.060e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[8][9][i-1] = _itmp473[_r++];
			}
		}
		{ static float _itmp474[] = {5.023e-12,0.2420,3.181e02,1.450e18};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[9][9][i-1] = _itmp474[_r++];
			}
		}
		{ static float _itmp475[] = {8.110e-10,0.5442,1.755e03,6.799e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[11][25][i-1] = _itmp475[_r++];
			}
		}
		{ static float _itmp476[] = {6.967e-10,0.5602,1.727e03,5.618e07};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[12][25][i-1] = _itmp476[_r++];
			}
		}
		{ static float _itmp477[] = {3.236e-08,0.3247,2.338e01,8.337e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[13][25][i-1] = _itmp477[_r++];
			}
		}
		{ static float _itmp478[] = {2.664e-08,0.3285,2.297e01,6.672e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[14][25][i-1] = _itmp478[_r++];
			}
		}
		{ static float _itmp479[] = {2.165e-08,0.3403,2.195e01,6.383e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[15][25][i-1] = _itmp479[_r++];
			}
		}
		{ static float _itmp480[] = {2.460e-08,0.3387,1.487e01,5.228e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[16][25][i-1] = _itmp480[_r++];
			}
		}
		{ static float _itmp481[] = {1.907e-08,0.3768,1.216e01,5.431e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[17][25][i-1] = _itmp481[_r++];
			}
		}
		{ static float _itmp482[] = {1.439e-08,0.4170,1.006e01,4.898e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[18][25][i-1] = _itmp482[_r++];
			}
		}
		{ static float _itmp483[] = {1.184e-08,0.4798,5.883e00,2.582e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[19][25][i-1] = _itmp483[_r++];
			}
		}
		{ static float _itmp484[] = {1.036e-08,0.5428,2.743e00,1.014e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[20][25][i-1] = _itmp484[_r++];
			}
		}
		{ static float _itmp485[] = {8.288e-09,0.6012,1.216e00,1.182e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[21][25][i-1] = _itmp485[_r++];
			}
		}
		{ static float _itmp486[] = {6.330e-09,0.6355,5.457e-01,8.545e11};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[22][25][i-1] = _itmp486[_r++];
			}
		}
		{ static float _itmp487[] = {5.422e-09,0.5067,4.998e-01,8.079e11};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[23][25][i-1] = _itmp487[_r++];
			}
		}
		{ static float _itmp488[] = {6.076e-09,0.3112,3.401e-01,1.960e12};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[24][25][i-1] = _itmp488[_r++];
			}
		}
		{ static float _itmp489[] = {8.945e-09,0.2156,4.184e-02,5.353e13};
		for( i=1, _r = 0; i <= 4; i++ )
		{
			ADfArnew.rnew[25][25][i-1] = _itmp489[_r++];
			}
		}
		{ static float _itmp490[] = {4.33e-10,3.91e-10,3.49e-10,3.16e-10,
		  2.96e-10,2.59e-10,2.24e-10,1.91e-10,1.68e-10,1.46e-10};
		for( i=4, _r = 0; i <= 13; i++ )
		{
			ADfAferr.fe[i-1][0] = _itmp490[_r++];
			}
		}
		{ static float _itmp491[] = {0.531,0.523,0.521,0.534,0.557,
		  0.567,0.579,0.601,0.602,0.597};
		for( i=4, _r = 0; i <= 13; i++ )
		{
			ADfAferr.fe[i-1][1] = _itmp491[_r++];
			}
		}
		{ static float _itmp492[] = {5.77e-02,6.15e-02,6.22e-02,6.02e-02,
		  5.79e-02,5.65e-02,5.49e-02,5.10e-02,5.07e-02,5.22e-02};
		for( i=4, _r = 0; i <= 13; i++ )
		{
			ADfAferr.fe[i-1][2] = _itmp492[_r++];
			}
		}

#	ifdef DEBUG_FUN
	fputs( "<+>blkdata0()\n", debug_fp );
#	endif

}

