/* runs pure collisional models at range of temperatures, prints cooling */
#include "c:\\projects\\cloudy\\current\\source\\cddefines.h"
#include "c:\\projects\\cloudy\\current\\source\\cddrive.h"

/*int main( int argc, char *argv[] )*/
int main( void )
{
	int lgBAD ;
	double telog , cooling, hden , tehigh , dTelog;

	FILE *ioRES , *ioOUT ;
	char chLine[100];

	/* this will be limit to the number of command chLines we can still put in */
	long int nleft;

	/* file to output short form of calculation's results */
	if( (ioRES = fopen("hazy_coolingcurve.txt","w")) == NULL )
	{
		printf(" could not open hazy_coolingcurve.txt for writing.\n");
		exit(1);
	}

	/* file to output short form of calculation's results */
	if( (ioOUT = fopen("hazy_coolingcurve.out","w")) == NULL )
	{
		printf(" could not open hazy_coolingcurve.out for writing.\n");
		exit(1);
	}

	/* the log of the hydrogen density */
	hden = 0.;

	/* these should be 2 - 9 */
	/* the log of the initial temperature */
	/* this calc is artificial in that it has no ionization at very
	 * low temperatures, except for collisions and the cosmic background */
	telog = 2.;
	/* this is log of highest temperature */
	tehigh = 9.;
	/* increment in log of T, normally 0.1 */
	dTelog = 0.1;

	/* loop over all densities */
	while( telog <= (tehigh+0.0001) )
	{
		/* initialize the code for this run */
		cdInit();

		/* we do not want to generate any output */
		cdOutp( ioOUT );
		cdTalk(TRUE);

		/* if this is turned on the calculation will not be done,
		 * but all parameters will be generated, as a quick way to see
		 * that grid is set up properly */
		/*cdNoExec( );*/

		/* inputs */
		/* cosmic background, microwave and hard parts */
		nleft = cdRead( "background 0 "  );

		/* cosmic ray background, this is included so that collisional
		 * ionization does not go to zero at very low temperatures */
		nleft = cdRead( "cosmic ray background "  );

		/* this is a pure collisional model to turn off photoionization */
		nleft = cdRead( "no photoionization "  );

		/* set a continuum shape, even though not used */
		nleft = cdRead( "table agn "  );
		nleft = cdRead( "phi(h) -4 "  );

		/* do only one zone */
		nleft = cdRead( "stop zone 1 "  );

		/* tell it the density */
		sprintf(chLine,"hden %f ",hden);
		nleft = cdRead( chLine  );

		/* the gas kinetic temperature */
		sprintf(chLine,"constant temper %f ",telog);
		nleft = cdRead( chLine  );

		/* actually call the code */
		lgBAD = cdDrive();

		/* get cooling for last zone */
		cooling = cdGetCooling_last();

		/* want to print cooling over density squared */
		cooling = cooling / pow(10.,hden*hden);

		fprintf(ioRES,"%.7e\t%.2e",	telog , cooling ); 

		fprintf(stderr,"%.7e\t%.2e", telog , cooling ); 
		if( lgBAD )
		{
			fprintf(ioRES,"\t problems!!\n");
			fprintf(stderr,"\t problems!!\n");
		}
		else
		{
			fprintf(ioRES,"\n");
			fprintf(stderr,"\n");
		}

		telog += dTelog;
	}

	puts( "[hazy_coolingcurve ends OK]" );
	exit(0);
}

