#!perl -w

# this script is called by autorun.pl after a clean execution of the test suite,
# it copies the contents of the "last" ftp dir to the "last_good" dir
# and also copies the cloudy.exe to cloudy_last_good.exe

# bring in the perl module that includes copy
use File::Copy;


# --------------------------------------------------------------------------
# this block - set up paths to all targets on various machines 

# this is where the original test suite files live on my pc
$original_tsuite_dir = "c:/projects/cloudy/current/tsuite/auto";
# move to pc unix source dir
if( !chdir( "$original_tsuite_dir" ) )
{
       printf(" could not move to test suite directory \n");
       exit(1);
}

# now copy cloudy.exe to cloudy_last_good.exe
copy( "cloudy.exe" , "cloudy_last_good.exe" );

# now copy all output files to lg files
while(defined($output= glob("*.out")) )
{ 
       # get basename
       $output =~ s/.out//gi;
       copy( "$output".".out" , "$output".".lg" );
}


# this is the ftp site on gradj
$ftp_last = "u:/pub/gjf/last/";
# $ftp = "u:/pub/gjf/";
$ftp_last_good = "u:/pub/gjf/last_good/";

# move to unix ftp dir
if( !chdir( "$ftp_last" ) )
{
       printf(" could not move to unix ftp directory \n");
       exit(1);
}

# this loops over all files in the last ftp directory
# and copies all files to last_good unix, 
while( defined( $input = glob("*") ) )
{
	$output = "$ftp_last_good"."/"."$input";
	# simply copy the source here
	copy( $input  , $output );
}

