#!/usr/bin/perl -w

#**********************************************************************#
#*  Perl script to check the current itr/zn of a model with its       *#
#*  previous itr/zn. If difference is above a threshold it sends a    *#
#*  mail stating so. It also creates a itrlogs/ directory and keeps   *#
#*  the log of the itr/zn and execution time of the models, every     *#
#*  time the models are executed.                                     *#
#*  								      *#
#*  Program written by Geetashree Chakravorty, Graduate Student       *#
#*  Computer Science Department, University of Kentucky		      *#
#*  in the year 2002 for Dr. Gary Ferland			      *#
#**********************************************************************#


# Path set to use Perl mail utility SENDMAIL
#$sendmailpath="/usr/sbin/sendmail";
#open(SENDMAIL, "|$sendmailpath -t");  
 
#$from="geetac\@pa.uky.edu";
#$to="geetac\@pa.uky.edu"; 
#$subject="Incease in execution time";

# Common directory
$curr_dir = "c://projects//cloudy//current//tsuite";

# Directory to store all the log files
$lgdir = '/itrlogs/';

if ( !chdir ($curr_dir))
{
   printf (" invalid directory\n");
   exit;
}

# If logs/ directory not present then create one
if ( !-e $lgdir)
{
  system "mkdir $lgdir";
}

# move to dir with all the current models
if ( !chdir ( "$curr_dir/auto" ) )
{
   printf (" invalid directory\n");
   exit;
}

$tlog = 'itrzn.log';
$efile = 'mailitr.log';
$exitr= 'extime_itrzn.log';
$thold = 5;

open (LGFILE, ">$tlog");
open (ELOG, ">$efile");
open (EXITR, ">$exitr");
print ELOG "List of models with increase in itr/zn\n\n";
print ELOG "Model \t %increase in itr/zn\n"; 
print EXITR "Model\tExectime\titr/zn\n";

print LGFILE "Records of itr/zn and Exectime of models if .bak file exists";
print LGFILE "\n************************************************************"; 

# Scans the .out files
while (defined ($ofile = glob ("*.out")))
{
   $bfile = $ofile;
   $bfile =~s/\.out/\.bak/;    # Substitutes '.out' by '.bak' in $bfile 

# Creates a '.log' file having same name as .out. Saves .log file in 
# directory /logs
   open (OUTFILE,"$ofile");
   $lfile = $ofile;
   $lfile =~s/\.out/\.log/;    
   $lfile =~s/$lfile/$curr_dir\/$lgdir\/$lfile/;

# Opening the .log files in append mode
   open (LOGFILE, ">>$lfile");

# get current time and date
  ($sec,$min,$hour,$mday,$mon,$year) = localtime(time);
   $mon = $mon+1; #Since month returned is 1 less than actual
   $year =~s/^\d//;
   print LOGFILE "Date: $mon/$mday/$year\tTime: $hour:$min:$sec";


# Checks and computes if .bak file exists
   if (-e $bfile)
   {
      open (BKFILE,"$bfile");
      $mo = $ofile;
      $mo =~s/\.out//;        # removes '.out'
      print LGFILE "\nModel             :  $mo\n";

# Gets itr/zn and execution time from .bak file. Extracts the 
# digits  only and ignores everything else 
      while ($bk = <BKFILE>)
      {
         if ($bk=~/itr\/zn\:/)
	 {
	    $prev_itr = $bk;
            $prev_itr =~s/(.*itr\/zn\:)(\s\d*\.\d*|\d*\.\d*)(\s*.*)/$2/gi;  # gives the itr/zn
            $prev_itr =~s/\n//;
            print LGFILE "Previous itr/zn   :  $prev_itr\t";
         }
         elsif ($bk=~/ExecTime/) 
         {
            $prev_etime = $bk;
            $prev_etime =~s/.*ExecTime//gi;  # gives the execution time
            print LGFILE "Previous Exectime : $prev_etime";
         }
      }

# Gets itr/an and execution time from .out file
      while ($new = <OUTFILE>)
      {                                                    
         if ($new=~/itr\/zn\:/)
	 {
       	    $curr_itr = $new;
            $curr_itr =~s/(.*itr\/zn\:)(\s\d*\.\d*|\d*\.\d*)(\s*.*)/$2/gi;  # gives the itr/zn
            $curr_itr =~s/\n//;
            print LGFILE "New itr/zn        :  $curr_itr\t";
	 }
         elsif ($new=~/ExecTime/)
         {
            $curr_etime = $new;
            $curr_etime =~s/.*ExecTime//gi;  # gives the execution time
            print LGFILE "New Exectime      : $curr_etime";
         }
      }

# Calculates difference between itr/zn 
      $diff_itr =   $curr_itr - $prev_itr;  
      printf(LGFILE "Difference in itr/zn: %.2f\n", $diff_itr);

# Checking if present itr/zn is greater than previous itr/zn
      if ($diff_itr !~/^-/) 
      {
        if ($prev_itr > 0)
        { 
          $ptage = ($diff_itr / $prev_itr) * 100;
          $ptage = sprintf "%.2f", $ptage;
          if ($ptage > $thold) 
          {
            print LGFILE "% increase of itr/zn which is beyond the set threshold of 5:  $ptage \n";
            print ELOG " $mo\t   $ptage\n"; 
          }
        }
      }
    }
# Prints the itr/zn and execution time to the .log file
    $curr_etime =~s/\n//;
    print LOGFILE "\t Exectime: $curr_etime\titr/zn: $curr_itr\n";
    print EXITR "$mo\t$curr_etime\t$curr_itr\n";
    close (LOGFILE);
 }

 close (EXITR);
 close (BKFILE);
 close (OUTFILE);
 close (LGFILE);
 close (ELOG);
 
# Checks if there is any model which took more time than the threshold.
# If yes than send a mail.
if (-e $efile){

# For Windows machines
   system("c:\\u\\blat\\blat.exe $efile -t gary\@pa.uky.edu -s \"Increase in exe time found in automatic testing\" " );

# For Unix machines
#   open (ELOG,"$efile");
#   print SENDMAIL "Subject: $subject\n";
#   print SENDMAIL "From: $from\n";
#   print SENDMAIL "To: $to\n\n";
#   while (<ELOG>){
#         print SENDMAIL "$_";
#      }
#   close(ELOG);

}
# End of program 
