/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* maximum number of stop line commands */
#define	MXSTPL	10

/* stopcalc.h */
EXTERN struct t_StopCalc {
	/* this has the various ending criteria for stopping a model */

	/* optical depth to stop calculation */
	float tauend, 
		/* this is the energy within the continuum mesh, we will stop when the
		 * optical depth at this energy reaches tauend */
	  taunu;

	/* this points to taunu within the continuum mesh */
	long int iptnu;

	/* highest allowed temperature, set with stop temperature exceeds command */
	float T2High;

	/* this is the default lowest to highest temperature checked
	 * TeLowest is 2.8, tehigh 1e10, in scalar, also zerologic */
	float TeLowest, 
	  TeHighest;

	/* this provides a "floor" for the temperature - when the temperature
	 * falls to this limit, go to constant temperature solution */
	float TeFloor;

	/* tend is lowest temperature, set with stop temperature command */
	float tend;

	/* stop efraction sets this limiting electron fraction rel to H */
	float StopElecFrac;

	/* stop at a hydrogen molecular fraction, relative to total hydrogen,
	 * this is 2H_2 / H_total*/
	float StopH2MoleFrac;

	/* limit column densities set with stop column command
	 * colend is total hydrogen column, others are ionized and neutral */
	float HColStop, 
	  colpls, 
	  colnut;

	/* stopping electron density, set with stop eden command */
	float StopElecDensity;

	/* MXSTPL (above, equal to 10) is maximum numeer of stop line commands 
	 *
	 * parameters for stop line command
	 * LineStopWl - line wavelength for stop line command
	 * ipStopLin1 is pointer to first line of pair in stack of lines 
	 * ipStopLin2 is pointer to second line of pair in stack of lines, usually Hbeta
	 *  initially holds wavelength, converted to pointer in startr
	 */
	float stpint[MXSTPL];

	long int ipStopLin1[MXSTPL], 
	  ipStopLin2[MXSTPL], 
	  nstpl;

	float StopLineWl[MXSTPL],
		StopLineWl2[MXSTPL];

	float ErrorLineWl[MXSTPL],
		ErrorLineWl2[MXSTPL];

	/* line labels */
	char chStopLabel[MXSTPL][5] ,
		chStopLabel2[MXSTPL][5];

	}	StopCalc;

