/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*setinp sets input lines to feed into cloudy in optimization runs */
#include "cddefines.h"
#include "input.h"
#include "varypar.h"
#include "setinp.h"

void setinp(int *lgLimOK)
{
	long int i, 
	  np;

#	ifdef DEBUG_FUN
	fputs( "<+>setinp()\n", debug_fp );
#	endif

	/* set up chCardSav(n) array like Gary's input file, using input
	 * variable parameters p(i), and format information held in
	 * the common block /parmv/. Results written to common /kardsv/.
	 */

	fprintf( ioQQQ, " **************************************************\n" );

	/* will be set false if limit to a variable exceeded
	 * this is returned to calling code as problem indication*/
	*lgLimOK = TRUE;

	/* echo the variable input lines for this run */
	for( i=0; i < VaryPar.nvary; i++ )
	{
		np = VaryPar.nvfpnt[i];
		/* write formatted to the character string chCardSav(np),
		 * using the format held in chVarFmt(np) */
		VaryPar.vpused[i] = (float)MIN2(VaryPar.vparm[0][i],VaryPar.varang[i][1]);
		VaryPar.vpused[i] = (float)MAX2(VaryPar.vpused[i],VaryPar.varang[i][0]);

		/* now generate the actual command with parameter,
		 * there will be from 1 to 3 numbers on the line */
		if( VaryPar.nvarxt[i] == 1 )
		{
			/* case with 1 parameter */
			sprintf( input.chCardSav[np] , VaryPar.chVarFmt[i], VaryPar.vparm[0][i] );
		}

		else if( VaryPar.nvarxt[i] == 2 )
		{
			/* case with 2 parameters */
			sprintf( input.chCardSav[np] , VaryPar.chVarFmt[i], VaryPar.vparm[0][i], VaryPar.vparm[1][i]);
		}

		else if( VaryPar.nvarxt[i] == 3 )
		{
			/* case with 3 parameters */
			sprintf( input.chCardSav[np] , VaryPar.chVarFmt[i], 
				VaryPar.vparm[0][i], VaryPar.vparm[1][i] , VaryPar.vparm[2][i] );
		}

		else if( VaryPar.nvarxt[i] == 4 )
		{
			/* case with 4 parameters */
			sprintf( input.chCardSav[np] , VaryPar.chVarFmt[i], 
				VaryPar.vparm[0][i], VaryPar.vparm[1][i] , VaryPar.vparm[2][i] , VaryPar.vparm[3][i]);
		}

		else if( VaryPar.nvarxt[i] == 5 )
		{
			/* case with 5 parameters */
			sprintf( input.chCardSav[np] , VaryPar.chVarFmt[i], 
				VaryPar.vparm[0][i], VaryPar.vparm[1][i] , VaryPar.vparm[2][i] , 
				VaryPar.vparm[3][i] , VaryPar.vparm[4][i]);
		}

		else
		{
			fprintf(ioQQQ,"The number of variable options on this line makes no sense to me5\n");
			puts( "[Stop in setinp]" );
			cdEXIT(EXIT_FAILURE);
		}

		fprintf( ioQQQ, " %s\n", input.chCardSav[np] );

		/*lint -e777 float test equal */
		if( VaryPar.vpused[i] == VaryPar.varang[i][1] || 
			 VaryPar.vpused[i] == VaryPar.varang[i][0] )
		/*lint +e777 float test equal */
		{
			*lgLimOK = FALSE;
			fprintf( ioQQQ, " Limit to variable exceeded.\n" );
		}
	}


#	ifdef DEBUG_FUN
	fputs( " <->setinp()\n", debug_fp );
#	endif
	return;
}

