/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*SetFPEnv set FP environment to crash on div by zero */
#include "cddefines.h"
#include "setfpenv.h" 

void SetFPEnv( void )
{
	/* >>chng 01 aug 07, added code to circumvent math library bug with gcc on
	 * alpha-linux machines, see bug report 51072 on http://bugzilla.redhat.com, PvH */
	/* >>chng 01 apr 17, added code for Solaris and SGI operating systems, PvH */
	/* this routine contains no code for alphas or crays, they do not need
	 * special code to enable FP exceptions since they are enabled by default */

	/* there is no command line option on MS Visual Studio to force crash */
#	if defined(_MSC_VER)
	unsigned int NewMask;

	/* | is a bitwise inclusive or, turns on bits
	 * 0|0 = 0
	 * 0|1 = 1|0 = 1|1 = 1 */
	NewMask = _EM_ZERODIVIDE | _EM_OVERFLOW | _EM_INVALID;
	/* ~ is the unary bitwise complement - all bits flip */ 
	NewMask = ~NewMask;
	/*lint -e534 ignore value returned by function (nothing to do with it)*/
	_controlfp( NewMask , _MCW_EM );
	/*lint +e534 ignore value returned by function (nothing to do with it)*/

	/* this is the code for Linux PC (but not Linux alpha) to force crash */
#	elif defined(__linux) && defined(__i386)
#	include <fpu_control.h>
	unsigned short int Old_Mask;
		
	/*  | is a bitwise inclusive or, turns on bits     */
	/* 0|0 = 0                                         */
	/* 0|1 = 1|0 = 1|1 = 1                             */

	/*   _FPU_MASK_IM  0x01 Invalid          */
	/*   _FPU_MASK_DM  0x02 Denormalized     */
	/*   _FPU_MASK_ZM  0x04 Division-by-zero */
	/*   _FPU_MASK_OM  0x08 Overflow         */
	/*   _FPU_MASK_UM  0x10 Underflow        */
	/*   _FPU_MASK_PM  0x20 Inexact          */

	/*  ~ is the unary bitwise complement - all bits flip */

	unsigned short int UnMask = ~( _FPU_MASK_ZM | _FPU_MASK_IM  | _FPU_MASK_OM );

	/* the following two macros are not defined on a Linux alpha ! */
	_FPU_GETCW(Old_Mask);
    
	_FPU_SETCW(Old_Mask & UnMask);

	/* this is for Solaris and SGI to force crash */
#	elif defined(__sun) || defined(__sgi)
#	include <ieeefp.h>

	fp_except mask;

#	if defined(HAVE_SUNMATH)
#	include <sunmath.h>

	/* >>chng 01 oct 09, disable gradual underflow on ultrasparc whith gcc
	 * (only needed for versions prior to 3.1, see Note 1).
	 *
	 * compile this module with:
	 *     gcc [ other options... ] -I<include-dir> -DHAVE_SUNMATH -c setfpenv.c
	 * link the program with:
	 *     gcc -L<library-dir> -o cloudy.exe *.o -lsunmath -lm
	 *
	 * you probably need to use -I<include-dir> and -L<library-dir> to point the
	 * compiler/linker to the location of the header file and library
	 * (e.g., -I/opt/SUNWspro/SC5.0/include/cc -L/opt/SUNWspro/lib ; note that
	 * the actual location may vary from one installation to another).
	 * See also bug report 4487 on http://gcc.gnu.org/cgi-bin/gnatsweb.pl
	 *
	 * Note 1: Starting with gcc 3.1, bug 4487 has been solved and using -ffast-math
	 * will automatically disable gradual underflow. Hence using nonstandard_arithmetic()
	 * is no longer necessary. The option -ffast-math should be included both when
	 * compiling and linking:
	 *
	 * gcc [ other options... ] -ffast-math -c *.c
	 * gcc -ffast-math -o cloudy.exe *.o -lm
	 *
	 * Note 2: Don't use nonstandard_arithmetic() with cc (the SunWorks/Forte compiler);
	 * use the -fast commandline option instead to disable gradual underflow.
	 * The option -fast should be included both when compiling and linking:
	 *
	 * cc [ other options... ] -fast -c *.c
	 * cc -fast -o cloudy.exe *.o -lm
	 *
	 * PvH */
	nonstandard_arithmetic();
#	endif

	/* enable floating point exceptions on sun and sgi */
	mask = fpgetmask();
	mask = mask | FP_X_INV | FP_X_OFL | FP_X_DZ;
	fpsetmask(mask);

#	elif defined(__alpha) && defined(__linux) && defined(__GNUC__)
#	define __USE_GNU
#	include <fenv.h>
	/* the following is not supported on all hardware platforms, but certainly for EV56
	 * and later. earlier versions may work as well, but that has not been tested.
	 * for details see https://bugzilla.redhat.com/bugzilla/show_bug.cgi?id=51072 */
#	ifdef FE_NONIEEE_ENV
	/* this prevents the infamous math library bug when compiling with gcc on alpha-linux
	 * machines. if this doesn't work on your system, the only alternative is to link
	 * against the Compaq math library: gcc *.o -lcpml -lm, or use ccc itself, PvH */
	fesetenv(FE_NONIEEE_ENV);
#	endif

#	endif
	return ;
}
