/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*PrtElem print chemical composition at start of calculation */
/*prt_LineLabels punch all labels and wavelengths for emission line array */
/*sprt_wl write wavelength to string - must be kept parallel with prt_wl */
/*prt_wl - print floating wavelength in Angstroms, in output format */
#include "cddefines.h"
#include "linesave.h"
#include "prt.h"

/*prt_wl print floating wavelength in Angstroms, in output format */
void prt_wl( FILE *io , float wl )
{
	char chUnits;

	/* print in A unless > 1e4, then use microns */
	if( wl > 1e8 )
	{
		/* centimeters */
		chUnits = 'c';
		wl /= 1e8;
	}
	else if( wl > 1e4 )
	{
		/* microns */
		chUnits = 'm';
		wl /= 1e4;
	}
	else if( wl == 0. )
	{
		chUnits = ' ';
	}
	else
	{
		/* Angstroms units */
		chUnits = 'A';
	}

	if( wl==0. )
	{
		fprintf(io, "%5i", 0 );
	}
	else if( wl<10. )
	{
		fprintf(io, "%5.3f", wl );
	}
	else if( wl<100. )
	{
		fprintf(io, "%5.2f", wl );
	}
	else if( wl < 1e3 )
	{
		fprintf(io, "%5.1f", wl );
	}
	else if( wl < 1e4 )
	{
		fprintf(io, "%5.0f", wl );
	}
	else if( wl < 1e5 )
	{
		fprintf(io, "%5i", (int)wl );
	}
	else
	{
		TotalInsanity();
	}
	fprintf(io, "%c", chUnits );
}

/* write wavelength to string - must be kept parallel with prt_wl */
void sprt_wl( char *chString , float wl )
{
	char chUnits;

	/* print in A unless > 1e4, then use microns */
	if( wl > 1e8 )
	{
		/* centimeters */
		chUnits = 'c';
		wl /= 1e8;
	}
	else if( wl > 1e4 )
	{
		/* microns */
		chUnits = 'm';
		wl /= 1e4;
	}
	else if( wl == 0. )
	{
		chUnits = ' ';
	}
	else
	{
		/* Angstroms units */
		chUnits = 'A';
	}

	if( wl==0. )
	{
		sprintf(chString, "%5i", 0 );
	}
	else if( wl<10. )
	{
		sprintf(chString, "%5.3f", wl );
	}
	else if( wl<100. )
	{
		sprintf(chString, "%5.2f", wl );
	}
	else if( wl < 1e3 )
	{
		sprintf(chString, "%5.1f", wl );
	}
	else if( wl < 1e4 )
	{
		sprintf(chString, "%5.0f", wl );
	}
	else if( wl < 1e5 )
	{
		sprintf(chString, "%5i", (int)wl );
	}
	else
	{
		TotalInsanity();
	}
	chString[4] = chUnits;
}

/*prt_LineLabels punch all labels and wavelengths for emission line array */
void prt_LineLabels(FILE * io)
{
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>prt_LineLabels()\n", debug_fp );
#	endif

	for( i=0; i < LineSave.nsum; i++ )
	{
		/* >>chng 02 jun 10, punch everything */
#		if 0
		/* do not print all these redundant labels */
		if( !strcmp( LineSv[i].chALab , "Inwd" ) ||
			!strcmp( LineSv[i].chALab , "Coll" ) ||
			!strcmp( LineSv[i].chALab , "Pump" ) ||
			!strcmp( LineSv[i].chALab , "Heat" ) )
			continue;
#		endif
		if( strcmp( LineSv[i].chALab , "####" )==0 )
		{
			/*fprintf( io, "%s ", LineSv[i].chALab );*/
			fprintf( io, "####\t%s",LineSave.chHoldComments[(int)LineSv[i].wavelength] ); 
		}
		else
		{
			/* this format chosen to be identical to that used by final */
			fprintf( io, "%li\t%s\t", 
				i,
				LineSv[i].chALab );
			prt_wl( io, LineSv[i].wavelength );
		}
		fprintf( io, "\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->prt_LineLabels()\n", debug_fp );
#	endif
	return;
}

