/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseTrace read in options off the trace command line */
#include "cddefines.h"
#include "itercnt.h"
#include "geometry.h"
#include "trace.h"
#include "parse.h"

void ParseTrace(char *chCard )
{
	int lgEOL;
	long int i;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseTrace()\n", debug_fp );
#	endif

	/* turn on trace at a certain zone; .LE.0 or none for starting trace
	 * optional second number is iteration to start debugger
	 * optional word "hydrogen" provides more info on hydrogen solution */

	i = 5;
	/* this is which zone to turn on */
	trace.nznbug = (long)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		trace.lgTrace = TRUE;
	}

	/* this is which iteration to turn on */
	trace.npsbug = (long)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		trace.npsbug = 1;
	}

	/* turn trace on now if no numbers on line */
	if( trace.nznbug == 0 && trace.npsbug <= 1 )
	{
		trace.lgTrace = TRUE;
		geometry.nprint = 1;
		IterCnt.IterPrnt[0] = 1;
	}

	/* >>chng 02 jun 14, change to set of if else rather than simply series of if 
	 * makes it possible to use keywords on converge without triggering other trace */

	/* trace convergence is a special command, 
	 * only convergence loops, not full trace */
	if( lgMatch("CONV",chCard) )
	{
		/* 
		 * nznbug was first number on line, which will be level of debugging,
		 * smaller numbers make less output, larger probe deeper levels of the code
		 * trace.lgTrConvg values and routine 
		 * 1 ConvPresTempEdenIoniz 
		 * 2 ConvTempEdenIoniz
		 * 3 ConvEdenIoniz
		 * 4 ConvIoniz
		 * 5 below ConvIonizeOpacityDo
		 * > 5 all levels
		 */

		/* if no number was entered then check for further keyword, if not present
		 * then set to very high level of debugging */
		if( trace.nznbug == 0 )
		{
			if( lgMatch("PRES",chCard) )
				trace.lgTrConvg = 1;
			else if( lgMatch("TEMP",chCard) )
				trace.lgTrConvg = 2;
			else if( lgMatch("EDEN",chCard) )
				trace.lgTrConvg = 3;
			else if( lgMatch("IONI",chCard) )
				trace.lgTrConvg = 4;
			else
				trace.lgTrConvg = 100;
		}
		else
		{
			/* number was entered so use it to indicate level of debugging */
			trace.lgTrConvg = trace.nznbug;
		}

		/* turn off normal trace parameters, this is a special case */
		trace.lgTrace = FALSE;
		trace.nznbug = 10000;
		geometry.nprint = 10000;
		IterCnt.IterPrnt[0] = 10000;
	}

	/* trace he-like and h-like must come early since they may have name of element */
	/* the trace h-like hydrogenic species command, with lots of options */
	else if( lgMatch("H-LI",chCard) )
	{
		/* turn on short trace for h-like species */
		trace.lgHBug = TRUE;

		/* option to turn on full printout */
		if( lgMatch("FULL",chCard) )
		{
			trace.lgIsoTraceFull[ipH_LIKE] = TRUE;
		}
		else
		{
			trace.lgIsoTraceFull[ipH_LIKE] = FALSE;
		}

		/* look for one of the element names on the line*/
		trace.ipIsoTrace[ipH_LIKE] = GetElem(chCard);

		/* if no element appears on the line fcn returns -1,
		 * in this case we want to do hydrogen */
		trace.ipIsoTrace[ipH_LIKE] = MAX2(0, trace.ipIsoTrace[ipH_LIKE] );
	}

	/* the trace h-like hydrogenic species command, with lots of options */
	else if( lgMatch("HE-L",chCard) )
	{
		/* turn on short trace for helium - like species */
		trace.lgHeBug = TRUE;

		/* option to turn on full printout */
		if( lgMatch("FULL",chCard) )
		{
			trace.lgIsoTraceFull[ipHE_LIKE] = TRUE;
		}
		else
		{
			trace.lgIsoTraceFull[ipHE_LIKE] = FALSE;
		}

		/* look for one of the element names on the line*/
		trace.ipIsoTrace[ipHE_LIKE] = GetElem(chCard);

		/* if no element appears on the line fcn returns -1,
		 * in this case we want to do helium */
		trace.ipIsoTrace[ipHE_LIKE] = MAX2(1, trace.ipIsoTrace[ipHE_LIKE] );
	}

	/* were there any keywords on the line? */
	else if( lgMatch("BETA",chCard) )
		trace.lgTr8446 = TRUE;

	else if( lgMatch("CARB",chCard) )
		trace.lgCarBug = TRUE;

	else if( lgMatch("CALC",chCard) )
		trace.lgCalBug = TRUE;

	else if( lgMatch("COMP",chCard) )
		trace.lgComBug = TRUE;

	else if( lgMatch("CONT",chCard) )
		trace.lgConBug = TRUE;

	else if( lgMatch("COOL",chCard) )
		trace.lgCoolTr = TRUE;

	else if( lgMatch("DIFF",chCard) )
		trace.lgTrDiff = TRUE;

	else if( lgMatch(" DR ",chCard) )
		trace.lgDrBug = TRUE;

	else if( lgMatch("EDEN",chCard) )
		trace.lgNeBug = TRUE;

	else if( lgMatch("GAUN",chCard) )
		trace.lgTrGant = TRUE;

	else if( lgMatch("GRAI",chCard) )
		trace.lgDustBug = TRUE;

	else if( lgMatch("HEAV",chCard) )
		trace.lgHeavyBug = TRUE;

	else if( lgMatch("HEAT",chCard) )
		trace.lgHeatBug = TRUE;

	/* trace helium */
	else if( lgMatch("HELI",chCard) )
	{
		trace.lgHeBug = TRUE;
		if( lgMatch("SING",chCard) )
			trace.lgHe1Bug = TRUE;

		if( lgMatch("ATOM",chCard) )
			trace.lgHe1Bug = TRUE;

		/* this will match either ionzed or ion */
		if( lgMatch(" ION",chCard) )
			trace.lgHe2Bug = TRUE;

		if( lgMatch("TRIP",chCard) )
			trace.lgHe3Bug = TRUE;
	}

	/* the simple trace hydrogen command */
	else if( lgMatch("HYDR",chCard))
	{
		trace.lgHBug = TRUE;
		trace.lgIsoTraceFull[ipH_LIKE] = FALSE;
		/* this says which element, on the C scale (H=0), to trace */
		trace.ipIsoTrace[ipH_LIKE] = 0;

	}

	else if( lgMatch("IRON",chCard) )
		trace.lgFeBug = TRUE;

	else if( lgMatch("VELN",chCard) )
		trace.lgTrLevN = TRUE;

	else if( lgMatch("LINE",chCard) )
		trace.lgTrLine = TRUE;

	else if( lgMatch("NEON",chCard) )
		trace.lgNeonBug = TRUE;

	else if( lgMatch("MOLE",chCard) )
		trace.lgTrMole = TRUE;

	/* trace pointers */
	else if( lgMatch("POIN",chCard) )
		trace.lgPointBug = TRUE;
	
	/* following two are optical, optimize */
	else if( lgMatch("PTIC",chCard) )
		trace.lgOptcBug = TRUE;
	
	else if( lgMatch("PTIM",chCard) )
		trace.lgTrOptm = TRUE;
	
	else if( lgMatch(" OTS",chCard) )
		trace.lgOTSBug = TRUE;
	
	else if( lgMatch("THRE",chCard) )
		trace.lgTrace3Bod = TRUE;

	/* two photon emission, spontaneous and induced */
	else if( lgMatch(" TWO",chCard) )
		trace.lgBug2nu = TRUE;

	/* falling through is fine - just turn on minimal trace */

#	ifdef DEBUG_FUN
	fputs( " <->ParseTrace()\n", debug_fp );
#	endif
	return;
}
