/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseSphere parse parameters on sphere command */
#include "cddefines.h"
#include "geometry.h"
#include "opacity.h"
#include "parse.h"

void ParseSphere(char *chCard )
{
	int lgEOL;
	long int i;
	double fac;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseSphere()\n", debug_fp );
#	endif

	/* compute a spherical model, diffuse field from other side included */
	geometry.lgSphere = TRUE;

	/* turn off electron scattering opacity */
	opac.lgScatON = FALSE;

	/* if "STATIC" is specified then set to case B for H lines */
	if( lgMatch("STAT",chCard) )
	{
		geometry.lgStatic = TRUE;
		opac.tlamin = 1e5;
		/* this is option to not check on iterations, used for debugging H atom */
		if( lgMatch("(OK)",chCard) )
		{
			geometry.lgStaticNoIt = TRUE;
		}
	}

	/* set the covering facto to full coverage */
	geometry.covgeo = 1.;
	geometry.covrt = 1.;

	/* check for optional covering factor, which is no longer parsed here */
	i = 5;
	fac = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

	if( !lgEOL )
	{
		/* >>chng 01 jul 16, remove covering factor, only on covering factor command */
		fprintf(ioQQQ," The number %g appeared on the SPHERE command.\n", fac);
		fprintf(ioQQQ," The covering factor can no longer be set with the SPHERE command.\n");
		fprintf(ioQQQ," The number has been ignored.\n");
	}

	/* if the "BEAM" or "SLIT" option is specified then only part 
	 * of the sphere is observed, and intensities
	 * should not be increased by r^2.  There are two limiting cases, SLIT in which
	 * the slit is longer than the diameter of the nebula and the contibution to the
	 * detected luminosity goes as r^1, and BEAM when the contribution is r^0, 
	 * or same as plane parallel */
	if( lgMatch("SLIT",chCard) || lgMatch("BEAM",chCard) )
	{
		/* >>chng 01 jul 16, remove options, put on APERTURE command */
		fprintf(ioQQQ," The SLIT and BEAM options are now part of the APERTURE command.\n");
		fprintf(ioQQQ," The syntax is the same.\n");
		fprintf(ioQQQ," This option has been ignored.\n");
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseSphere()\n", debug_fp );
#	endif
	return;
}
