/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseNorm parse parameters on the normalize command */
#include "cddefines.h"
#include "norm.h"
#include "input.h"
#include "parse.h"
#include "lines_service.h"

void ParseNorm(char *chCard)
{
	int lgEOL;
	long int i;
	char chLabel[INPUT_LINE_LENGTH];
	double a;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseNorm()\n", debug_fp );
#	endif

	/* these are flags saying that normalization line has been set, but not yet found */
	norm.lgNormFound = FALSE;
	norm.lgNormSet = TRUE;

	/* >>chng 01 aug 23, insist on a line label */
	/* 
	 * get possible label - must do first since it can contain a number.*/
	/* is there a double quote on the line?  if so then this is a line label */
	if( strchr( chCard , '\"' ) != NULL )
	{

		/* GetQuote does the following -
		 * first copy original version of name into chLabel, 
		 * string does include null termination.
		 * set label in OrgCard and second parameter to spaces so 
		 * that not picked up below as keyword */
		GetQuote( chLabel , chCard , TRUE );
		if( chLabel[4] !=0 )
		{
			fprintf( ioQQQ, " The label must be exactly 4 char long.\n" );
			fprintf( ioQQQ, "Sorry.\n" );
			puts( "[Stop in ParseNorm]" );
			cdEXIT(EXIT_FAILURE);
		}

		/* copy first four char of label into caps, and null terminate*/
		cap4( norm.chNormLab, chLabel);
	}
	else
	{
		fprintf( ioQQQ, "A 4 char long line label must also be specified, between double quotes, like \"H  1\" 4861.\n" );
		fprintf( ioQQQ, "Sorry.\n" );
		puts( "[Stop in ParseNorm]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* normalise lines to this rather than h-b, sec number is scale factor */
	i = 5;
	norm.WavLNorm = (float)FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		NoNumb(chCard);
	}
	else if( norm.WavLNorm < 0 )
	{
		fprintf( ioQQQ, "A negative wavelength does not make sense to me.\n" );
		fprintf( ioQQQ, "Sorry.\n" );
		puts( "[Stop in ParseNorm]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* now find out what the units of the wavelength were - options are
	 * microns, cm, default is Angstroms */
	if( input.chCARDCAPS[i-1] == 'M' )
	{
		/* microns */
		norm.WavLNorm *= 1e4;
	}
	else if( input.chCARDCAPS[i-1] == 'C' )
	{
		/* centimeters */
		norm.WavLNorm *= 1e8;
	}

	/* get the error assocated with the 4 significant figures that are visible,
	 * wavelength of 0 (a continuum) has error of zero */
	GetWLError( norm.WavLNorm, &norm.errorwave, &a );

	norm.ScaleNormLine = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);

	if( lgEOL )
		norm.ScaleNormLine = 1.;

	/* confirm that scale factor is positive */
	if( norm.ScaleNormLine <= 0. )
	{
		fprintf( ioQQQ, " The scale factor for relative intensities must be greater than zero.\n" );
		fprintf( ioQQQ, "Sorry.\n" );
		puts( "[Stop in ParseNorm]" );
		cdEXIT(EXIT_FAILURE);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseNorm()\n", debug_fp );
#	endif
	return;
}
