/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*ParseBackgrd parse options for the BACKGROUND command - this actually enters two continua*/
#include "cddefines.h"
#include "physconst.h"
#include "radius.h"
#include "rfield.h"
#include "parse.h"

void ParseBackgrd(long int *nqh, 
  char *chCard,
  float *ar1)
{
	int lgEOL;
	long int i;
	double a, 
	  fac, 
	  rlogl, 
	  z;

#	ifdef DEBUG_FUN
	fputs( "<+>ParseBackgrd()\n", debug_fp );
#	endif

	/* check that stack of shape and luminosity specifications
	 * is parallel, stop if not - this happens is background comes
	 * BETWEEN another set of shape and luminosity commands */
	if( rfield.nspec != *nqh )
	{
		fprintf( ioQQQ, " This command has come between a previous ordered pair of continuum shape and luminosity commands.\n Reorder the commands to complete each continuum specification before starting another.\n" );
		fprintf( ioQQQ, " Sorry.\n" );
		puts( "[Stop in ParseBackgrd]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* diffuse x-ray background from 
	 * >>refer	cosmic	background	Ostriker and Ikeuchi ApJL 268, L63.
	 * parameter on cmnd is redshift, followed by optional J21 
	 * >>refer	cosmic	background	Ikeuchi, S.; Ostriker, J. P., 1986, ApJ 301, 522 */

	/* >>chng 02 aug 12, do not try to enter bare powerlaw, use table power law default instead */
	ParseTable( nqh, "TABLE POWERLAW  ", ar1);
#	if 0
	strcpy( rfield.chSpType[rfield.nspec], "POWER" );
	rfield.slope[rfield.nspec] = -1.f;
	rfield.cutoff[0][rfield.nspec] = 1e10;
	rfield.cutoff[1][rfield.nspec] = 0.;
#	endif

	/* now generate equivalent of luminosity command
	 * enter phi(h), the number of h-ionizing photons/cm2 */

	strcpy( rfield.chRSpec[*nqh], "SQCM" );
	strcpy( rfield.chSpNorm[*nqh], "FLUX" );
	i = 5;

	/* this will be the redshift */
	z = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		z = 0.;
	}

	/* optional scale factor */
	fac = FFmtRead(chCard,&i,INPUT_LINE_LENGTH,&lgEOL);
	if( lgEOL )
	{
		fac = 1.0;
	}

	/* this equation from Ostriker and Ikeuchi Ap.J.L 268, L63.
	 * this should be J_nu into 4\pi sr
	 * >>chng 96 jul 23, from ostriker to vedel, et al mnras 271, 743. */
	rfield.totpow[*nqh] = (log10(PI4*fac*1.e-21/
		(1.+powi(5./(1.+z),4))));

	/* this is at 1 ryd for H
	 * range(nqh,1) = 1.
	 *>>chgn 96 dec 18, to H ioniz pot from 1 ryd */
	rfield.range[0][*nqh] = HIONPOT;

	/* >>chng 02 aug 12, call table power law routine rather than try to enter spec here,
	 * so no longer increment nspec */
	/* increment continuum indices
	++rfield.nspec;
	if( rfield.nspec >= LIMSPC )
	{
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseBackgrd]" );
		cdEXIT(EXIT_FAILURE);
	} */
	++*nqh;
	if( *nqh >= LIMSPC )
	{
		fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
		puts( "[Stop in ParseBackgrd]" );
		cdEXIT(EXIT_FAILURE);
	}

	/* add fireball unless NO FIREBALL in */
	if( !lgMatch("O FI",chCard) )
	{

		/* put in a black body */
		strcpy( rfield.chSpType[rfield.nspec], "BLACK" );
		rfield.slope[rfield.nspec] = (2.756*(1. + z));
		rfield.cutoff[0][rfield.nspec] = 0.;
		rfield.cutoff[1][rfield.nspec] = 0.;
		strcpy( rfield.chSpNorm[*nqh], "LUMI" );
		a = log10(rfield.slope[rfield.nspec]);
		rlogl = log10(2.99792e10*7.56464e-15) + 4.*a;
		strcpy( rfield.chRSpec[*nqh], "SQCM" );
		rfield.range[0][*nqh] = rfield.emm;
		rfield.range[1][*nqh] = rfield.egamry;
		rfield.totpow[*nqh] = rlogl;

		++rfield.nspec;
		++*nqh;
		if( *nqh >= LIMSPC )
		{
			fprintf( ioQQQ, " Too many continua entered; increase LIMSPC\n" );
			puts( "[Stop in ParseBackgrd]" );
			cdEXIT(EXIT_FAILURE);
		}
	}

	/* set radius to very large value if not already set */
	/* >>chng 01 jul 24, from Radius == 0 to this, as per PvH comments */
	if( !radius.lgRadiusKnown )
	{
		*ar1 = (float)radius.rdfalt;
		radius.Radius = pow(10.f,*ar1);
	}

#	ifdef DEBUG_FUN
	fputs( " <->ParseBackgrd()\n", debug_fp );
#	endif
	return;
}

