/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*mean derive mean ionization fractions over computed EXTERN structure */
void MeanInc(void);

/*MeanZero zero mean of ionization fractions array */
void MeanZero(void);

/*RadMean derive mean ionization fractions over ravius for some element */
void RadMean(
	/* either 'i' or 't' for ionization or temperature */
	char chType,
	/* atomic number on physical, no c, scale */
	long int nelem, 
	/* this will say how many of arlog have non-zero values */
	long int *n, 
	/* array of values, log both cases */
	float arlog[],
	/* TRUE, include electron density, FALSE do not*/
	int lgDensity );

/*VolMean do volume mean of ionization fractions over volumn of any element */
void VolMean(
	/* either 'i' or 't' for ionization or temperature */
	char chType,
	/* atomic number on physical, no c, scale */
	long int nelem, 
	/* this will say how many of arlog have non-zero values */
	long int *n, 
	/* array of values, log both cases */
	float arlog[],
	/* TRUE, include electron density, FALSE do not*/
	int lgDensity );

/* ionmeans.h */
EXTERN struct t_IonMeans {

	/* used to store information for mean ionization and electron temperature,
	 * this is set to zero in zmean, incremented in mean, and analysed in 
	 * RadMean and VolMean */

	/* this is used to get the harmonic mean temperature with respect to
	 * atomic hydrogen density, over radius, for comparison with 21cm data */
	double HarMeanTempRadius[2];
	/* this is used to get the harmonic mean temperature with respect to
	 * atomic hydrogen density, weighted over volume */
	double HarMeanTempVolume[2];

	/* this is used to get the mean temperature with respect to
	 * H2, over radius */
	double H2MeanTempRadius[2];
	/* this is used to get the mean temperature with respect to
	 * H2, weighted over volume */
	double H2MeanTempVolume[2];

	/* xIonMeans[type][nelem][stage]
	 * stage=0 is integrated sum of all
	 * type = 0 is radius integration, 1=vol integration */
	double xIonMeans[2][LIMELM][LIMELM+2];
	/* following includes electron density */
	double xIonEdenMeans[2][LIMELM][LIMELM+2];

	/* TempMeans[type][nelem][stage]
	 * stage=0 is not used, here for analogy with above
	 * type = 0 is radius integration, 1=vol integration,
	 * 2 is norm for radius, 3 is norm for vol integration */
	double TempMeans[4][LIMELM][LIMELM+2];
	/* following includes electron density */
	double TempEdenMeans[4][LIMELM][LIMELM+2];

	}	IonMeans;

