/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* linesave.h */
#define NHOLDCOMMENTS 10

/* this struc is different from following since they are only pointer here, will be malloced 
 * to form a large array after number of lines is counted, but this is the final form */
EXTERN struct t_LineSave {
	/* number of emission lines in main stack */

	/* nsum is current index, to last line entered in the array */
	/* linadd increments nsum before doing anything else */
	long int nsum;

	/* total number of dust lines */
	long int ndsum;

	/* index to number of comments printed within the block of lines */
	long int nComment;

	long int npxdd;

	/* variable to tell lines whether this is the first initialaization
	 * pass or whether we are in the middle of a model
	 * ipass=0 on initialization call, =1 on all others */
	long int ipass;

	/* holds comment strings associated with various blocks of output lines */
	char chHoldComments[NHOLDCOMMENTS][INPUT_LINE_LENGTH];

	}	LineSave;

/* this struc is different from above since only pointer here, will be malloced 
 * to form a large array after number of lines is counted */
/* these are the main line save arrays */
typedef struct tag_LineSv {

	/* one char saying whether heat 'h', cooling 'c', information, 'i' */
	char chSumTyp;

	/* the four char string label for the line */
	char chALab[5];

	/* xLineEnergy is energy of line in Rydbergs,
	 * also serves as sentinel saying this line should be added as a contributor
	 * to total spectrum when plotting continuum.  For each real line there are many
	 * components added into the line stack, only the first, the real total intensity,
	 * has this non-zero */
	float xLineEnergy;

	/* integrated intensity of the line */
	double sumlin;

	/* the emissivity, per unit vol, for current conditions */
	double emslin;

	/* the wavelength of the line */
	/* >>chng 01 aug 14, change to a float from a long int */
	float wavelength;

} LinSv;

extern LinSv *LineSv;

typedef struct tag_LinDstSv {

	/* these are the smaller arrays for dust lines */
	char chSMDLab[5];
	float wavelength;
	float smdlin;

/*} LineDSv[NDLINES];*/
} LinDstSv;

extern LinDstSv *LineDSv;
