/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*lines_lv1_k_zn place lines of elements potatium and heavier into lines storage stack */
#include "cddefines.h"
#include "cddrive.h"
#include "coolheavy.h"
#include "dcala.h"
#include "caline.h"
#include "pumpfe.h"
#include "resion.h"
#include "fekems.h"
#include "rfield.h"
#include "dense.h"
#include "phycon.h"
#include "radius.h"
#include "linesave.h"
#include "taulines.h"
#include "fe4cool.h"
#include "fe2cool.h"
#include "trace.h"
#include "lines_service.h"
#include "rtescprob.h"
#include "atomfeii.h"
#include "lines.h"

void lines_lv1_k_zn(void)
{
	long int i, 
	  ipnt;

	double c10, 
	  c14, 
	  eff, 
	  fela, 
	  r14;

#	ifdef DEBUG_FUN
	fputs( "<+>lines_lv1_k_zn()\n", debug_fp );
#	endif

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_lv1_k_zn called\n" );
	}

	/* potassium
	 * K I 7745 */
	PutLine(&TauLines[ipKI7745]);

	/* [K III] 4.62 microns */
	PutLine(&TauLines[ipxK03462]);

	/* [KIV] 5.983 min  */
	PutLine(&TauLines[ipxK04598]);

	/* [KIV] 15.39 mic */
	PutLine(&TauLines[ipxK04154]);

	/* [KVI] 8.823 mic */
	PutLine(&TauLines[ipxK06882]);

	/* [KVI]  5.575 mic */
	PutLine(&TauLines[ipxK06557]);

	/* [K VII] 3.189 microns */
	PutLine(&TauLines[ipxK07319]);

	/* K 11 4249.99A */
	PutLine(&TauLines[ipxK11425]);

	/* calcium
	 * Ca I 4228 */
	PutLine(&TauLines[ipCaI4228]);

	/* coll excit calcium k+h */
	linadd(CoolHeavy.Cakh,3933,"Ca 2",'c' );

	/* infrared triplet */
	linadd(CoolHeavy.Cair,8579,"Ca 2",'c' );

	/* forbidden lines, 7291+7324 together */
	linadd(CoolHeavy.c7306,7306,"Ca 2",'c' );

	/* fraction H Ly-alpha destruction of excited levels */
	linadd(dcala.dCakh,3933,"Phot",'i' );

	/* fraction H Ly-alpha destruction of excited levels */
	linadd(dcala.dCaf12,7306,"Phot",'i' );

	/* individual lines from five level atom */
	PntForLine(3934.,"Ca2K",&ipnt);
	lindst(caline.Cak,3934,"Ca2K",ipnt,'i',TRUE );
	
	/* individual lines from five level atom */
	PntForLine(3969.,"Ca2H",&ipnt);
	lindst(caline.Cah,3969,"Ca2H",ipnt,'i',TRUE );
	
	/* individual lines from five level atom */
	PntForLine(8498.,"Ca2X",&ipnt);
	lindst(caline.Cax,8498,"Ca2X",ipnt,'i',TRUE );
	
	/* individual lines from five level atom */
	PntForLine(8542.,"Ca2Y",&ipnt);
	lindst(caline.Cay,8542,"Ca2Y",ipnt,'i',TRUE );
	
	/* individual lines from five level atom */
	PntForLine(8662.,"Ca2Z",&ipnt);
	lindst(caline.Caz,8662,"Ca2Z",ipnt,'i',TRUE );
	
	/* individual lines from five level atom */
	PntForLine(7291.,"CaF1",&ipnt);
	lindst(caline.Caf1,7291,"CaF1",ipnt,'i',TRUE );
	
	/* individual lines from five level atom */
	PntForLine(7324.,"CaF2",&ipnt);
	lindst(caline.Caf2,7324,"CaF2",ipnt,'i',TRUE );
	
	/* reccombination contribution to CaII emission */
	eff = dense.eden*dense.xIonDense[ipCALCIUM][2]*5.4e-21/(phycon.te/
	  phycon.te10/phycon.te10);
	linadd(eff,3933,"Rec ",'i' );

	/* Ca IV 3.2 micron */
	PutLine(&TauLines[ipTCa3]);

	/* Ca V 4.16, 11.47 micron */
	PutLine(&TauLines[ipTCa4]);

	/* Ca V 4.16, 11.47 micron */
	PutLine(&TauLines[ipTCa12]);

	/* Ca V optical and uv lines, collisional excitation, 3-level atom */
	PntForLine(6087.,"Ca 5",&ipnt);
	lindst(CoolHeavy.Ca6087,6087,"Ca 5",ipnt,'c',TRUE );
	
	/* Ca V optical and uv lines, collisional excitation, 3-level atom */
	PntForLine(5311.,"Ca 5",&ipnt);
	lindst(CoolHeavy.c5311,5311,"Ca 5",ipnt,'c',TRUE );

	/* Ca V optical and uv lines, collisional excitation, 3-level atom */
	PntForLine(2414.,"Ca 5",&ipnt);
	lindst(CoolHeavy.c2414,2414,"Ca 5",ipnt,'c',TRUE );
	
	/* Ca V optical and uv lines, collisional excitation, 3-level atom */
	PntForLine(3997.,"Ca 5",&ipnt);
	lindst(CoolHeavy.c3997,3997,"Ca 5",ipnt,'c',TRUE );
	
	/* [Ca VII] 4.09 microns */
	PutLine(&TauLines[ipCa0741]);

	/* [Ca VII] 6.15 microns */
	PutLine(&TauLines[ipCa0761]);

	/* Ca VII optical and uv lines, collisional excitation, 3-level atom */
	PntForLine(5620.,"Ca 7",&ipnt);
	lindst(CoolHeavy.Ca5620,5620,"Ca 7",ipnt,'c',TRUE );
	
	/* Ca VII optical and uv lines, collisional excitation, 3-level atom */
	PntForLine(4941.,"Ca 7",&ipnt);
	lindst(CoolHeavy.Ca4941,4941,"Ca 7",ipnt,'c',TRUE );
	
	/* Ca VII optical and uv lines, collisional excitation, 3-level atom */
	PntForLine(2112.,"Ca 7",&ipnt);
	lindst(CoolHeavy.Ca2112,2112,"Ca 7",ipnt,'c',TRUE );
	
	/* Ca VII optical and uv lines, collisional excitation, 3-level atom */
	PntForLine(3688.,"Ca 7",&ipnt);
	lindst(CoolHeavy.Ca3688,3688,"Ca 7",ipnt,'c',TRUE );
	
	/* [Ca VIII]  2.32 microns, A Saraph and Strey */
	PutLine(&TauLines[ipCa08232]);

	/* [Ca 12] 3328.78A */
	PutLine(&TauLines[ipCa12333]);

	/* Ca 18 Li seq 2s2p, 302, 345 separate */
	PutLine(&TauLines[ipTCa302]);

	/* Ca 18 Li seq 2s2p, 302, 345 separate */
	PutLine(&TauLines[ipTCa345]);

	/* Ca 18 Li seq 2s3p,  */
	PutLine(&TauLines[ipTCa19]);

	/* Sc II 2.08 (1-3) */
	PntForLine(22.08e4,"Sc 2",&ipnt);
	lindst(CoolHeavy.Sc22p08m,21,"Sc 2",ipnt,'c',TRUE );
	
	/* Sc II 4.1 mic (1-2) */
	PntForLine(24.1e4,"Sc 2",&ipnt);
	lindst(CoolHeavy.Sc24p1m,41,"Sc 2",ipnt,'c',TRUE );
	
	/* Sc II 4.22 (2-3) */
	PntForLine(24.2e4,"Sc 2",&ipnt);
	lindst(CoolHeavy.Sc24p2m,42,"Sc 2",ipnt,'c',TRUE );
	
	/* Sc III 3936 */
	PntForLine(3933.,"Sc 3",&ipnt);
	lindst(CoolHeavy.Sc33936,3933,"Sc 3",ipnt,'c',TRUE );
	
	/* [Sc V] 1.46 microns */
	PutLine(&TauLines[ipSc05231]);

	/* Sc VI 5054 (1-2) */
	PntForLine(5054.,"Sc 6",&ipnt);
	lindst(CoolHeavy.Sc45058,5054,"Sc 6",ipnt,'c',TRUE );
	
	/* Sc VI 3595 (2-3) */
	PntForLine(3592.,"Sc 6",&ipnt);
	lindst(CoolHeavy.Sc43595,3592,"Sc 6",ipnt,'c',TRUE );
	
	/* Sc VI 2100 (1-3) */
	PntForLine(2100.,"Sc 6",&ipnt);
	lindst(CoolHeavy.Sc42100,2100,"Sc 6",ipnt,'c',TRUE );
	
	/* [Sc 13] 2637.97A */
	PutLine(&TauLines[ipSc13264]);

	/* Ti III 1.21 micron, (actually multiplet) 2-1 transition from model atom */
	PntForLine(1.21e4,"Ti 3",&ipnt);
	lindst(CoolHeavy.Ti3l21,12,"Ti 3",ipnt,'c',TRUE );
	
	/* Ti III 9594, 3-1 transition, (actually multiplet) from model atom */
	PntForLine(9594.,"Ti 3",&ipnt);
	lindst(CoolHeavy.Ti3l31,9594,"Ti 3",ipnt,'c',TRUE );
	
	/* Ti III 4.57 micron, 3-2 transition, (actually multiplet) from model atom */
	PntForLine(4.57e4,"Ti 3",&ipnt);
	lindst(CoolHeavy.Ti3l32,45,"Ti 3",ipnt,'c',TRUE );
	
	/* [Ti VI] 1.72 microns */
	PutLine(&TauLines[ipTi06172]);

	/* [Ti XIV] 2117.79 */
	PutLine(&TauLines[ipTi14212]);

	/* V III 8823 */
	PntForLine(8823.,"V  3",&ipnt);
	lindst(CoolHeavy.V38830,8823,"V  3",ipnt,'c',TRUE );
	
	/* V III 8507 */
	PntForLine(8507.,"V  3",&ipnt);
	lindst(CoolHeavy.V38507,8507,"V  3",ipnt,'c',TRUE );
	linadd(CoolHeavy.V38507,8507,"V  3",'c' );

	/* V IV 7741 1-3 */
	PntForLine(7735.,"V  4",&ipnt);
	lindst(CoolHeavy.V47741,7735,"V  4",ipnt,'c',TRUE );
	
	/* V IV 9496 2-1 */
	PntForLine(9489.,"V  4",&ipnt);
	lindst(CoolHeavy.V49496,9489,"V  4",ipnt,'c',TRUE );
	
	/* V IV 4.19 mic 3-2 */
	PntForLine(4.19e4,"V  4",&ipnt);
	lindst(CoolHeavy.V44p2m,42,"V  4",ipnt,'c',TRUE );
	
	/* [V VII] 1.304 microns */
	PutLine(&TauLines[ipVa07130]);

	/* [V 15] 1721.38 */
	PutLine(&TauLines[ipVa15172]);

	/* [CrIII] multiplet blend at 5828A */
	PntForLine(5828.,"Cr 3",&ipnt);
	lindst(CoolHeavy.Cr3l21,5828,"Cr 3",ipnt,'c',TRUE );
	
	/* [CrIV] 2 - 1 multiplet blend at 7272 */
	PntForLine(7267.,"Cr 4",&ipnt);
	lindst(CoolHeavy.Cr4l21,7267,"Cr 4",ipnt,'c',TRUE );
	
	/* [CrIV] 3 - 1 multiplet blend at 6806 */
	PntForLine(6801.,"Cr 4",&ipnt);
	lindst(CoolHeavy.Cr4l31,6801,"Cr 4",ipnt,'c',TRUE );
	
	/* [CrV] 2 - 1 multiplet blend at 7985 */
	PntForLine(7979.,"Cr 5",&ipnt);
	lindst(CoolHeavy.Cr5l21,7979,"Cr 5",ipnt,'c',TRUE );
	
	/* [CrV] 3 - 1 multiplet blend at 6582 */
	PntForLine(6577.,"Cr 5",&ipnt);
	lindst(CoolHeavy.Cr5l31,6577,"Cr 5",ipnt,'c',TRUE );
	
	/* [CrV] 3 - 2 multiplet blend at 3.75 microns */
	PntForLine(3.75e4,"Cr 5",&ipnt);
	lindst(CoolHeavy.Cr5l32,37,"Cr 5",ipnt,'c',TRUE );
	
	/* [Cr VIII] 1.01 microns */
	PutLine(&TauLines[ipCr08101]);

	/* [Cr 16] 1410.60 */
	PutLine(&TauLines[ipCr16141]);

	/* [Mn IX] 7968.5 A */
	PutLine(&TauLines[ipxMn0979]);

	/* [Mn 17] 1169.59 */
	PutLine(&TauLines[ipxMn1712]);

	/* bob rubin's uv line
	 * f2 = dense.xIonDense(26,4)*sexp(50 764./te)*0.45*cdsqte/6.*7.01e-12
	 * call linadd( f2 , 2837 , 'BobR' , 'i')
	 * f2 = dense.xIonDense(26,4)*sexp(55 989./te)*0.384*cdsqte/6.*7.74e-12
	 * call linadd( f2 , 2568 , 'BobR' , 'i') */

	/* iron
	 * Fe 1 3884 */
	PutLine(&TauLines[ipFeI3884]);

	/* Fe 1 3729 */
	PutLine(&TauLines[ipFeI3729]);

	/* Fe 1 3457 */
	PutLine(&TauLines[ipFeI3457]);

	/* Fe 1 3021 */
	PutLine(&TauLines[ipFeI3021]);

	/* Fe 1 2966 */
	PutLine(&TauLines[ipFeI2966]);

	/* Fe 2 the 3-2 transition of Netzer's atom */
	linadd(CoolHeavy.rmt48,6200,"Fe 2",'i' );

	/* Fe 2 forbidden 2-1 transition from Netzer's atom */
	linadd(CoolHeavy.for7,4300,"Fe 2",'i' );

	/* Fe 2 UV3, 3-1 transition from Netzer's atom */
	linadd(resion.emuv3,2400,"Fe 2",'i' );

	/* total of all UV+optical Fe 2 cooling */
	linadd(MAX2(0.,CoolHeavy.Fecool),0,"Fe2c",'c' );
	linadd(MAX2(0.,-CoolHeavy.Fecool),0,"Fe2h",'h' );

	/* 1 to 6 transition of Fred's Fe 2 atom */
	linadd(CoolHeavy.cFe16,1100,"Fe 2",'i' );

	/* 2 to 6 transition of Fred's Fe 2 atom */
	linadd(CoolHeavy.cFe26,1500,"Fe 2",'i' );

	/* 3 to 4 transition of Fred's Fe 2 atom */
	linadd(CoolHeavy.cFe34,11500,"Fe 2",'i' );

	/* 3 to 5 transition of Fred's Fe 2 atom */
	linadd(CoolHeavy.cFe35,2500,"Fe 2",'i' );

	/* 4 to 6 transition of Fred's Fe 2 atom */
	linadd(CoolHeavy.cFe46,2300,"Fe 2",'i' );

	/* 5 to 6 transition of Fred's Fe 2 atom */
	linadd(CoolHeavy.cFe56,8900,"Fe 2",'i' );

	/* results of either 16 level (Fe2Lev16) or large (pop371) Fe 2 atom, 
	 * not all are printed, first is 
	 * all cooling due to 16 level atom */
	linadd(fe2cool.Fe2L16Tot,0,"Fe 2",'c' );

	/* Fe 2 1.664 microns 8-13 */
	PntForLine(16640.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21308,166,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.599 microns 7-12 */
	PntForLine(15990.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21207,160,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.534 microns 6-11 */
	PntForLine(15340.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21106,153,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.644 microns 6-10 */
	PntForLine(16440.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21006,164,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.279 microns 12-4 */
	PntForLine(12790.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21204,128,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.295 microns 11-3 */
	PntForLine(12950.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21103,130,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.328 microns 11-4 */
	PntForLine(13280.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21104,133,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.257 microns 10-1 */
	PntForLine(12570.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21001,126,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.321 microns 10-2 */
	PntForLine(13210.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21002,132,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 25.988 microns 2-1 */
	PntForLine(259880.,"Fe 2",&ipnt);
	lindst(fe2cool.fe20201,259,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 35.348 microns 3-2 */
	PntForLine(353480.,"Fe 2",&ipnt);
	lindst(fe2cool.fe20302,353,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 17.936 microns 7-6, label is 178 to be unique */
	PntForLine(179360.,"Fe 2",&ipnt);
	lindst(fe2cool.fe20706,178,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 24.518 microns 8-7 */
	PntForLine(245180.,"Fe 2",&ipnt);
	lindst(fe2cool.fe20807,245,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 35.776 microns 9-8 */
	PntForLine(357760.,"Fe 2",&ipnt);
	lindst(fe2cool.fe20908,358,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.810 microns 10-7 */
	PntForLine(18100.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21007,181,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.677 microns 11-7 */
	PntForLine(16770.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21107,168,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.800 microns 11-8 */
	PntForLine(18000.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21108,180,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.712 microns 12-8 */
	PntForLine(17120.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21208,171,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 1.798 microns 12-9 */
	PntForLine(17980.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21209,179,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 22.902 microns 11-10 */
	PntForLine(229020.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21110,229,"Fe 2",ipnt,'i',TRUE );
	/* call linadd( fe21110 , 229 , 'Fe 2' , 'i' )
	 *
	 * Fe 2 34.660 microns 12-11 */
	PntForLine(346600.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21211,347,"Fe 2",ipnt,'i',TRUE );
	
	/* >>chng 97 mar 14, added following 4 lines after consultation with Verner
	 * these are typically within 5-9% of their large model atom.  These are
	 * predicted with both large and small atom */

	/* Fe 2 8617A 14-06, */
	PntForLine(8617.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21406,8617,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 8892A 15-07 */
	PntForLine(8892.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21507,8892,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 9227A 15-08 */
	PntForLine(9227.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21508,9227,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 9268A 16-09 */
	PntForLine(9268.,"Fe 2",&ipnt);
	lindst(fe2cool.fe21609,9268,"Fe 2",ipnt,'i',TRUE );

	/* following lines are only non-zero when large atom is enabled.  When
	 * running with small feii atoms these are set zero in routine  */
	
	/* Fe 2 5158.81 25-6 */
	PntForLine(5159.,"Fe 2",&ipnt);
	lindst(fe2cool.fe25to6,5159,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 5261.61 27-7 */
	PntForLine(5262.,"Fe 2",&ipnt);
	lindst(fe2cool.fe27to7,5262,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 5333.65 28-8 */
	PntForLine(5334.,"Fe 2",&ipnt);
	lindst(fe2cool.fe28to8,5334,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 5376.47 29-9 */
	PntForLine(5376.,"Fe 2",&ipnt);
	lindst(fe2cool.fe29to9,5376,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4814.55 32-6 */
	PntForLine(4815.,"Fe 2",&ipnt);
	lindst(fe2cool.fe32to6,4815,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4905.35 33-7 */
	PntForLine(4905.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe33to7,4905,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4346.85 37-7 */
	PntForLine(4347.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe37to7,4347,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4352.78 39-8 */
	PntForLine(4353.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe39to8,4353,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4372.43 40-9 */
	PntForLine(4372.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe40to9,4372,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4243.98 37-6 */
	PntForLine(4244.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe37to6,4244,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4276.83 39-7 */
	PntForLine(4277.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe39to7,4277,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4319.62 40-8 */
	PntForLine(4320.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe40to8,4320,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4358.37 41-9 */
	PntForLine(4358.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe41to9,4358,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4177.21 39-6 */
	PntForLine(4177.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe39to6,4177,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4244.81 40-7 */
	PntForLine(4245.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe40to7,4245,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4305.90 41-8 */
	PntForLine(4306.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe41to8,4306,"Fe 2",ipnt,'i',TRUE );

	/* >>chng 99 jun 18 new lines added as per Katya email, so all orion lines are in */
 	
	/* Fe 2 4114.48 42-6 */
	PntForLine(4114.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe42to6,4114,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4178.95	7-	43 */
	PntForLine(4179.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe43to7,4179,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4211.10	7-	42 */
	PntForLine(4211.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe42to7,4211,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4314.29	28-	80 */
	PntForLine(4314.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe80to28,4314,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4359.34	2-	36 */
	PntForLine(4359.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe36to2,4359,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4413.78	3-	36 */
	PntForLine(4414.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe36to3,4414,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4416.27	1-	32 */
	PntForLine(4416.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe32to1,4416,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4457.95	2-	33 */
	PntForLine(4458.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe33to2,4458,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4474.91	5-	36 */
	PntForLine(4475.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe36to5,4475,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4492.64	2-	32 */
	PntForLine(4493.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe32to2,4493,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4514.90	3-	33 */
	PntForLine(4515.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe33to3,4515,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4728.07	3-	30 */
 	PntForLine(4728.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe30to3,4728,"Fe 2",ipnt,'i',TRUE );
	
	/* Fe 2 4774.74	6-	33 */
	PntForLine(4775.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe33to6,4775,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4889.63	2-	24 */
	PntForLine(4890.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe24to2,4890,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4947.37	7-	32 */
	PntForLine(4947.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe32to7,4947,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4950.74	8-	35 */
	PntForLine(4951.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe35to8,4951,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 4973.39	8-	34 */
	PntForLine(4973.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe34to8,4973,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 5111.63	6-	27 */
	PntForLine(5112.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe27to6,5112,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 5220.06	7-	28 */
	PntForLine(5220.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe28to7,5220,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 5268.880	8-	30 */
	PntForLine(5269.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe30to8,5269,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 5273.35	6-	24 */
	PntForLine(5273.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe24to6,5273,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 5296.840	8-	29 */
	PntForLine(5297.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe29to8,5297,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 5433.13	7-	24 */
	PntForLine(5433.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe24to7,5433,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 5527.340	7-	22 */
	PntForLine(5527.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe22to7,5527,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 5746.96	11-	38 */
	PntForLine(5747.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe38to11,5747,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 6440.400	8-	19 */
	PntForLine(6440.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe19to8,6440,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 7155.140	6-	17 */
	PntForLine(7155.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe17to6,7155,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 7171.980	7-	18 */
	PntForLine(7172.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe18to7,7172,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 7388.160	8-	18 */
	PntForLine(7388.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe18to8,7388,"Fe 2",ipnt,'i',TRUE );
 	
	/* Fe 2 7452.540	7-	17 */
	PntForLine(7453.,"Fe 2",&ipnt);
 	lindst(fe2cool.fe17to7,7453,"Fe 2",ipnt,'i',TRUE );

	/* option to save all intensities predicted by large FeII atom,
	 * code is in pop371 */
	if( FeII.lgFeIION )
	{
		FeIIAddLines();
	}

	/* some bands from the large model Fe II atom
	 * only done when large atom is turned on */
	if( FeII.lgFeIION )
	{
		for( i=0; i < nFeIIBands; i++ )
		{
			/* [x][0] is center wavelength, [1] and [2] are upper and
			 * lower bounds in Angstroms.  these are set in FeIIZero */
			eff = FeIISumBand(FeII_Bands[i][1],FeII_Bands[i][2]);
			/* emission from lage FeII atom, integrated over band */
			linadd(eff,FeII_Bands[i][0],"Fe2b",'i' );
		}
		if( LineSave.ipass > 0 )
		{
			for( i=0; i < nFeIIConBins; i++ )
			{
				/* [x][0] is center wavelength, [1] and [2] are upper and
				 * lower bounds in Angstroms.  these are set in FeIIZero */
				/* emission from large FeII atom, integrated over band */
				FeII_Cont[i][0] += 
					(float)(FeIISumBand(FeII_Cont[i][1],FeII_Cont[i][2])*radius.dVeff);
			}
		}
		else
		{
			for( i=0; i < nFeIIConBins; i++ )
			{
				/* this is not within model, so simply zero things out */
				FeII_Cont[i][0] = 0.;
			}
		}
		/* now add lines to stack */
		for( i=0; i < nFeIIConBins; i++ )
		{
			linadd(0., FeII_Cont[i][0] ,"Fe2c",'i' );
		}
	}
	else
	{
		/* must still add the bands in case of grid where feii is turned off and on */
		for( i=0; i < nFeIIBands; i++ )
		{
			linadd(0., FeII_Bands[i][0] ,"Fe2b",'i' );
		}
		for( i=0; i < nFeIIConBins; i++ )
		{
			linadd(0., FeII_Cont[i][0] ,"Fe2c",'i' );
		}
	}

	/* anomalous Fe 2 transition at 1787, RMT 191 */
	PutLine(&TauLines[ipT191]);

	/* sum of 3p and 3g states together */
	linadd(CoolHeavy.c5270,0,"Fe 3",'c' );

	/* Fe 3 5270, predictions from garstang et al 78 */
	PntForLine(5270.,"Fe 3",&ipnt);
	lindst(CoolHeavy.c5270*0.2090,5270,"Fe 3",ipnt,'c',TRUE );
	
	/* Fe 3 5270, predictions from garstang et al 78 */
	PntForLine(4658.,"Fe 3",&ipnt);
	lindst(CoolHeavy.c5270*0.3667,4658,"Fe 3",ipnt,'c',TRUE );
	
	/* Fe 3 1122 entire multiplet */
	PutLine(&TauLines[ipT1122]);

	/* total cooling due to 12-level Fe 4 atom */
	linadd(fe4cool.Fe4CoolTot,0,"Fe 4",'c' );

	/* Fe 4 3096.A, 4-1 and 5-1 transitions together */
	PntForLine(3096.,"Fe 4",&ipnt);
	lindst(fe4cool.fe40401,3096,"Fe 4",ipnt,'i',TRUE );
	
	/* Fe 4 2835.7A, 6-1 transition, 4P5/2 - 6S5/2 */
	PntForLine(2836.,"Fe 4",&ipnt);
	lindst(fe4cool.fe42836,2836,"Fe 4",ipnt,'i',TRUE );
	
	/*  Fe 4 2829.4A, 7-1 transition, 4P3/2 - 6S5/2 */
	PntForLine(2829.,"Fe 4",&ipnt);
	lindst(fe4cool.fe42829,2829,"Fe 4",ipnt,'i',TRUE );
	
	/*  Fe 4 2567.6+ 2567.4. 11-1 and 12-1 transitions */
	PntForLine(2567.,"Fe 4",&ipnt);
	lindst(fe4cool.fe42567,2567,"Fe 4",ipnt,'i',TRUE );
	
	/* Fe 4 2.774 microns 12-7 transition */
	PntForLine(2.774e4,"Fe 4",&ipnt);
	lindst(fe4cool.fe41207,277,"Fe 4",ipnt,'i',TRUE );
	
	/*  Fe 4 2.714 microns 12-6 transition */
	PntForLine(2.714e4,"Fe 4",&ipnt);
	lindst(fe4cool.fe41206,271,"Fe 4",ipnt,'i',TRUE );
	
	/*  Fe 4 2.716 microns 11-6 transition */
	PntForLine(2.716e4,"Fe 4",&ipnt);
	lindst(fe4cool.fe41106,272,"Fe 4",ipnt,'i',TRUE );
	
	/*  Fe 4 2.806 microns 10-7 transition */
	PntForLine(2.806e4,"Fe 4",&ipnt);
	lindst(fe4cool.fe41007,281,"Fe 4",ipnt,'i',TRUE );
	
	/*  Fe 4 2.865 microns 10-8 transition */
	PntForLine(2.865e4,"Fe 4",&ipnt);
	lindst(fe4cool.fe41008,287,"Fe 4",ipnt,'i',TRUE );
	
	/*  Fe 4 2.836 microns 9-6 transition */
	PntForLine(2.836e4,"Fe 4",&ipnt);
	lindst(fe4cool.fe40906,284,"Fe 4",ipnt,'i',TRUE );
	
	/*  Fe 5  3892+3839 */
	PntForLine(3892.,"Fe 5",&ipnt);
	lindst(CoolHeavy.c3892,3892,"Fe 5",ipnt,'c',TRUE );
	
	/*  all of 2G lines together first */
	linadd(CoolHeavy.c5177,0,"Fe 6",'c' );

	/* Fe 6 5177, approximate correct */
	PntForLine(5177.,"Fe 6",&ipnt);
	lindst(CoolHeavy.c5177*0.354,5177,"Fe 6",ipnt,'c',TRUE );
	
	/*  [Fe 7] 9.51 micron */
	PutLine(&TauLines[ipFe0795]);

	/* [Fe 7] 7.81 micron */
	PutLine(&TauLines[ipFe0778]);

	/* [Fe 7] 6087 */
	PntForLine(6087.,"Fe 7",&ipnt);
	lindst(CoolHeavy.c6087,6087,"Fe 7",ipnt,'c',TRUE );
	
	/* [Fe 7] 5722 */
	PntForLine(5722.,"Fe 7",&ipnt);
	lindst(CoolHeavy.Fe5722,5722,"Fe 7",ipnt,'c',TRUE );
	
	/*  Be-seq lines */
	PutLine(&TauLines[ipT245]);

	/* Fe 9 242 j=1 slower decay */
	PntForLine(242.,"Fe 7",&ipnt);
	lindst(CoolHeavy.c242,242,"Fe 7",ipnt,'c',TRUE );
	
	/*  the E1 transition that can pump [Fe X] */
	PutLine(&TauLines[ipT352]);

	/* optically thin Fe X pumping */
	eff = 69.4/(69.4 + 0.27*phycon.cdsqte);

	/* coll exc of 352 which decays to escit state of 6374
	 * assumes 17/56 (ratio of A's) go to excit state */
	c10 = TauLines[ipT352].phots*eff*.01676*TauLines[ipT352].EnergyErg*352/6374.;

	/* Fe 10 and Fe 14 from Mason 75
	 * total (coll, pumped)
	 * call linadd( C6374+C10 , 6374 , 'Fe10','i') */
	PutExtra( c10 );

	/* [Fe 10] 6375, collisions with pumping too */
	PutLine(&TauLines[ipFe106375]);

	/* collisional contribution
	 * call linadd( C6374 , 6374 , 'Coll','c')
	 * collisions of E1 line, plus pumped by continuum fluorescense
	 * call linadd( C10 , 6374 , ' 352','c')
	 * Fe XI 7892, 6.08 micron */
	PutLine(&TauLines[ipTFe07]);

	/* TODO put this line back in!
	 * EFF = 43.6 / (43.6 + 0.27*COLFAC)
	 * R11 = FE(11)*FLUX(IPFE10)*3.122E-12*EFF *
	 *  1 ( PFE11A*ESCINC(T353(1),1E-4)/(1.+17.0/5.3*T353(3) )  +
	 *  2 PFE11B*ESCINC(T353(1)/3.,1E-4)/(1.+11.0/12.3*T353(3) ) )
	 * contribution to Fe11 from continuum fluorescense
	 * call linadd( R11    , 7892 , 'Pump','i')
	 *
	 * [Fe 11] 6.08 microns */
	PutLine(&TauLines[ipTFe61]);

	/* Fe 11 2649 collisional excitation */
	PntForLine(2649.,"Fe11",&ipnt);
	lindst(CoolHeavy.c2649,2649,"Fe11",ipnt,'c',TRUE );
	
	/*  Fe 11 1467 collisional excitation */
	PntForLine(1467.,"Fe11",&ipnt);
	lindst(CoolHeavy.c1467,1467,"Fe11",ipnt,'c',TRUE );
	
	/*  Fe 12, 1242, 1349 together, collisional excitation */
	PntForLine(1242.,"Fe12",&ipnt);
	lindst(CoolHeavy.c1242,1242,"Fe12",ipnt,'c',TRUE );
	
	/*  Fe 12, 2170, 2406 together, collisional excitation */
	PntForLine(2170.,"Fe12",&ipnt);
	lindst(CoolHeavy.c2170,2170,"Fe12",ipnt,'c',TRUE );
	
	/*  Fe12 2904, 2567, 3567, 3073 together, collisional excitation */
	PntForLine(2568.,"Fe12",&ipnt);
	lindst(CoolHeavy.c2568,2568,"Fe12",ipnt,'c',TRUE );
	
	/*  [Fe 13] 1.07 microns */
	PutLine(&TauLines[ipFe1310]);

	/* [Fe 13] 1.08 microns */
	PutLine(&TauLines[ipFe1311]);

	/* [Fe13] 3388.5A */
	PntForLine(3388.5,"Fe13",&ipnt);
	lindst(CoolHeavy.fe13_3000*0.424,3388,"Fe13",ipnt,'c',TRUE );

	/* [Fe13] 2578.77A */
	PntForLine(2578.77,"Fe13",&ipnt);
	lindst(CoolHeavy.fe13_3000*0.576,2578,"Fe13",ipnt,'c',TRUE );

	/* [Fe13] 1216.43A */
	PntForLine(1216.43,"Fe13",&ipnt);
	lindst(CoolHeavy.fe13_1216,1216,"Fe13",ipnt,'c',TRUE );

	/* [Fe13] 2302.0A */
	PntForLine(2302.0,"Fe13",&ipnt);
	lindst(CoolHeavy.fe13_2302,2302,"Fe13",ipnt,'c',TRUE );

	/* Fe 14 optically thin in line 344 */
	eff = 60.3/(60.3 + 0.23*phycon.cdsqte/4.);
	r14 = dense.xIonDense[ipIRON][14-1]*pumpfe.pfe14*rfield.flux[pumpfe.ipfe10-1]*
	  3.75e-12*eff/(1. + 24./.63*
	  TauLines[ipT347].Pesc)*esc_PRD_1side(TauLines[ipT347].TauIn,1e-4);
	PntForLine(5303.,"Fe14",&ipnt);

	lindst(CoolHeavy.c5303+r14,5303,"Fe14",ipnt,'i',TRUE );
	
	/*  contribution from collisional excitation */
	linadd(CoolHeavy.c5303,5303,"Coll",'c' );

	/* continuum fluorescense */
	linadd(r14,5303,"Pump",'r' );

	/* collisional excitation of E1 line
	 * TODO put this in */
	c14 = 0.;
	linadd(c14,5303," 347",'c' );

	/* Fe 18 974.86A */
	PutLine(&TauLines[ipFe18975]);

	/* O-like Fe19, 3P ground term, 7046.72A vac wl, 1328.90A */
		/* >>chng 01 aug 10, updated wavelengths */
	/*  Fe 19 7047 '85 */
	PntForLine(7047.,"Fe19",&ipnt);
	lindst(CoolHeavy.c7082,7047,"Fe19",ipnt,'c',TRUE );
	
	/*  Fe 19 1329 */
	PntForLine(1328.,"Fe19",&ipnt);
	lindst(CoolHeavy.c1328,1329,"Fe19",ipnt,'c',TRUE );

	/* Fe 19 from loulergue et al '85 */
	PntForLine(592.,"Fe19",&ipnt);
	lindst(CoolHeavy.c592,592,"Fe19",ipnt,'c',TRUE );
	
	/*  Fe 19 from loulergue et al '85 */
	PntForLine(1118.,"Fe19",&ipnt);
	lindst(CoolHeavy.c1118,1118,"Fe19",ipnt,'c',TRUE );
	
	/*  next two 3p ground state lines, collisional excitation */
	PutLine(&TauLines[ipTFe13]);

	/* collisional excitation */
	PutLine(&TauLines[ipTFe23]);

	/* Fe20 721.40A, 578*/
	PutLine(&TauLines[ipTFe20_578]);
	PutLine(&TauLines[ipTFe20_721]);

	/* Fe 22 845.6A */
	/* total intensity of Fe22, all lines in the multiplet */
	linadd(
		TauLines[ipFe22_247].xIntensity+
		TauLines[ipFe22_217].xIntensity+
		TauLines[ipFe22_348].xIntensity+
		TauLines[ipFe22_292].xIntensity+
		TauLines[ipFe22_253].xIntensity,
		260,"TOTL",'i' );
	PutLine(&TauLines[ipFe22_247]);
	PutLine(&TauLines[ipFe22_217]);
	PutLine(&TauLines[ipFe22_348]);
	PutLine(&TauLines[ipFe22_292]);
	PutLine(&TauLines[ipFe22_253]);
	
	/*  Fe 23 1909-like 262.6 */
	PntForLine(263.,"Fe23",&ipnt);
	lindst(CoolHeavy.c263,263,"Fe23",ipnt,'c',TRUE );
	
	/*  Fe 24 only 192 of 255, 192 Li seq doublet, collisional excitation */
	PutLine(&TauLines[ipT192]);

	/* Fe 24 255 of 255, 192 Li seq doublet, collisional excitation */
	PutLine(&TauLines[ipT255]);

	/* Fe 24 Li seq 2s3p collisional excitation */
	PutLine(&TauLines[ipT11]);

	/* recombination Ka */
	if( dense.lgElmtOn[ipIRON] )
	{
		/* these lines added to outlin in metdif - following must be false
		 * fela = xLyaHeavy(nelem,nelem)*dense.xIonDense(nelem,nelem+1) */
		fela = EmisLines[ipH_LIKE][ipIRON][ipH2p][ipH1s].xIntensity;
	}
	else
	{
		fela = 0.;
	}

	/* total intensity of K-alpha line */
	/* >>chng 02 jan 14, add grain fe to this sum */
	linadd((fekems.fekcld+fekems.fegrain)*1.03e-8+(fekems.fekhot+fela)*1.11e-8,2,"FeKa",'i' );

	/* recombination from fully stripped ion */
	linadd(fela*1.11e-8,2,"FeLr",'i' );

	/* total hot iron Ka; Auger "hot" iron, plus recom */
	linadd((fekems.fekhot+fela)*1.11e-8,2,"TotH",'i' );

	/* Auger production of "cold" iron, less than or 17 times ionized */
	linadd(fekems.fekcld*1.03e-8,2,"AugC",'i' );

	/* grain production of "cold" iron */
	linadd(fekems.fegrain*1.03e-8,2,"AugG",'i' );

	/* [Co XI] 5168. A */
	PutLine(&TauLines[ipCo11527]);

	/* nickel*/

	/* [Ni XII] 4230.8 A */
	PutLine(&TauLines[ipxNi1242]);

	/* copper */

	/* zinc */
	/* zinc iv 3.625 microns, cs and A just made up */
	PutLine(&TauLines[ipZn04363]);

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_lv1_k_zn returns\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->lines_lv1_k_zn()\n", debug_fp );
#	endif
	return;
}
