/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*lines_helium put energetics, H, and He lines into line intensity stack */
#include "cddefines.h"
#include "taulines.h"
#include "dense.h"
#include "phycon.h"
#include "lines_service.h"
#include "iso.h"
#include "linesave.h"
#include "trace.h"
#include "lines.h"
#include "helike.h"

void lines_helium(void)
{
	long int i, 
	  ipHi, 
	  ipLo, 
	  ipnt,
	  nelem;
	char chLabel[5];
	double 
	  cb206, 
	  cb5016, 
	  cb5876 ,
	  em, 
	  rec, 
	  sum;

#	ifdef DEBUG_FUN
	fputs( "<+>lines_helium()\n", debug_fp );
#	endif

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_helium called\n" );
	}

	/* HeI */
	i = StuffComment( "He-like iso-sequence" );
	linadd( 0., (float)i , "####", 'i');

	/* He I 4471, */
	if( phycon.te <= 1e4 )
	{
		em = 2.42e-22/(phycon.te/phycon.te10);
	}
	else
	{
		em = 8.79e-22/phycon.te/phycon.te03/phycon.te01;
	}

	/* >>chng 97 jan 04, label was HeI, changed to Ca B for symmetry with others
	 * He I 4471 recombination only, fit to Brocklehurst '72 */
	rec = dense.eden*dense.xIonDense[ipHELIUM][1]*em;
	PntForLine(4471.,"He 1",&ipnt);
	lindst(rec,4471,"Ca B",ipnt,'i',TRUE );

	/* He I 5876 REC, simple fit to Brocklehurst */
	cb5876 = dense.eden*dense.xIonDense[ipHELIUM][1]*4.22e-21/(phycon.te*phycon.te10);
	linadd( cb5876 , 5876 , "Ca B" , 'i' );

	/* this is collisional enhancement of 5876 from 
	 * >>refer	He1	coll	KingdonJ., & Ferland, G.J. 1995, ApJ, 442, 714-725 */
	if( dense.eden < 1e8 )
	{
		double D = 1. + 3131.*100./phycon.sqrte / dense.eden ;
		em = (6.78*0.52581*phycon.te07*sexp(3.776e4/phycon.te) +
			1.67*3.9811/(phycon.te10*phycon.te05)*sexp(4.545e4/phycon.te ) +
			0.60*22.9087/(phycon.te30*phycon.te04)*sexp(4.901e4/phycon.te) ) / D;
	}
	else
	{
		em = 0.;
	}
	/* simple He1 5876 with collisions */
	linadd( cb5876*(1.+em) , 5876 , "wCol" , 'i' );

	/* He I 6678 REC, simple fit to Brocklehurst */
	rec = dense.eden*dense.xIonDense[ipHELIUM][1]*1.32e-21/(phycon.te*phycon.te10*phycon.te01);
	PntForLine(6678.,"He 1",&ipnt);
	lindst(rec,6678,"Ca B",ipnt,'i',TRUE );

	em = dense.eden*dense.xIonDense[ipHELIUM][1];
	cb206 = 1.064e-22/phycon.te70/phycon.te10/phycon.te03/phycon.te03*
	  em;

	/* case B He I 2.06 micron - new or old wavelength scaling?  */
	linadd(cb206,20600.,"Ca B",'i');

	/* Case B He I 5016 */
	cb5016 = 5.43e-23/phycon.te70/phycon.te10*em;
	PntForLine(5016.,"He 1",&ipnt);
	lindst(cb5016,5016,"Ca B",ipnt,'i',TRUE );

	/* this is the main printout, where line intensities are entered into the stack */
	for( nelem=1; nelem < LIMELM; nelem++ )
	{
		if( dense.lgElmtOn[nelem] )
		{
			double caseb = iso.RadRec_caseB[ipHE_LIKE][nelem] * 
				EmisLines[ipHE_LIKE][nelem][ipHe2p1P][ipHe1s1S].EnergyErg *
				dense.eden * dense.xIonDense[nelem][nelem];
			
			linadd( caseb ,EmisLines[ipHE_LIKE][nelem][ipHe2p1P][ipHe1s1S].WLAng,"Ca B",'i');

			/* do not print more than first 50 levels */
			/* NB NB - low and high must be in this order so that all balmer, paschen,
			 * etc series line up correctly in final printout */
			/* >>chng 01 jun 13, bring 23P lines back together */
			/* two photon is special, not a line and no ipCont array index, add here */

			EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].xIntensity = 
				(double)EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].Aul*
				(double)EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].PopHi*
				(double)EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].Pesc*
				(double)dense.xIonDense[nelem][nelem]*
				(double)EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].EnergyErg;
			if( LineSave.ipass == 0 )
			{
				/* chIonLbl is function that generates a null terminated 4 char string, of form "C  2" 
				 * the result, chLable, is only used when ipass == 0, can be undefined otherwise */
				chIonLbl(chLabel, &EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S]);
			}
			linadd( EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].xIntensity , 0,chLabel,'r');

			/* induced two photon emission */
			linadd(
				iso.Pop2Ion[ipHE_LIKE][nelem][ipHe2s1S]*
				dense.xIonDense[nelem][nelem]*
				iso.TwoNu_induc_dn[ipHE_LIKE][nelem]*
				EmisLines[ipHE_LIKE][nelem][ipHe2s1S][ipHe1s1S].EnergyErg,
				22, chLabel ,'i');

			/* here we will create an entry for the three lines 
			 * coming from 2 3P to 1 1S - the entry called TOTL will
			 * appear before the lines of the multiplet */
			sum = 0.;
			for( i=ipHe2p3P0; i <= ipHe2p3P2; i++ )
			{
				sum += 
					(double)EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].Aul*
					(double)EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].PopHi*
					(double)EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].Pesc*
					(double)dense.xIonDense[nelem][nelem]*
					(double)EmisLines[ipHE_LIKE][nelem][i][ipHe1s1S].EnergyErg;
			}

			/* add to line stack */
			linadd(sum,EmisLines[ipHE_LIKE][nelem][ipHe2p3P0][ipHe1s1S].WLAng,"TOTL",'i' );
			
			/* now do real permitted lines */
			for( ipLo=0; ipLo < ipHe2p3P0; ipLo++ )
			{
				for( ipHi=ipLo+1; ipHi < iso.numPrintLevels[ipHE_LIKE][nelem]; ipHi++ )
				{
					/* >>chng 01 may 30, do not add fake he-like lines (majority) to line stack */
					/* >>chng 01 dec 11, use variable for smallest A */
					if( EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].ipCont < 1 ) 
						continue;

					/* recombine fine-structure lines since the energies are
					 * not resolved anyway.	*/
					if( helike.lgFSM && ( abs(iso.quant_desig[ipHE_LIKE][nelem][ipHi].l -
						iso.quant_desig[ipHE_LIKE][nelem][ipLo].l)==1 )
						&& (iso.quant_desig[ipHE_LIKE][nelem][ipLo].l>1) 
						&& (iso.quant_desig[ipHE_LIKE][nelem][ipHi].l>1) 
						&& ( iso.quant_desig[ipHE_LIKE][nelem][ipHi].n >
						iso.quant_desig[ipHE_LIKE][nelem][ipLo].n ) )
					{
						if( (iso.quant_desig[ipHE_LIKE][nelem][ipHi].s==0) 
							&& (iso.quant_desig[ipHE_LIKE][nelem][ipLo].s==0) )
						{
							continue;
						}
						else if( (iso.quant_desig[ipHE_LIKE][nelem][ipHi].s==1) 
							&& (iso.quant_desig[ipHE_LIKE][nelem][ipLo].s==1) )
						{

							/* singlet to singlet*/
							EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo+1].phots = 
								( (double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo+1].Aul*
								(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo+1].PopHi*
								(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo+1].Pesc +							+
								(double)EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo+1].Aul*
								(double)EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo+1].PopHi*
								(double)EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo+1].Pesc )*
								(double)dense.xIonDense[nelem][nelem];
							
							EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo+1].xIntensity = 
								EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo+1].phots *
								(double)EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo+1].EnergyErg;

							PutLine(&EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo+1]);
						
							/* triplet to triplet */
							EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].phots = 
								( (double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
								(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
								(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc +
								(double)EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo].Aul*
								(double)EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo].PopHi*
								(double)EmisLines[ipHE_LIKE][nelem][ipHi+1][ipLo].Pesc )*
								(double)dense.xIonDense[nelem][nelem];
							
							EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].xIntensity = 
								EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].phots *
								(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].EnergyErg;

							PutLine(&EmisLines[ipHE_LIKE][nelem][ipHi][ipLo]);
						}
					}
					
					if( ipLo==ipHe2s3S && ipHi == ipHe2p3P0 )
					{
						/* here we will create an entry for the three lines 
						 * coming from 2 3P to 2 3S - the entry called TOTL will
						 * appear before the lines of the multiplet 
						 * for He I this is 10830 */

						sum = 0.;
						for( i=ipHe2p3P0; i <= ipHe2p3P2; i++ )
						{
							sum += 
								(double)EmisLines[ipHE_LIKE][nelem][i][ipLo].Aul*
								(double)EmisLines[ipHE_LIKE][nelem][i][ipLo].PopHi*
								(double)EmisLines[ipHE_LIKE][nelem][i][ipLo].Pesc*
								(double)dense.xIonDense[nelem][nelem]*
								(double)EmisLines[ipHE_LIKE][nelem][i][ipLo].EnergyErg;
						}

						/* add to line stack */
						linadd(sum,EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].WLAng,"TOTL",'i' );
					}

					/* find number of photons escaping cloud */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].phots = 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						dense.xIonDense[nelem][nelem];

					/* now find line intensity */
					/* >>chng 01 jan 15, put cast double to force double evaluation */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].xIntensity = 
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						(double)dense.xIonDense[nelem][nelem]*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].EnergyErg;
					/* this will enter .xIntensity into the line stack
					fprintf(ioQQQ,"1 loop %li %li %.1f\n", ipLo,ipHi, 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].WLAng ); */
					PutLine(&EmisLines[ipHE_LIKE][nelem][ipHi][ipLo]);
					{
						/* option to print particulars of some line when called
						 * a prettier print statement is near where chSpin is defined below*/
						/*@-redef@*/
						enum {DEBUG_LOC=FALSE};
						/*@+redef@*/
						if( DEBUG_LOC )
						{
							if( nelem==1 && ipLo==0 && ipHi==1 )
							{
								fprintf(ioQQQ,"he1 626 %.2e %.2e \n", 
									EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].TauIn,
									EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].TauTot
									);
							}
						}
					}
				}
			}

			/* this sum will bring together the three lines going to J levels within 23P */
			for( ipHi=ipHe2p3P2+1; ipHi < iso.numPrintLevels[ipHE_LIKE][nelem]; ipHi++ )
			{
				double sumcool , sumheat ,
					save , savecool , saveheat;

				sum = 0;
				sumcool = 0.;
				sumheat = 0.;
				for( ipLo=ipHe2p3P0; ipLo <= ipHe2p3P2; ++ipLo )
				{
					/* find number of photons escaping cloud */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].phots = 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						dense.xIonDense[nelem][nelem];

					/* now find line intensity */
					/* >>chng 01 jan 15, put cast double to force double evaluation */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].xIntensity = 
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						(double)dense.xIonDense[nelem][nelem]*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].EnergyErg;

					sumcool += EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].cool;
					sumheat += EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].heat;
					sum += EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].xIntensity;
				}

				/* >>chng 01 dec 11, use variable for smallest A */
				/* >>chng 02 feb 10, replaced check on A with ipCont */
				if( EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].ipCont < 1 ) 
					continue;
				/* this will enter .xIntensity into the line stack */
				save = EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].xIntensity;
				savecool = EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].cool;
				saveheat = EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].heat;

				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].xIntensity = sum;
				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].cool = sumcool;
				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].heat = sumheat;

				/*fprintf(ioQQQ,"2 loop %li %li %.1f\n", ipHe2p3P2,ipHi, 
					EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].WLAng );*/
				PutLine(&EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2]);

				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].xIntensity = save;
				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].cool = savecool;
				EmisLines[ipHE_LIKE][nelem][ipHi][ipHe2p3P2].heat = saveheat;
			}
			for( ipLo=ipHe2p3P2+1; ipLo < iso.numPrintLevels[ipHE_LIKE][nelem]-1; ipLo++ )
			{
				for( ipHi=ipLo+1; ipHi < iso.numPrintLevels[ipHE_LIKE][nelem]; ipHi++ )
				{
					/* >>chng 01 may 30, do not add fake he-like lines (majority) to line stack */
					/* >>chng 01 dec 11, use variable for smallest A */
					/* >>chng 02 feb 12, use ipCont to find bogus lines */
					/*if( EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul <= iso.SmallA )*/
					if( EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].ipCont < 1 ) 
						continue;

					/* find number of photons escaping cloud */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].phots = 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						dense.xIonDense[nelem][nelem];

					/* now find line intensity */
					/* >>chng 01 jan 15, put cast double to force double evaluation */
					EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].xIntensity = 
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Aul*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].PopHi*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].Pesc*
						(double)dense.xIonDense[nelem][nelem]*
						(double)EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].EnergyErg;
					/* this will enter .xIntensity into the line stack 
					fprintf(ioQQQ,"2 loop %li %li %.1f\n", ipLo,ipHi, 
						EmisLines[ipHE_LIKE][nelem][ipHi][ipLo].WLAng );*/
					PutLine(&EmisLines[ipHE_LIKE][nelem][ipHi][ipLo]);
				}
			}
		}
	}

	/* ====================================================
	 * end helium
	 * ====================================================*/

	if( trace.lgTrace )
	{
		fprintf( ioQQQ, "   lines_helium returns\n" );
	}

#	ifdef DEBUG_FUN
	fputs( " <->lines_helium()\n", debug_fp );
#	endif
	return;
}
