/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*lines main routine to put emission line intensities into line stack */
void lines(void);

/* general information at start of lines */
void lines_general(void);

/* the hydrogenic iso-sequence */
void lines_hydro(void);

/* information about grains */
void lines_grains(void);

/* enter all continua */
void lines_continuum(void);

/* enter all molecules into emission line stack */
void lines_molecules(void);

/* enter all helium iso seq into emission line stack */
void lines_helium(void);

/*lines_lv1_li_ne place lines of elements lithium through neon into lines storage stack */
void lines_lv1_li_ne(void);

/*lines_lv1_na_ar place lines of elements sodium through argon into lines storage stack */
void lines_lv1_na_ar(void);

/*lines_lv1_k_zn place lines of elements potatium and heavier into lines storage stack */
void lines_lv1_k_zn(void);

/* routine to stuff comments into the stack of comments,
 * return is index to this comment */
long int StuffComment( char * chComment );
