/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* ionrec.h */
/* max number of shells we ever have to deal with */
#define NSHELLS	7
EXTERN struct t_ion {

	/* ==============================================================
	 * all following deals with ionization processes */

	/* store photoionization rates for all shells of all elements
	 * first dim is nelem, the atomic number of element on the c scale, H is 0.
	 * second dim is stage of ionization, on the c scale, atom is 0.
	 * third dim is shell number, K shell is 0, valence shell depends on ion, up to 7
	 * last dim: 0 is photo rate (s-1)
	 *           1 is low energy heating
	 *           2 is high energy (secondary-capable) total heating
	 *           both will be nultiplied by ion abundance to get vol rates 
	 * some special last pairs - 
	 * [x][0][10][0] pair production in highen
	 */
	double ****PhotoRate_Shell/*[LIMELM][LIMELM][7][3]*/;

	/* set to 1 in zero, so have no effect, 
	 * set to 0 with 'no photoionization' command, 
	 * kills photoionization of everything */
	int lgPhotoIoniz_On;

	/* collisional ionization rate for CollidRate[nelem][ion][0], s-1
	* cooling, erg/s in CollidRate[nelem][ion][1] */
	double ***CollIonRate_Ground/*[LIMELM][LIMELM][2]*/;

	/* cosmic ray ionization rate */
	double CosRayIonRate;

	/* cosmic ray heating rate */
	double CosRayHeatRate;

	/* local heating rate due to some "extra" process */
	double ExtraHeatRate;

	/* heating due to fast neutrons */
	double xNeutronHeatRate;

	/* ionization and heating due to pair production */
	double PairProducPhotoRate[3];

	/* ==============================================================
	 * following deal with compton recoil ionization of bound electrons */
	/* flag saying that compton recoil ionization of bound
	 * electrons is enabled,
	 * set false with no recoil ionization command */
	int lgCompRecoil;

	/* the local heating due to compton recoil ionization */
	double CompRecoilHeatLocal;

	/* array indices for continuum offset of compton recoil ionization threshold */
	long int **ipCompRecoil;

	/* rate of bound electron ionization by compton scattering */
	double **CompRecoilIonRate;

	/* save rate of bound electron ionization by compton scattering */
	double **CompRecoilIonRateSave;

	/* heating rate due to bound electron ionization by compton scattering */
	double **CompRecoilHeatRate;

	/* save heating rate due to bound electron ionization by compton scattering */
	double **CompRecoilHeatRateSave;

	/* inner shell ionization rate due to Behar inner shell line absorption */
	double **xInnerShellIonize;

	/* this says whether to include inner shell absorption lines */
	int lgInnerShellLine_on;

	/* total ionization rate (s-1) all processes */
	double **TotIonizRate;

	/* number of valence electrons that can participate - multipies since electron rate */
	long int  nCompRecoilElec[LIMELM];

	double CompHeating_Max;
	/* ==============================================================
	 * end compton recoil ionization of bound electrons */

	/* ==============================================================
	 * all following deals with recombination */

	/* total recombination rate (s-1) all processes */
	double **TotRecomRate;

	/* total recombination rate coef (cm3 s-1) all processes */
	double **RadRecomRateCoef;

	/* which version of Dima's rrfit routine to use? */
	int lgVrrFit;

	/* GrnIonRec - rate coefficient for ionic recombination on grain surfaces */
	float GrnIonRec, 
	 /*grecon usually 1, set to 0 with no grain neutralization command	 */
	  grecon;

	/* suppresssion factors for dielectronic recombination
	 * 1 is burgess and 2 is storey */
	float DielSupprs[2][LIMELM];

	/* logical flag for suppression of dielectronic recombination
	 * 1 is burgess, 2 is nussbaumer and storey	 */
	int lgSupDie[2];

	/* this is fudge factor for scaled nussbamer and story diel recom
	 * set with diel kludge commmand, usually 1 */
	float GuessDiel[4];

	/* following all for 3-body recombination */
	/* lgNoCota flag set with no three body recombination */
	int lgNoCota;

	/* the actual rates */
	float CotaRate[LIMELM];

	/* these are error flags for three-body recombination */
	long int ilt, 
	  iltln, 
	  ilthn, 
	  ihthn, 
	  ifail;

	}	ionrec;

