/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* ionrange.h */
EXTERN struct t_IonRange {

	/*
	 * indices for lowest and highest stages of ionization of the elements
	 * all are initially set in nsset
	 * the range is from 0 to nelem +1 
	 */

	/* indices for lowest stage of ionization of the elements on C scale, 
	 * lowest is 0 for atom, -1 if element turned off, 
	 * initialized in nsset, called by ConSetIntensity
	 * the first stage of ionization with positive abundance is [IonLow] where 0 is the atom,
	 * the highest stage of ionization with positive abundance is [IonHigh], 
	 * NB NB so loops should be 
	 * ion=IonLow, ion<=IonHigh; 
	 */
	long int IonLow[LIMELM], 

	  /* indices for highest stage of ionization of the elements, 
	   * initially nelem+1 (nelem - H - 0), initialized in nsset, called by ConSetIntensity */
	  IonHigh[LIMELM], 

	  /* also places to save them between iterations */
	  IonLowSave[LIMELM], 
	  IonHighSave[LIMELM];

	/* flag saying not to decrement this range */
	int lgNoDec;

	/* limits for highest and lowest stages of ionization in TrimStages,
	 * these are set with command "set trim xx" where xx is log of upper
	 * and lower ionization fractions.  if only one number then both are
	 * set to it.  These variables are used in trimStages to adjust the
	 * range of ionization. */

	/* limit to fractional abundance of high stage of ionization,
	 * set to 1e-6 in zero.c */
	double trimhi, 

	/* limit to fractional abundance of low stage of ionization,
	 * set to 1e-10 in zero.c */
	  trimlo;

	}	IonRange;


