/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*IonLithi compute ionization balance for lithium */
#include "cddefines.h"
#ifdef NDIM
#	undef NDIM
#endif
#ifdef NELEM
#	undef NELEM
#endif
#define	NDIM	4
#define	NELEM	3
#include "dense.h"
#include "collidionize.h"
#include "ionzer.h"
#include "makerecomb.h"
#include "photoionize.h"
#include "bidiag.h"
#include "ionize.h"

void IonLithi(void)
{
	long int i, 
	  _r;
	static double dicoef[2][NDIM - 1], 
	  dite[2][NDIM - 1];
	static double rec[NDIM - 2]={1.47e-10,8.74e-10};
	static double pl[NDIM - 2]={-0.624,-0.645};
	static double tlow[2]={1.44e-10,-0.621};
	static double ditcrt[NDIM - 1]={1.2e4,1.2e4,1e20};
	static double aa[NDIM - 1]={0.,0.,0.};
	static double bb[NDIM - 1]={0.,0.,0.};
	static double cc[NDIM - 1]={0.,0.,0.};
	static double dd[NDIM - 1]={0.,0.,0.};
	static double ff[NDIM - 1]={0.1,0.1,0.};
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp2[] = {2.54e-3,6.15e-3,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[0][i-1] = _itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {4.42e-2,5.88e-2,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dicoef[1][i-1] = _itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {1.57e5,1.41e5,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[0][i-1] = _itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {3.74e5,1.41e5,0.};
		for( i=1, _r = 0; i <= (NDIM - 1); i++ )
		{
			dite[1][i-1] = _itmp5[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>IonLithi()\n", debug_fp );
#	endif

	/* lithium nelem=3
	 * data are for carbon
	 *
	 * fluorescent fields, first dim is stage of ionization, sec is shell
	 *
	 * rates from Shull and van Steenberg, Ap.J. Sup 48, 95. */
	/* DATA GRDEFF/0.10,0.10,0.10/
	 * GRDEFF is fraction of recombinations to ground state, used for
	 * outward diffuse fields
	 *
	 * rec from +3, +4 from Arnaud et al Ast Ap Sup 60 425. (1985)
	 * rec from fully ionized uses Seaton '79 in ionrat */
	/* Pequignot and Aldrovandi Ast Ap 161, 169. */

	if( !dense.lgElmtOn[NELEM-1] )
	{
		
#		ifdef DEBUG_FUN
		fputs( " <->IonLithi()\n", debug_fp );
#		endif
		return;
	}

	/* zero out ionization balance arrays */
	ionzer(NELEM-1);

	PhotoIonize(NELEM-1,FALSE);

	/* find collisional ionization rates */
	CollidIonize(NELEM-1);

	/* get recombination coefficients */
	MakeRecomb(rec,pl,(double*)dicoef,(double*)dite,ditcrt,aa,bb,cc,
	  dd,ff,NELEM-1,tlow);

	/* solve for ionization balance */
	BiDiag(NELEM-1,FALSE);

#	ifdef DEBUG_FUN
	fputs( " <->IonLithi()\n", debug_fp );
#	endif
	return;
}

