/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* these are the hydrogenic routines written by Robert Bauman           */
/*      For references, see h_bauman.c                                  */

/************************************************************************/
/*  IN THE FOLLOWING WE HAVE  n > n'                                    */
/************************************************************************/

/* returns hydrogenic photoionization cross section in cm-2             */
double H_photo_cs( 
                  /* photon energy relative to threshold  */
                  double photon_energy, 
                  /* principal quantum number, 1 for ground             */
                  long int n, 
                  /* angular momentum, 0 for s                          */
                  long int l, 
                  /* charge, 1 for H+, 2 for He++, etc                  */
                  long int iz );

/************************************************************************/
/*   Calculates the Einstein A's for hydrogen                           */
/*   for the transition n,l --> n',l'                                   */
/*   units of sec^(-1)                                                  */
/*                                                                      */
/*  In the following, we have n > n'                                    */
/************************************************************************/
double H_Einstein_A(/*  IN THE FOLLOWING WE HAVE  n > n'                        */
                    /* principal quantum number, 1 for ground, upper level      */
                    long int n,
                    /* angular momentum, 0 for s                                */
                    long int l,
                    /* principal quantum number, 1 for ground, lower level      */
                    long int np,
                    /* angular momentum, 0 for s                                */                
                    long int lp,
                    /* Nuclear charge, 1 for H+, 2 for He++, etc                */               
                    long int iz
                    );


/************************************************************************/
/*   Calc the Oscillator Strength f(*) given by                         */
/*                                                                      */
/*                     E(n,l;n',l')     max(l,l')  |              | 2   */
/*   f(n,l;n',l') = -  ------------   ------------ | R(n,l;n',l') |     */
/*                      3 R_oo         ( 2l + 1 )  |              |     */
/*                                                                      */
/*       f(n,l;n',l') is dimensionless.                                 */
/*                                                                      */  
/*   See for example Gordan Drake's                                     */
/*      Atomic, Molecular, & Optical Physics Handbook pg.638            */
/*                                                                      */
/*  In the following, we have n > n'                                    */
/************************************************************************/
double OscStr_f(/*  IN THE FOLLOWING WE HAVE  n > n'                    */
                /* principal quantum number, 1 for ground, upper level  */
                long int n,
                /* angular momentum, 0 for s                            */
                long int l,
                /* principal quantum number, 1 for ground, lower level  */
                long int np,
                /* angular momentum, 0 for s                            */
                long int lp,
                /* Nuclear charge, 1 for H+, 2 for He++, etc            */
                long int iz
                );



/************************************************************************/
/*      This routine, hri(), calculates the hydrogen radial intergral,  */
/*      for the transition n,l --> n',l'                                */
/*      It is, of course, dimensionless.                                */
/*                                                                      */
/*  In the following, we have n > n'                                    */
/************************************************************************/
double hri(
           /* principal quantum number, 1 for ground, upper level       */
           long int n,
           /* angular momentum, 0 for s                                 */
           long int l,
           /* principal quantum number, 1 for ground, lower level       */
           long int np,
           /* angular momentum, 0 for s                                 */                  
           long int lp,
           /* Nuclear charge, 1 for H+, 2 for He++, etc                 */
           long int iz
           );

#if 0
/*    Semi-Classical Quantum Defect Radial Integral                     */      
double scqdri(
              double nstar,
              long   int l,
              double npstar,
              long   int lp,
              double iz
              );
#endif


/*************************** for LOG version of the file  ****************************************/
/*  In this version, quantites that would normal cause a 64-bit floating point processor        */
/* to underflowed or overflow on intermediate values (ones internal to the calculation)         */
/* are evaluated using logs. This allows us to use an upper principle quantum number `n'        */
/* greater than 50 which is where the other version begins to fail. The trade-off is,           */
/* of course, lower accuracy( or is it precision ) and perhaps speed.                           */
/*      We use LOG_10 for convenience.                                                          */
/************************************************************************************************/
/* The functions which are evaluated using logarithms are denoted with a trailing underscore.   */
/*      example:   hri_() calculates the same thing as hri_log10()                              */
/*      except it uses logs internally.                                                         */
/************************************************************************************************/
/* these are the hydrogenic routines written by Robert Bauman                                   */
/*      For references, see h_bauman.c                                                          */
/************************************************************************************************/
/*  IN THE FOLLOWING WE HAVE  n > n'                                                            */
/************************************************************************************************/

/* returns hydrogenic photoionization cross section in cm-2                          */
double H_photo_cs_log10(
                        /* incident photon energy                                    */
                        double photon_energy, 
                        /* principal quantum number, 1 for ground                    */
                        long int n, 
                        /* angular momentum, 0 for s                                 */
                        long int l, 
                        /* charge, 1 for H+, 2 for He++, etc                         */
                        long int iz
                        );

/************************************************************************/
/*   Calc the Oscillator Strength f(*) given by                         */
/*                                                                      */
/*                     E(n,l;n',l')     max(l,l')  |              | 2   */
/*   f(n,l;n',l') = -  ------------   ------------ | R(n,l;n',l') |     */
/*                      3 R_oo         ( 2l + 1 )  |              |     */
/*                                                                      */
/*       f(n,l;n',l') is dimensionless.                                 */
/*                                                                      */  
/*   See for example Gordan Drake's                                     */
/*      Atomic, Molecular, & Optical Physics Handbook pg.638            */
/*                                                                      */
/*  In the following, we have n > n'                                    */
/************************************************************************/
double OscStr_f_log10(
                      /*  IN THE FOLLOWING WE HAVE  n > n'                           */
                      /* principal quantum number, 1 for ground, upper level         */
                      long int n,
                      /* angular momentum, 0 for s                                   */
                      long int l,
                      /* principal quantum number, 1 for ground, lower level         */
                      long int np,
                      /* angular momentum, 0 for s                                   */
                      long int lp,
                      /* Nuclear charge, 1 for H+, 2 for He++, etc                   */
                      long int iz
                      );

/************************************************************************/
/*   Calculates the Einstein A's for hydrogen                           */
/*   for the transition n,l --> n',l'                                   */
/*   units of sec^(-1)                                                  */
/*                                                                      */
/*  In the following, we have n > n'                                    */
/************************************************************************/
double H_Einstein_A_log10(
                          /*  IN THE FOLLOWING WE HAVE  n > n'                       */
                          /* principal quantum number, 1 for ground, upper level     */
                          long int n,
                          /* angular momentum, 0 for s                               */
                          long int l,
                          /* principal quantum number, 1 for ground, lower level     */
                          long int np,
                          /* angular momentum, 0 for s                               */
                          long int lp,
                          /* Nuclear charge, 1 for H+, 2 for He++, etc               */
                          long int iz
                          );



/**************************************************************************/
/*  This routine, hri_log10(), calculates the hydrogen radial intergral,  */
/*  for the transition n,l --> n',l'                                      */
/*  It is, of course, dimensionless.                                      */
/*                                                                        */
/*  In the following, we have n > n'                                      */
/**************************************************************************/
double hri_log10(
                 /* principal quantum number, 1 for ground, upper level              */
                 long int n,
                 /* angular momentum, 0 for s                                        */
                 long int l,
                 /* principal quantum number, 1 for ground, lower level              */
                 long int np,
                 /* angular momentum, 0 for s                                        */
                 long int lp,
                 /* Nuclear charge, 1 for H+, 2 for He++, etc                        */
                 long int iz
                 );
