/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*HydroPhoCS_init -0 hydrogen cross sections */
#include "cddefines.h"
#include "hydrophocs.h"

/*threshold photoionization cross sections for hydrogen, by D. Verner
 * Version 1, Nov 24, 1997. Threshold photoionization cross sections
 * of hydrogenic levels. 0 - 1s, 1 - 2s, 2 - 2p, 3 - 3, ... , 400 - 400. */
void HydroPhoCS_init(void)
{
	long int I, 
	  _r;
	static int _aini = 1;
	if( _aini ){ /* Do 1 TIME INITIALIZATIONS! */
		{ static double _itmp0[] = {6.30384e-18,1.47826e-17,1.35514e-17};
		for( I=0, _r = 0; I <= 2; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp0[_r++];
			}
		}
		{ static double _itmp1[] = {2.15252e-17,2.92451e-17,3.69937e-17};
		for( I=3, _r = 0; I <= 5; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp1[_r++];
			}
		}
		{ static double _itmp2[] = {4.47616e-17,5.25435e-17,6.03362e-17};
		for( I=6, _r = 0; I <= 8; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp2[_r++];
			}
		}
		{ static double _itmp3[] = {6.81374e-17,7.59456e-17,8.37597e-17};
		for( I=9, _r = 0; I <= 11; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp3[_r++];
			}
		}
		{ static double _itmp4[] = {9.15787e-17,9.94019e-17,1.07229e-16};
		for( I=12, _r = 0; I <= 14; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp4[_r++];
			}
		}
		{ static double _itmp5[] = {1.15059e-16,1.22892e-16,1.30727e-16};
		for( I=15, _r = 0; I <= 17; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp5[_r++];
			}
		}
		{ static double _itmp6[] = {1.38565e-16,1.46405e-16,1.54247e-16};
		for( I=18, _r = 0; I <= 20; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp6[_r++];
			}
		}
		{ static double _itmp7[] = {1.62090e-16,1.69935e-16,1.77782e-16};
		for( I=21, _r = 0; I <= 23; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp7[_r++];
			}
		}
		{ static double _itmp8[] = {1.85629e-16,1.93478e-16,2.01328e-16};
		for( I=24, _r = 0; I <= 26; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp8[_r++];
			}
		}
		{ static double _itmp9[] = {2.09178e-16,2.17030e-16,2.24883e-16};
		for( I=27, _r = 0; I <= 29; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp9[_r++];
			}
		}
		{ static double _itmp10[] = {2.32736e-16,2.40590e-16,2.48445e-16};
		for( I=30, _r = 0; I <= 32; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp10[_r++];
			}
		}
		{ static double _itmp11[] = {2.56300e-16,2.64156e-16,2.72012e-16};
		for( I=33, _r = 0; I <= 35; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp11[_r++];
			}
		}
		{ static double _itmp12[] = {2.79869e-16,2.87726e-16,2.95584e-16};
		for( I=36, _r = 0; I <= 38; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp12[_r++];
			}
		}
		{ static double _itmp13[] = {3.03442e-16,3.11300e-16,3.19159e-16};
		for( I=39, _r = 0; I <= 41; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp13[_r++];
			}
		}
		{ static double _itmp14[] = {3.27018e-16,3.34877e-16,3.42737e-16};
		for( I=42, _r = 0; I <= 44; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp14[_r++];
			}
		}
		{ static double _itmp15[] = {3.50597e-16,3.58457e-16,3.66317e-16};
		for( I=45, _r = 0; I <= 47; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp15[_r++];
			}
		}
		{ static double _itmp16[] = {3.74177e-16,3.82038e-16,3.89898e-16};
		for( I=48, _r = 0; I <= 50; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp16[_r++];
			}
		}
		{ static double _itmp17[] = {3.97759e-16,4.05620e-16,4.13481e-16};
		for( I=51, _r = 0; I <= 53; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp17[_r++];
			}
		}
		{ static double _itmp18[] = {4.21342e-16,4.29203e-16,4.37064e-16};
		for( I=54, _r = 0; I <= 56; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp18[_r++];
			}
		}
		{ static double _itmp19[] = {4.44925e-16,4.52786e-16,4.60647e-16};
		for( I=57, _r = 0; I <= 59; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp19[_r++];
			}
		}
		{ static double _itmp20[] = {4.68508e-16,4.76369e-16,4.84231e-16};
		for( I=60, _r = 0; I <= 62; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp20[_r++];
			}
		}
		{ static double _itmp21[] = {4.92092e-16,4.99953e-16,5.07814e-16};
		for( I=63, _r = 0; I <= 65; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp21[_r++];
			}
		}
		{ static double _itmp22[] = {5.15675e-16,5.23536e-16,5.31397e-16};
		for( I=66, _r = 0; I <= 68; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp22[_r++];
			}
		}
		{ static double _itmp23[] = {5.39257e-16,5.47118e-16,5.54979e-16};
		for( I=69, _r = 0; I <= 71; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp23[_r++];
			}
		}
		{ static double _itmp24[] = {5.62839e-16,5.70700e-16,5.78560e-16};
		for( I=72, _r = 0; I <= 74; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp24[_r++];
			}
		}
		{ static double _itmp25[] = {5.86420e-16,5.94280e-16,6.02140e-16};
		for( I=75, _r = 0; I <= 77; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp25[_r++];
			}
		}
		{ static double _itmp26[] = {6.10000e-16,6.17860e-16,6.25719e-16};
		for( I=78, _r = 0; I <= 80; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp26[_r++];
			}
		}
		{ static double _itmp27[] = {6.33579e-16,6.41438e-16,6.49297e-16};
		for( I=81, _r = 0; I <= 83; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp27[_r++];
			}
		}
		{ static double _itmp28[] = {6.57156e-16,6.65015e-16,6.72873e-16};
		for( I=84, _r = 0; I <= 86; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp28[_r++];
			}
		}
		{ static double _itmp29[] = {6.80732e-16,6.88590e-16,6.96448e-16};
		for( I=87, _r = 0; I <= 89; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp29[_r++];
			}
		}
		{ static double _itmp30[] = {7.04306e-16,7.12164e-16,7.20021e-16};
		for( I=90, _r = 0; I <= 92; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp30[_r++];
			}
		}
		{ static double _itmp31[] = {7.27879e-16,7.35736e-16,7.43593e-16};
		for( I=93, _r = 0; I <= 95; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp31[_r++];
			}
		}
		{ static double _itmp32[] = {7.51450e-16,7.59306e-16,7.67163e-16};
		for( I=96, _r = 0; I <= 98; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp32[_r++];
			}
		}
		{ static double _itmp33[] = {7.75019e-16,7.82875e-16,7.90730e-16};
		for( I=99, _r = 0; I <= 101; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp33[_r++];
			}
		}
		{ static double _itmp34[] = {7.98586e-16,8.06441e-16,8.14296e-16};
		for( I=102, _r = 0; I <= 104; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp34[_r++];
			}
		}
		{ static double _itmp35[] = {8.22151e-16,8.30005e-16,8.37860e-16};
		for( I=105, _r = 0; I <= 107; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp35[_r++];
			}
		}
		{ static double _itmp36[] = {8.45714e-16,8.53568e-16,8.61421e-16};
		for( I=108, _r = 0; I <= 110; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp36[_r++];
			}
		}
		{ static double _itmp37[] = {8.69275e-16,8.77128e-16,8.84981e-16};
		for( I=111, _r = 0; I <= 113; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp37[_r++];
			}
		}
		{ static double _itmp38[] = {8.92833e-16,9.00686e-16,9.08538e-16};
		for( I=114, _r = 0; I <= 116; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp38[_r++];
			}
		}
		{ static double _itmp39[] = {9.16390e-16,9.24241e-16,9.32093e-16};
		for( I=117, _r = 0; I <= 119; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp39[_r++];
			}
		}
		{ static double _itmp40[] = {9.39944e-16,9.47795e-16,9.55645e-16};
		for( I=120, _r = 0; I <= 122; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp40[_r++];
			}
		}
		{ static double _itmp41[] = {9.63495e-16,9.71345e-16,9.79195e-16};
		for( I=123, _r = 0; I <= 125; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp41[_r++];
			}
		}
		{ static double _itmp42[] = {9.87045e-16,9.94894e-16,1.00274e-15};
		for( I=126, _r = 0; I <= 128; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp42[_r++];
			}
		}
		{ static double _itmp43[] = {1.01059e-15,1.01844e-15,1.02629e-15};
		for( I=129, _r = 0; I <= 131; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp43[_r++];
			}
		}
		{ static double _itmp44[] = {1.03414e-15,1.04198e-15,1.04983e-15};
		for( I=132, _r = 0; I <= 134; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp44[_r++];
			}
		}
		{ static double _itmp45[] = {1.05768e-15,1.06552e-15,1.07337e-15};
		for( I=135, _r = 0; I <= 137; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp45[_r++];
			}
		}
		{ static double _itmp46[] = {1.08122e-15,1.08906e-15,1.09691e-15};
		for( I=138, _r = 0; I <= 140; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp46[_r++];
			}
		}
		{ static double _itmp47[] = {1.10475e-15,1.11260e-15,1.12044e-15};
		for( I=141, _r = 0; I <= 143; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp47[_r++];
			}
		}
		{ static double _itmp48[] = {1.12829e-15,1.13613e-15,1.14397e-15};
		for( I=144, _r = 0; I <= 146; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp48[_r++];
			}
		}
		{ static double _itmp49[] = {1.15182e-15,1.15966e-15,1.16750e-15};
		for( I=147, _r = 0; I <= 149; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp49[_r++];
			}
		}
		{ static double _itmp50[] = {1.17535e-15,1.18319e-15,1.19103e-15};
		for( I=150, _r = 0; I <= 152; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp50[_r++];
			}
		}
		{ static double _itmp51[] = {1.19887e-15,1.20671e-15,1.21455e-15};
		for( I=153, _r = 0; I <= 155; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp51[_r++];
			}
		}
		{ static double _itmp52[] = {1.22239e-15,1.23023e-15,1.23807e-15};
		for( I=156, _r = 0; I <= 158; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp52[_r++];
			}
		}
		{ static double _itmp53[] = {1.24591e-15,1.25375e-15,1.26159e-15};
		for( I=159, _r = 0; I <= 161; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp53[_r++];
			}
		}
		{ static double _itmp54[] = {1.26943e-15,1.27727e-15,1.28511e-15};
		for( I=162, _r = 0; I <= 164; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp54[_r++];
			}
		}
		{ static double _itmp55[] = {1.29295e-15,1.30078e-15,1.30862e-15};
		for( I=165, _r = 0; I <= 167; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp55[_r++];
			}
		}
		{ static double _itmp56[] = {1.31646e-15,1.32429e-15,1.33213e-15};
		for( I=168, _r = 0; I <= 170; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp56[_r++];
			}
		}
		{ static double _itmp57[] = {1.33997e-15,1.34780e-15,1.35564e-15};
		for( I=171, _r = 0; I <= 173; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp57[_r++];
			}
		}
		{ static double _itmp58[] = {1.36347e-15,1.37130e-15,1.37914e-15};
		for( I=174, _r = 0; I <= 176; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp58[_r++];
			}
		}
		{ static double _itmp59[] = {1.38697e-15,1.39481e-15,1.40264e-15};
		for( I=177, _r = 0; I <= 179; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp59[_r++];
			}
		}
		{ static double _itmp60[] = {1.41047e-15,1.41830e-15,1.42614e-15};
		for( I=180, _r = 0; I <= 182; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp60[_r++];
			}
		}
		{ static double _itmp61[] = {1.43397e-15,1.44180e-15,1.44963e-15};
		for( I=183, _r = 0; I <= 185; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp61[_r++];
			}
		}
		{ static double _itmp62[] = {1.45746e-15,1.46529e-15,1.47312e-15};
		for( I=186, _r = 0; I <= 188; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp62[_r++];
			}
		}
		{ static double _itmp63[] = {1.48095e-15,1.48878e-15,1.49661e-15};
		for( I=189, _r = 0; I <= 191; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp63[_r++];
			}
		}
		{ static double _itmp64[] = {1.50444e-15,1.51227e-15,1.52010e-15};
		for( I=192, _r = 0; I <= 194; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp64[_r++];
			}
		}
		{ static double _itmp65[] = {1.52792e-15,1.53575e-15,1.54358e-15};
		for( I=195, _r = 0; I <= 197; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp65[_r++];
			}
		}
		{ static double _itmp66[] = {1.55140e-15,1.55923e-15,1.56706e-15};
		for( I=198, _r = 0; I <= 200; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp66[_r++];
			}
		}
		{ static double _itmp67[] = {1.57488e-15,1.58271e-15,1.59053e-15};
		for( I=201, _r = 0; I <= 203; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp67[_r++];
			}
		}
		{ static double _itmp68[] = {1.59836e-15,1.60618e-15,1.61400e-15};
		for( I=204, _r = 0; I <= 206; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp68[_r++];
			}
		}
		{ static double _itmp69[] = {1.62183e-15,1.62965e-15,1.63747e-15};
		for( I=207, _r = 0; I <= 209; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp69[_r++];
			}
		}
		{ static double _itmp70[] = {1.64530e-15,1.65312e-15,1.66094e-15};
		for( I=210, _r = 0; I <= 212; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp70[_r++];
			}
		}
		{ static double _itmp71[] = {1.66876e-15,1.67658e-15,1.68440e-15};
		for( I=213, _r = 0; I <= 215; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp71[_r++];
			}
		}
		{ static double _itmp72[] = {1.69222e-15,1.70004e-15,1.70786e-15};
		for( I=216, _r = 0; I <= 218; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp72[_r++];
			}
		}
		{ static double _itmp73[] = {1.71568e-15,1.72350e-15,1.73132e-15};
		for( I=219, _r = 0; I <= 221; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp73[_r++];
			}
		}
		{ static double _itmp74[] = {1.73914e-15,1.74695e-15,1.75477e-15};
		for( I=222, _r = 0; I <= 224; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp74[_r++];
			}
		}
		{ static double _itmp75[] = {1.76259e-15,1.77040e-15,1.77822e-15};
		for( I=225, _r = 0; I <= 227; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp75[_r++];
			}
		}
		{ static double _itmp76[] = {1.78604e-15,1.79385e-15,1.80167e-15};
		for( I=228, _r = 0; I <= 230; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp76[_r++];
			}
		}
		{ static double _itmp77[] = {1.80948e-15,1.81730e-15,1.82511e-15};
		for( I=231, _r = 0; I <= 233; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp77[_r++];
			}
		}
		{ static double _itmp78[] = {1.83292e-15,1.84074e-15,1.84855e-15};
		for( I=234, _r = 0; I <= 236; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp78[_r++];
			}
		}
		{ static double _itmp79[] = {1.85636e-15,1.86418e-15,1.87199e-15};
		for( I=237, _r = 0; I <= 239; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp79[_r++];
			}
		}
		{ static double _itmp80[] = {1.87980e-15,1.88761e-15,1.89542e-15};
		for( I=240, _r = 0; I <= 242; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp80[_r++];
			}
		}
		{ static double _itmp81[] = {1.90323e-15,1.91104e-15,1.91885e-15};
		for( I=243, _r = 0; I <= 245; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp81[_r++];
			}
		}
		{ static double _itmp82[] = {1.92666e-15,1.93447e-15,1.94228e-15};
		for( I=246, _r = 0; I <= 248; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp82[_r++];
			}
		}
		{ static double _itmp83[] = {1.95008e-15,1.95789e-15,1.96570e-15};
		for( I=249, _r = 0; I <= 251; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp83[_r++];
			}
		}
		{ static double _itmp84[] = {1.97351e-15,1.98131e-15,1.98912e-15};
		for( I=252, _r = 0; I <= 254; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp84[_r++];
			}
		}
		{ static double _itmp85[] = {1.99693e-15,2.00473e-15,2.01254e-15};
		for( I=255, _r = 0; I <= 257; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp85[_r++];
			}
		}
		{ static double _itmp86[] = {2.02034e-15,2.02814e-15,2.03595e-15};
		for( I=258, _r = 0; I <= 260; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp86[_r++];
			}
		}
		{ static double _itmp87[] = {2.04375e-15,2.05156e-15,2.05936e-15};
		for( I=261, _r = 0; I <= 263; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp87[_r++];
			}
		}
		{ static double _itmp88[] = {2.06716e-15,2.07496e-15,2.08276e-15};
		for( I=264, _r = 0; I <= 266; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp88[_r++];
			}
		}
		{ static double _itmp89[] = {2.09057e-15,2.09837e-15,2.10617e-15};
		for( I=267, _r = 0; I <= 269; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp89[_r++];
			}
		}
		{ static double _itmp90[] = {2.11397e-15,2.12177e-15,2.12957e-15};
		for( I=270, _r = 0; I <= 272; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp90[_r++];
			}
		}
		{ static double _itmp91[] = {2.13736e-15,2.14516e-15,2.15296e-15};
		for( I=273, _r = 0; I <= 275; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp91[_r++];
			}
		}
		{ static double _itmp92[] = {2.16076e-15,2.16856e-15,2.17635e-15};
		for( I=276, _r = 0; I <= 278; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp92[_r++];
			}
		}
		{ static double _itmp93[] = {2.18415e-15,2.19195e-15,2.19974e-15};
		for( I=279, _r = 0; I <= 281; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp93[_r++];
			}
		}
		{ static double _itmp94[] = {2.20754e-15,2.21533e-15,2.22313e-15};
		for( I=282, _r = 0; I <= 284; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp94[_r++];
			}
		}
		{ static double _itmp95[] = {2.23092e-15,2.23872e-15,2.24651e-15};
		for( I=285, _r = 0; I <= 287; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp95[_r++];
			}
		}
		{ static double _itmp96[] = {2.25430e-15,2.26210e-15,2.26989e-15};
		for( I=288, _r = 0; I <= 290; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp96[_r++];
			}
		}
		{ static double _itmp97[] = {2.27768e-15,2.28547e-15,2.29326e-15};
		for( I=291, _r = 0; I <= 293; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp97[_r++];
			}
		}
		{ static double _itmp98[] = {2.30105e-15,2.30884e-15,2.31663e-15};
		for( I=294, _r = 0; I <= 296; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp98[_r++];
			}
		}
		{ static double _itmp99[] = {2.32442e-15,2.33221e-15,2.34000e-15};
		for( I=297, _r = 0; I <= 299; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp99[_r++];
			}
		}
		{ static double _itmp100[] = {2.34779e-15,2.35558e-15,2.36336e-15};
		for( I=300, _r = 0; I <= 302; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp100[_r++];
			}
		}
		{ static double _itmp101[] = {2.37115e-15,2.37894e-15,2.38673e-15};
		for( I=303, _r = 0; I <= 305; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp101[_r++];
			}
		}
		{ static double _itmp102[] = {2.39451e-15,2.40230e-15,2.41008e-15};
		for( I=306, _r = 0; I <= 308; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp102[_r++];
			}
		}
		{ static double _itmp103[] = {2.41787e-15,2.42565e-15,2.43344e-15};
		for( I=309, _r = 0; I <= 311; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp103[_r++];
			}
		}
		{ static double _itmp104[] = {2.44122e-15,2.44900e-15,2.45679e-15};
		for( I=312, _r = 0; I <= 314; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp104[_r++];
			}
		}
		{ static double _itmp105[] = {2.46457e-15,2.47235e-15,2.48013e-15};
		for( I=315, _r = 0; I <= 317; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp105[_r++];
			}
		}
		{ static double _itmp106[] = {2.48791e-15,2.49569e-15,2.50347e-15};
		for( I=318, _r = 0; I <= 320; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp106[_r++];
			}
		}
		{ static double _itmp107[] = {2.51125e-15,2.51903e-15,2.52681e-15};
		for( I=321, _r = 0; I <= 323; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp107[_r++];
			}
		}
		{ static double _itmp108[] = {2.53459e-15,2.54237e-15,2.55015e-15};
		for( I=324, _r = 0; I <= 326; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp108[_r++];
			}
		}
		{ static double _itmp109[] = {2.55793e-15,2.56570e-15,2.57348e-15};
		for( I=327, _r = 0; I <= 329; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp109[_r++];
			}
		}
		{ static double _itmp110[] = {2.58126e-15,2.58903e-15,2.59681e-15};
		for( I=330, _r = 0; I <= 332; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp110[_r++];
			}
		}
		{ static double _itmp111[] = {2.60458e-15,2.61236e-15,2.62013e-15};
		for( I=333, _r = 0; I <= 335; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp111[_r++];
			}
		}
		{ static double _itmp112[] = {2.62791e-15,2.63568e-15,2.64345e-15};
		for( I=336, _r = 0; I <= 338; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp112[_r++];
			}
		}
		{ static double _itmp113[] = {2.65123e-15,2.65900e-15,2.66677e-15};
		for( I=339, _r = 0; I <= 341; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp113[_r++];
			}
		}
		{ static double _itmp114[] = {2.67454e-15,2.68231e-15,2.69008e-15};
		for( I=342, _r = 0; I <= 344; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp114[_r++];
			}
		}
		{ static double _itmp115[] = {2.69785e-15,2.70563e-15,2.71339e-15};
		for( I=345, _r = 0; I <= 347; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp115[_r++];
			}
		}
		{ static double _itmp116[] = {2.72116e-15,2.72893e-15,2.73670e-15};
		for( I=348, _r = 0; I <= 350; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp116[_r++];
			}
		}
		{ static double _itmp117[] = {2.74447e-15,2.75224e-15,2.76000e-15};
		for( I=351, _r = 0; I <= 353; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp117[_r++];
			}
		}
		{ static double _itmp118[] = {2.76777e-15,2.77554e-15,2.78330e-15};
		for( I=354, _r = 0; I <= 356; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp118[_r++];
			}
		}
		{ static double _itmp119[] = {2.79107e-15,2.79883e-15,2.80660e-15};
		for( I=357, _r = 0; I <= 359; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp119[_r++];
			}
		}
		{ static double _itmp120[] = {2.81436e-15,2.82213e-15,2.82989e-15};
		for( I=360, _r = 0; I <= 362; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp120[_r++];
			}
		}
		{ static double _itmp121[] = {2.83765e-15,2.84541e-15,2.85318e-15};
		for( I=363, _r = 0; I <= 365; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp121[_r++];
			}
		}
		{ static double _itmp122[] = {2.86094e-15,2.86870e-15,2.87646e-15};
		for( I=366, _r = 0; I <= 368; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp122[_r++];
			}
		}
		{ static double _itmp123[] = {2.88422e-15,2.89198e-15,2.89974e-15};
		for( I=369, _r = 0; I <= 371; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp123[_r++];
			}
		}
		{ static double _itmp124[] = {2.90750e-15,2.91526e-15,2.92302e-15};
		for( I=372, _r = 0; I <= 374; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp124[_r++];
			}
		}
		{ static double _itmp125[] = {2.93078e-15,2.93853e-15,2.94629e-15};
		for( I=375, _r = 0; I <= 377; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp125[_r++];
			}
		}
		{ static double _itmp126[] = {2.95405e-15,2.96180e-15,2.96956e-15};
		for( I=378, _r = 0; I <= 380; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp126[_r++];
			}
		}
		{ static double _itmp127[] = {2.97732e-15,2.98507e-15,2.99283e-15};
		for( I=381, _r = 0; I <= 383; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp127[_r++];
			}
		}
		{ static double _itmp128[] = {3.00058e-15,3.00833e-15,3.01609e-15};
		for( I=384, _r = 0; I <= 386; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp128[_r++];
			}
		}
		{ static double _itmp129[] = {3.02384e-15,3.03159e-15,3.03935e-15};
		for( I=387, _r = 0; I <= 389; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp129[_r++];
			}
		}
		{ static double _itmp130[] = {3.04710e-15,3.05485e-15,3.06260e-15};
		for( I=390, _r = 0; I <= 392; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp130[_r++];
			}
		}
		{ static double _itmp131[] = {3.07035e-15,3.07810e-15,3.08585e-15};
		for( I=393, _r = 0; I <= 395; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp131[_r++];
			}
		}
		{ static double _itmp132[] = {3.09360e-15,3.10135e-15,3.10910e-15};
		for( I=396, _r = 0; I <= 398; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp132[_r++];
			}
		}
		{ static double _itmp133[] = {3.11685e-15,3.12459e-15};
		for( I=399, _r = 0; I <= 400; I++ )
		{
			HydroPhoCS.STH[I] = (float)_itmp133[_r++];
			}
		}
		_aini = 0;
	}

#	ifdef DEBUG_FUN
	fputs( "<+>blkdata0()\n", debug_fp );
#	endif

#	ifdef DEBUG_FUN
	fputs( " <->blkdata0()\n", debug_fp );
#	endif
}

