/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* hmi.h - parameters dealing with hydrogen molecules */
EXTERN struct t_hmi {

	/* densities (cm-3) of H2, H2+, H-, H3+ */
	float Molec[N_H_MOLEC];
	int protons[N_H_MOLEC];

	/* the associative detachment H- + H => H2 + e rate coef */
	double assoc_detach;

	/*rate for process H2+ + H => H2 + H+ */
	double bh2h2p;

	/* rate H2 goes from all X into either J=1 (ortho) 
	 * or (J=0) para on grain surfaces - units s-1*/
	double rate_h2_allX_2_J0_grains,
		rate_h2_ortho_para_conserve;

	/* the total H2 abundance, the sum of H2 and H2* */
	float htwo_total;

	/* hminus heating, free bound */
	double hmihet, 
	  hmitot, 
	  hmicol;

	/* mean cross section (cm-2) for H2 Lyman absorption */
	float H2Opacity;

	/* these are departure coef for H-, H2, H2+, and HeH,
	 * defined in hmole */
	double hmidep, 
	  h2dep, 
	  h2pdep, 
	  h3pdep;

	/* heating due to photo dissoc of H2+ */
	double h2plus_heat;

	/* the lte population of H2  */
	double ph2lte;

	/* H- photo dissoc rate */
	double HMinus_photo_rate;

	float 
	  /* the largest fraction of total heat anywhere in model */
	  HeatH2DexcMax,
	  /* the largest fraction of total cooling anywhere in model */
	  CoolH2DexcMax,
	  h2dfrc, 
	  h2dtot,
	  /* fraqction of cooling carried by H2 lines */
	  h2line_cool_frac;

	long int iheh1, 
	  iheh2;

	/* rate hi dest H_2 */
	float rh2dis;

	/* Ha creation due to H- charge transfer */
	float HalphaHmin;

	/* max H2/H ratio that occured in the calculation, set in hmole */
	float BiggestH2;

	/* flag saying that hydrogen molecules all into H2 */
	int lgAll_H2;

	/* UV flux relative to Habing value, used for some simple molecular photodissociation rates */
	float GammaHabing;

	/* the Solomon process dissocate rate from Tielens & Hollenbach 85 */
	double H2_Solomon_rate_TH85 ;

	/* the Solomon process dissocate rate from Bertoldi & Draine 96 */
	double H2_Solomon_rate_BD96 ;

	/* the Solomon process dissocate rate (s-1) from large molecules */
	double H2_Solomon_rate_BigH2 ;

	/* the Solomon process rate H2 dissociates into X continuum - actually used */
	double H2_Solomon_rate_used;

	/* H2 + hnu => 2H from big molecule */
	double H2_photodissoc_BigH2;

	/* H2 + hnu => 2H from TH85 */
	double H2_photodissoc_TH85;

	/* H2 + hnu => 2H actually used */
	double H2_photodissoc_used ;

	/* says whether big H2 has ever been evaluated in this run - if it has
	 * not been then use TH85 physics for mole balance and cooling */
	int lgBigH2_evaluated;

	/* continuum array index for H minus threshold  */
	long int iphmin;

	/* largest local fraction heating due to dissoc of H2+ */
	float h2pmax;

	float 
	  /* HeatH2Dish_used is heating due to H2 dissociation actually used*/
	  HeatH2Dish_used, 
	  /* HeatH2Dexc_used is heating due to collisional deexcitation of vib-excited H2 actually used */
	  HeatH2Dexc_used,
	  /* HeatH2Dish_BigH2 is heating due to H2 dissociation from big H2 molecule*/
	  HeatH2Dish_BigH2, 
	  /* HeatH2Dexc_BigH2 is heating due to collisional deexcitation of vib-excited H2 from big H2 molecule */
	  HeatH2Dexc_BigH2,
	  /* HeatH2Dish_TH85 is heating due to H2 dissociation from TH85 */
	  HeatH2Dish_TH85, 
	  /* HeatH2Dexc_TH85 is heating due to collisional deexcitation of vib-excited H2 from TH85  */
	  HeatH2Dexc_TH85;

	/* these are deriv wrt temp for collis processes wihtin X */
	float deriv_HeatH2Dexc_TH85 ,
		deriv_HeatH2Dexc_BigH2 ,
		deriv_HeatH2Dexc_used ;

	/* say how to do thermal soln, if true (default) use results of large molecule,
	 * if false use TH85 approximations */
	int lgH2_Thermal_BigH2,
	/* say how to do chemistry (formation and destruction), 
	 * if true (default) use results of large molecule,
	 * if false use TH85 approximations */
	  lgH2_Chemistry_BigH2;

	}	hmi;

enum {ipMH,ipMHp,ipMHm,ipMH2,ipMH2p,ipMH3p,ipMH2s,ipMHeHp};

