/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* following two macros used to define recombination coef arrays */
/* Max n desired in RRCoef file.	*/
/* >>chng 02 jan 28, from 10 to 20 so large HeI tests are fast */
/* this is the number of levels used with the
 * atom he-like levels large command */
/* Helium itself will have precompiled recombination coefficients up to this maximum n.	*/
#define HE_RREC_MAXN		40

/* Ions of the sequence will go up to this n.	*/
#define HE_LIKE_RREC_MAXN		10

#define N_HE_TE_RECOMB		21

/* This is the n to go up to when calculating total recombination.	Any change 
 * here will not be reflected in total recomb until "compile helike" is run	*/
#define SumUpToThisN	500

/* Set this flag to one of the following values
 *	0	don't print
 *	1	print As
 *	2	print only forbidden As
 *	3	print Es
 *	4	print Threshold Photoionizing Cross-Sections
 *	5	print radiative recombination coefficients.	
 *  6   print Photoionizing Cross-Section grids.	*/
/* Out files are "Helike___.txt" with the blank being, respectively,
 *	"As","fAs","Es","ThPCS","RR", and "PCSgrid."	*/
#define	printflag	(0)

/* temperatures at which CS for He1 are stored */
#define HE1CSARRAY 10
/* the magic number for the table of recombination coefficients, YYMMDD */
/* >>chng 02 mar 08, data structure the same but improved fits to He photo cs */
#define RECOMBMAGIC		(20425)

/* He-like main routine to call HeLevel and determine 
 * model he-like species atom level balance	*/
void HeLike(void);

/* create he-like series */
void HeCreate(void);

/*He_ParseAtom parse parameters off the helium command */
void He_ParseAtom(char *chCard );

/* routine to print departure coefficients for he-like species */
void prt_He_like_DeparCoef(long int nelem );

/* routine to print level pops for he-like species */
void prt_He_like_Pops(long int nelem );

/* Calculate "EnergyWN" for 4 autoionizing levels of each
 * "turned-on" element.	*/
void He1Autoionize(void);

/*HelikeCheckRecomb - called by SanityCheck to confirm that recombination coef are ok,
 * return value is relative error between new calculation of recom, and interp value */
double HelikeCheckRecomb(
	/* the chemical element, 1 for He */
	long nelem ,
	/* the level, 0 for ground */
	long level ,
	/* the temperature to be used */
	double temperature );

/* routine to punch table needed for AGN3 - collision strengths of HeI */
void AGN_He1_CS( FILE *ioPun );

/*He_cross_section returns cross section (cm^-2), 
 * given EgammaRyd, the photon energy in Ryd,
 * ipLevel, the index of the level, 0 is ground, 3 within 2 3P,
 * ipZ is charge, equal to 1 for Helium,
 * this is a wrapper for cross_section */
double He_cross_section( double EgammaRyd , long ipLevel , long ipZ );

/* all of these are initialized in zero */
EXTERN struct t_helike 
{
	double he2sdest;

	/* flag saying whether to use a set of physics meant to 
	 * replicate the Benjamin et al. HeI results 
	 * set with ATOM HE-LIKE BENJAMIN command */
	int lgSetBenjamin;

	/* number of CS in the above array */
	long int nCS;

	/* Hy2nu is hydrogen two photon, others He1 and He2 */
	float *he12nu/*[NC_ELL]*/;

	/* flag set by compile he-like command, says to regenerate table of recombination coef */
	int lgCompileRecomb;

	/* parameters for changing gbar - set with set hegbar command */
	int lgCS_Vriens ,
		lgCS_None ,
		lgCS_new ;

	/* used to print warning if density too low for first collapsed level to be l-mixed	*/
	int lgCritDensLMix;

 	/* flag saying whether to include fine-structure mixing in spontaneous decays	
	 * set with ATOM HE-LIKE FSM command */
	int lgFSM;

	/* will be lifetime of each level of each species in sequence.	*/
	double **Lifetime;
	
	/* array of collision strengths read from data file...this is interpolated upon.	*/
	float ****HeCS;
	
	/* vector of temperatures corresponding to collision strengths stuffed into HeCS.	*/
	double CSTemp[HE1CSARRAY];

	/* This three ONLY differ from the corresponding components of the iso structure in that
	 * the size of the atom may have to be truncated due to continuum lowering.  But we do not change
	 * the values in iso, because they will define the biggest size possible, and are used to 
	 * malloc arrays one time only.	*/ 
	long int *numLevels;
	long int *nCollapsed;
	long int *n_HighestResolved;

	/* This variable is set to true if the model is full size in the sense that all levels below
	 * continuum are considered.	*/
	int *lgFullSize;
		 
}	helike;
