/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*HeatPunch punch contributors to local heating, with punch heat command */
void HeatPunch(FILE* io);

/* heat.h */
EXTERN struct t_heat {

	/*HeatNet is heating due to individual species */
	double HeatNet, 

		/* this is the part of the heating that cannot do secondary ionizations */
		HeatLowEnr ,

		/* this is the part of the heating that does secondaries, but without efficiency */
		HeatHiEnr ,

		/* total heat input to this zone */
		htot, 

		/* total energy input over calculated structure, updated in lines */
		power, 

		/* derivative of total heating in this zone, evaluated in SumHeat*/
		dHTotDT;

		/* heating per unit vol, erg cm^-3 s^-1, heating[nelem][ion]  */
		double heating[LIMELM][LIMELM];

		/* total free free heating integrated over model */
		double FreeFreeTotHeat;
	  
	}	heat;

