/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/* dense.h density laws */

/* variables dealing with pressure across model */
EXTERN struct t_dense {

	/* dense.gas_phase is the total gas phase abundances, including any of element within molecules,
	 * but not including grains */
	/* this is total sum of all non-molecules for all elements except H,
	 * for H this is the sum of everything computed in hmole */
	float gas_phase[LIMELM];

	/* dense.xMolecules density of elements locked in molecules, 
	 * this is included in gas_phase */
	/* this is total sum of all molecules for all elements except H,
	 * for H this is the sum of molecules that is computed in co - this does not include
	 * molecules computed in hmole */
	float xMolecules[LIMELM];

	/* dense.xIonDense[nelem][i] is density of ith ionization stage (cm^-3),
	 * [nelem][0] is atom, [][1]) the first ion
	 * nelem = 0 for H, 1 for he, etc
	 *
	 * with this scheme, 
	 * OIII is dense.xIonDense[ipOXYGEN][2]
	 * HII is dense.xIonDense[ipHYDROGEN][1] */

	/* at the moment 12CO, 13CO, and H2 are xIonDense[LIMELM][2], [L+1][3] and [L+2][1] */
	float xIonDense[LIMELM+3][LIMELM+1];

	/* array of logical variables saying whether an element is enable (TRUE)
	 * or disabled (FALSE).  It is set totally TRUE in zero
	 * and is set FALSE with the "element off" command.  
	 * In SetAbundances if can be reset so that an element that was disabled
	 * on the first model in a coreload is not later enabled */
	int lgElmtOn[LIMELM];

	/* will we solve for ionization (FALSE) or specify it with element ionization cmnd TRUE */
	int lgSetIoniz[LIMELM];

	/* dense.SetIoniz the ionization fractions that are set when lgSetIoniz set true,
	 * gas phase abundance is this times total aabundance
	 * Ionization fraction for [nelem][ion] */
	float SetIoniz[LIMELM][LIMELM];

	/* label describing the density law for current calculation
	 * 'DLW2' is tabden interpolated table */
	char chDenseLaw[5];

	/* parameters set by the dlaw command, used by fabden (maybe) */
	double DensityLaw[10];

#	define	LIMTABDLAW	500

	/*frad is log radius in cm, fhden is log hden*/
	float frad[LIMTABDLAW], 
	  fhden[LIMTABDLAW];

	/*number of values in above table */
	long int nvals;

	/*lg is true if depth, false if radius to be used*/
	int lgDLWDepth;

	/* electron density */
	double eden;

	/* hydrogen density in ALL gas phase forms, includes molecules, ie, 2*n(H_2), etc
	double hden; */

	/* parameters dealing with hydrogen density scaling as power of radius
	 *DensityPower is power */
	float DensityPower, 
	  rscale, 
	  den0;

} dense;
