/* This file is part of Cloudy and is copyright (C) 1978-2003 by Gary J. Ferland.
 * For conditions of distribution and use, see copyright notice in license.txt */
/*CoolNick compute nickel cooling */
#include "cddefines.h"
#include "taulines.h"
#include "level2.h"
#include "phycon.h"
#include "lines_service.h"
#include "thermal.h"
#include "cooling.h"

void CoolNick()
{
	double cs;

#	ifdef DEBUG_FUN
	fputs( "<+>CoolNick()\n", debug_fp );
#	endif

	/* [Ni XII] 4230.8A
	 * Y(ik) from 
	 * >>refer	ni12	cs	Pelan, J., & Berrington, K.A. 1995, A&A Suppl, 110, 209
	 * call PutCS( 1.68 , xNi1242 )
	 * >>chng 98 jan 09, update collision strength to 
	 * >>refer	ni12	cs	Mathews, A., Ramsbottom, C.A., Bell, K.L., & Keenan, F.P., 1998,
	 * >>refercon ApJ 492, 415 */
	if( phycon.alogte < 5.4 )
	{
		cs = MAX2(0.6,0.6+0.8182*(phycon.alogte-3.2));
	}
	else
	{
		cs = MAX2(0.6,2.4-1.5*(phycon.alogte-5.4));
	}
	PutCS(cs,&TauLines[ipxNi1242]);
	level2(&TauLines[ipxNi1242]);

#	ifdef DEBUG_FUN
	fputs( " <->CoolNick()\n", debug_fp );
#	endif
	return;
}

